@extends('layouts.dash')

@section('title') Employeurs @stop
@section('title_card') Consultation d'une fiche d'un Employeur @stop

@section('content')
    <div class="card card-info">
        <div class="card-header">
            <h3 class="card-title">{!! $employeur->nom !!}</h3>
        </div>
        <div class='card-body'>
            {{ html()->modelForm($employeur)->attributes(['employeur' => 'form', 'class' => 'form-horizontal', ])->open() }}
                @include("tiers.employeurs.content")
            {{ html()->closeModelForm() }}
        </div>
    </div>
@endsection


@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop


@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script>
    <script src="{{ url('js/magicsuggest.js') }}"></script>

    @include('tiers.employeurs.scripts_employeur');
@stop



