@if($mode!="create")
    <div class="form-group">
        <div class="col-md-3">
            {!! html()->label( 'N°&nbsp;','id') !!}
            {!! html()->text('id', isset($enfant)?str_pad($enfant->id, 6, "0", STR_PAD_LEFT):'')
                ->attributes(['disabled', 'class' => 'form-control text-uppercase']) !!}
        </div>
    </div>
@endif

<div class='form-group row'>
    <div class="col-md-5">
        {!! html()->label( 'NOM','nom') !!}
        {!! html()->text('nom', null)
        ->placeholder('Nom')
        ->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control text-uppercase']) !!}
    </div>

    <div class="col-md-5">
        {!! html()->label( 'PRENOM','prenom') !!}
        {!! html()->text('prenom', null)
            ->placeholder('Prénom')
            ->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control']) !!}
    </div>

    <div class="col-md-2">
        {!! html()->label( 'Sexe','sexe') !!}
        {!! html()->select('sexe', ['M'=>'Masculin','F' => 'Feminin'],null)
                ->placeholder('A définir')
                ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control'])  !!}
    </div>
</div>

<div class='form-group row'>
    <div class="col-md-2">
        {!! html()->label( 'Date de naissance','datenais') !!}
            <div class='input-group date' id='datepicker_datenais'>
                {!! html()->text('datenais', null)
                    ->placeholder('Date de naissance')
                    ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control']) !!}
                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
            </div>
    </div>

    <div class="col-md-2">
        {!! html()->label( 'Certificat','certif') !!}
        {!! html()->select('certif', ['0' => '0', '1' => '1', '2' => '2', '3' => '3', '4' => '4', '9' => '9'],null)
            ->placeholder('A définir')
            ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control'])  !!}
    </div>

    <div class="col-md-4">
        {!! html()->label( 'Verrou','verrou') !!}<br/>
        {!! html()->checkbox('verrou', null,1)->attributes([($mode=="show"?'disabled':''),'class' => '']) !!}
    </div>
</div>

<div class="callout callout-success">
    <div class='form-group row '>
        <legend class="h2"><small>Responsable parental</small></legend>
        <div class="col-md-5">
            {!! html()->label( 'Responsable','parents1') !!}
            {!! html()->hidden('parents1', (($beneficiaire)?$beneficiaire->id:null))->attributes(['id' => 'parents1']) !!}
            <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text" id='parents1_addon'>{!! isset($enfant)?$enfant->parents1:'' !!}</span>
                </div>
                {!! html()->text('responsable',((isset($beneficiaire)&&$beneficiaire)?$beneficiaire->nom_complet:(isset($enfant)?$enfant->NomParent1:'')))
                    ->placeholder("Responsable")
                    ->attributes([($mode=="show"?'disabled':''), 'id'=>'responsable','class' => 'form-control', (isset($beneficiaire)&&$beneficiaire)?'readonly':''])
                !!}
            </div>
        </div>
        <!--
        <div class="col-md-5">
            {!! html()->label( 'Compte bancaire','compte_p') !!}
            {!! html()->text('compte_p', null)->placeholder('Compte bancaire')->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control']) !!}
        </div>
    -->
    </div>
</div>


<div class="callout callout-warning">
    <div class='form-group row'>
        <legend class="h2"><small>Conjoint</small></legend>
        <div class="col-md-5">
            {!! html()->label( 'Réf.','parents2') !!}
            {!! html()->hidden('parents2', null)->attributes(['id' => 'parents2']) !!}
            <div class="input-group mb-3">
                <div class="input-group-prepend">
                    <span class="input-group-text" id='parents2_addon'>{!! isset($enfant)?$enfant->parents2:'' !!}</span>
                </div>
                {!! html()->text('conjoint',isset($enfant)?$enfant->NomParent2:'')
                    ->placeholder("Conjoint")
                    ->attributes([($mode=="show"?'disabled':''), 'id'=>'conjoint','class' => 'form-control'])
                !!}
            </div>
        </div>
        <!--
        <div class="col-md-5">
            {!! html()->label( 'Compte bancaire','compte_m') !!}
            {!! html()->text('compte_m', null)->placeholder('Compte bancaire')->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control']) !!}
        </div>
    -->
    </div>
</div>

<div class='form-group row'>
    <div class="col-md-12" >
    {!! html()->label('Observations','obs',) !!}
    {!! html()->textarea('obs', null)->attributes([($mode=="show"?'disabled':''), 'class' => 'form-control', 'rows'=>'3']) !!}
    </div>
</div>

<div class='form-group'>
    @if($mode=="show")
        @if($user->hasRole("ADMINISTRATEUR") || $user->can("ENF_MAJ"))
            @if($beneficiaire)
                <a class="btn btn-primary" href="{!! url('enfants_edit_avec_benef/'.$enfant->id.'/'.$beneficiaire->id."?benef_type=".$benef_type) !!}">Modifier</a>
            @else
                <a class="btn btn-primary" href="{!! url('enfants/'.$enfant->id."/edit?benef_type=".$benef_type) !!}">Modifier</a>
            @endif
            @if($enfant->canDelete)
                {{ html()->form('DELETE', url('/enfants/'. $enfant->id."?benef_type=".$benef_type))->open() }}
                    <button class="btn btn-danger btn-sm"><span class='fas fa-trash'></span></button>
                {{ html()->form()->close() }}
            @endif
        @endif
    @else
        {!! html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']) !!}
    @endif
    @if(!$beneficiaire)
        <a class="btn btn-warning"  href="{!! url('enfants_liste/'.$benef_type) !!}">Retour</a>
    @endif
</div>
