@extends('layouts.dash')
@section('title') Enfant @stop
@if(!$beneficiaire)
    @section('title_card') Mise à jour d'une fiche Enfant @stop
@endif

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-success">{{ Session::get('message') }}</div>
        <script>
            parent.location.reload();
            parent.jQuery.fancybox.close();
        </script>
    @else
        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif
        <div class="card card-info">
            <div class="card-header">
                <h3 class="card-title">{!! $enfant->nom_complet !!}</h3>
            </div>
            <div class='card-body'>
                {{ html()->modelForm($enfant, 'PUT', url('enfants/' . $enfant->id))->open() }}
                    <input type="hidden" name="benef_type" value="{{ $benef_type }}">
                    <input type="hidden" name="mode_frame" value="{{ ($beneficiaire)?true:false }}">
                    @include("tiers.enfants.content")
                {{ html()->closeModelForm() }}
            </div>
        </div>
    @endif
@stop

@section('scripts0')
    @include('tiers.enfants.scripts_enfant')
@stop


