@extends('layouts.dash')
@section('title') Enfants @stop
@section('title_card',"Enfants")
@section('subtitle_card',"Liste")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif

    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif

    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif

    <div class="card">
        <div class="card-header row">
            <div class="col-md-5">
                {!! html()->label( 'Dont un des parents à le statut :','') !!}
                {!! html()->select('benef_type', $liste_beneftype,$benef_type)->attributes(['id' => 'benef_type2','class' => 'form-control'])  !!}
            </div>
            @if($user->can("ENF_AJO") || $user->HasRole("ADMINISTRATEUR"))
                <div class="col-md-3 ">
                    {!! html()->label( '&nbsp;','') !!}<br/>
                    {!! html()->a(url('enfants/create?benef_type='.$benef_type),"Ajouter un enfant")->attributes(['class' => 'btn btn-success'])  !!}
                </div>
            @endif
        </div>
        <div class="card-body">
             <div class="row">
                <table id="_table"  style="background-color:white"
                    class="table table-condensed table-hover table-striped table-bordered">
                    <thead>
                        <tr>
                            <th width='1px'>Id</th>
                            <th>Nom</th>
                            <th width='1px'>Sexe</th>
                            <th width='1px'>Certif.</th>
                            <th width='1px'>Date de naissance</th>
                            <th nowrap width='1%'>N°Resp.</th>
                            <th width='10%'>Responsable</th>
                            <th width='1px'>Statut Resp.</th>
                            <th width='10%'>Conjoint</th>
                            <th width='1px'>Statut Conj.</th>
                        </tr>
                    </thead>

                    <tbody>
                        @foreach ($enfants as $enfant)
                        <tr>
                            <td>{!! str_pad($enfant->id, 6, "0", STR_PAD_LEFT) !!}</td>
                            <td nowrap>
                                @if($user->can("ENF_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                    <a href="{!! url('enfants_show/'.$enfant->id.'/'.$benef_type) !!}">
                                @endif
                                    {!! $enfant->nom.' '.$enfant->prenom  !!}
                                @if($user->can("ENF_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                    </a>
                                @endif
                            </td>
                            <td align="center">{!! $enfant->sexe !!}</td>
                            <td align="center">{!! $enfant->certif !!}</td>
                            <td nowrap>{!! $enfant->datenais !!}</td>
                            <td align="center">{!! $enfant->parents1 !!}</td>
                            <td nowrap>{!! $enfant->nom_parent1_reduit !!}</td>
                            <td align="center">{!! $enfant->statut_parent1  !!}</td>
                            <td nowrap>{!! $enfant->nom_parent2_reduit !!}</td>
                            <td align="center">{!! $enfant->statut_parent2  !!}</td>
                        </tr>
                        @endforeach
                    </tbody>

                </table>
            </div>
        </div>
    </div>
@stop

@section('scripts')
    <script>
        $(document).ready(function() {
            $('#benef_type2').on('change', function() {
                var benef_type=$('#benef_type2').val();
                location.href="{!! url('enfants_in/') !!}/"+benef_type;
            });
        });

        @if($user->can("ENF_VISU") || $user->HasRole("ADMINISTRATEUR"))
            jQuery(document).ready(function($) {
                $(".clickable-row").click(function() {
                    window.document.location = $(this).data("href");
                });
            });

        @endif
    </script>

    @include("forms.scripts_datatable_btn")
@endsection

