@extends('layouts.dash')
@section('title') Enfant @stop
@if(!$beneficiaire)
    @section('title_card') Consultation d'une fiche Enfant @stop
@endif
@section('content')
    @if (Session::has('message'))
        <div class="alert alert-success">{{ Session::get('message') }}</div>
        <script>
            parent.location.reload();
            parent.jQuery.fancybox.close();
        </script>
    @else
        <div class="card card-info">
            <div class="card-header">
                <h3 class="card-title">{!! $enfant->nom_complet !!}</h3>
            </div>
            <div class='card-body'>
                {{ html()->modelForm($enfant)->open() }}
                    <input type="hidden" name="benef_type" value="{{ $benef_type }}">
                    <input type="hidden" name="mode_frame" value="{{ ($beneficiaire)?true:false }}">
                    @include("tiers.enfants.content")
                {{ html()->closeModelForm() }}
            </div>
        </div>
    @endif
@stop
