<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BotManController;


/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/logout', 'App\Http\Controllers\Auth\LoginController@logout');

Auth::routes();

Route::get('change_profil',array('as' => 'change_profile' , 'uses' => 'App\Http\Controllers\Auth\ChangeProfilController@newprofil'));
Route::put('change_profil',array('as' => 'change_profile' , 'uses' => 'App\Http\Controllers\Auth\ChangeProfilController@changeprofil'));

Route::get('change_pwd', array('as' => 'change_pwd', 'uses'=>'App\Http\Controllers\UsersController@resetpassword')); // Liste formulaires
Route::post('pwd_reset', array('as' => 'pwd_reset', 'uses'=>'App\Http\Controllers\UsersController@postReset')); // Liste formulaires


Route::get('/', function () {
    return view('welcome');
});

Route::get('/home', 'App\Http\Controllers\HomeController@index')->name('home');
Route::get('/home/{type}', 'App\Http\Controllers\HomeController@index_type')->name('home');


Route::get('/action/newprofil', 'App\Http\Controllers\RolesController@newprofil');
Route::get('/action/profil_origine', 'App\Http\Controllers\RolesController@origine_profil');
Route::post('/action/changeprofil', 'App\Http\Controllers\RolesController@changeprofil');

Route::get('/home', 'App\Http\Controllers\HomeController@index')->name('home');

Route::get('accueil_spec/{type}', array('as' => 'accueil_spec', 'uses'=>'App\Http\Controllers\HomeController@index_spec'));


/* ************************************************** */
/*                   COMPTABILITE NEW                 */
/* ************************************************** */
//Route::get('journaux', 'App\Http\Controllers\GrandLivreController@index');

Route::get('ecritures', 'App\Http\Controllers\GrandLivreController@index_ecritures');
Route::get('ecritures_filtre/{date_deb}/{date_fin}', 'App\Http\Controllers\GrandLivreController@index_ecritures');

Route::get('comptes', 'App\Http\Controllers\GrandLivreController@index_comptes');
Route::get('comptes_filtre/{compte}/{compte_aux}/{date_deb}/{date_fin}', 'App\Http\Controllers\GrandLivreController@index_comptes');

Route::resource('grand_livre', 'App\Http\Controllers\GrandLivreController');
Route::get('grand_livre_journaux', 'App\Http\Controllers\GrandLivreController@index');
Route::get('grand_livre_filtre/{jnx?}/{date_deb?}/{date_fin?}/{view?}', 'App\Http\Controllers\GrandLivreController@index');


Route::get('grand_livre_del/{id}', 'App\Http\Controllers\GrandLivreController@delete_ligne');
Route::get('transaction/{id}', 'App\Http\Controllers\GrandLivreController@show_transaction');
Route::delete('transaction/{id}', 'App\Http\Controllers\GrandLivreController@delete_transaction');

//Ligne pop
Route::get('ecriture_pop_add/{id_ecriture}', 'App\Http\Controllers\GrandLivreController@create_ligne_pop');
Route::put('ecriture_pop_add/{id_ecriture}', 'App\Http\Controllers\GrandLivreController@store_ligne_pop');
Route::get('ecriture_pop_maj/{id_ecriture}', 'App\Http\Controllers\GrandLivreController@edit_ligne_pop');
Route::put('ecriture_pop_maj/{id_ecriture}', 'App\Http\Controllers\GrandLivreController@update_ligne_pop');

/* PLAN COMPTABLE */
Route::resource('plan_comptable', 'App\Http\Controllers\PlanComptableController');

/* JOURNAUX  CONFIGURATION */
Route::resource('journaux', 'App\Http\Controllers\JournauxController');

/* BALANCE */
Route::resource('balance', 'App\Http\Controllers\BalanceController');
Route::get('balance_filtre/{jnx?}/{date_deb?}/{date_fin?}', 'App\Http\Controllers\BalanceController@index');

//SUR BDD EXPLOITATION
Route::get('/ran', 'App\Http\Controllers\RANController@index');
Route::get('/ran_generate/{exercice}/{compte_aux?}', 'App\Http\Controllers\RANController@generate');
Route::get('/ran_show', 'App\Http\Controllers\RANController@ran_show');
Route::get('/ran_destroy/{exercice}/{compte_aux?}', 'App\Http\Controllers\RANController@destroy');

/* ************************************************** */
/*                   COMPTABILITE OLD                 */
/* ************************************************** */

Route::resource('compta_old/plan', 'App\Http\Controllers\Compta_old\PlanController');
Route::get('/compta_old/plan_annee/{exercice?}', 'App\Http\Controllers\Compta_old\PlanController@index');
Route::get('compta_old_plan_visu/{plan_id}/{exercice?}', 'App\Http\Controllers\Compta_old\PlanController@show');
Route::resource('compta_old/journal', 'App\Http\Controllers\Compta_old\JournauxController');
Route::get('compta_old/journal_ltd/{exercice}/{compte}', 'App\Http\Controllers\Compta_old\JournauxController@index_ltd');
Route::get('compta_old/journal_compense/{list_ecritures?}', 'App\Http\Controllers\Compta_old\JournauxController@create_compense');

Route::get('compta_old/journal_exercice/{exercice}', 'App\Http\Controllers\Compta_old\JournauxController@index');
Route::get('api_get_budget_plan/{plan_id}', 'App\Http\Controllers\Compta_old\PlanController@api_get_budget');
Route::get('compta_old_plan/{categ}/{exercice?}','App\Http\Controllers\Compta_old\EditionPlan@Edition_plan');
Route::get('compta_old_grandlivre/{compte}/{exercice?}','App\Http\Controllers\Compta_old\EditionGrandLivre@Edition_grandlivre');
Route::get('auto_compte_compta', 'App\Http\Controllers\Compta_old\JournauxController@auto_compte_compta');

Route::get('compta_old/compte_resultat/{categ?}','App\Http\Controllers\Compta_old\CompteResultatController@index');
Route::get('compta_old/bilan/{categ}', 'App\Http\Controllers\Compta_old\BilansController@index');
Route::get('compta_old/{categ}/{exercice?}','App\Http\Controllers\Compta_old\EditionBilan@Edition_bilan');
Route::get('compta_old_grandlivre/{compte}/{exercice?}','App\Http\Controllers\Compta_old\EditionGrandLivre@Edition_grandlivre');
Route::get('/compta_old/plan_annee/{exercice?}', 'App\Http\Controllers\Compta_old\PlanController@index');




/* ************************************************** */
/*                  STATISTIQUES                      */
/* ************************************************** */
Route::get('api_nb_aidesocales', 'App\Http\Controllers\StatistiquesController@getApiNbAideSocial');
Route::get('api_nb_aidesocales_data', 'App\Http\Controllers\StatistiquesController@getApiNbAideSocialData');

Route::get('api_nb_allocations', 'App\Http\Controllers\StatistiquesController@getApiAllocations');
Route::get('api_nb_allocations_data', 'App\Http\Controllers\StatistiquesController@getApiAllocationsData');

Route::get('api_nb_retraites', 'App\Http\Controllers\StatistiquesController@getApiNbRetraites');
Route::get('api_nb_retraites_data', 'App\Http\Controllers\StatistiquesController@getApiNbRetraitesData');


/* ************************************************** */
/*                  EMPLOYEURS                        */
/* ************************************************** */
Route::resource('employeurs', 'App\Http\Controllers\EmployeursController');
Route::get('employeurs_filtre/{id}/{origine}/{onglet_actif?}', 'App\Http\Controllers\EmployeursController@show');
Route::get('employeurs_filtre/{id}/{origine}/{onglet_actif?}/edit', 'App\Http\Controllers\EmployeursController@edit_s');
Route::get('employeurs_add/{origine}', 'App\Http\Controllers\EmployeursController@create');
Route::get('employeurs_liste/{origine}', 'App\Http\Controllers\EmployeursController@index');
Route::get('/autocomplete_employeur', array('as' => 'autocomplete_employeur', 'uses'=>'App\Http\Controllers\EmployeursController@autocomplete_employeur'));
Route::get('employeurs/{origine?}/{statut?}/{ile?}', 'App\Http\Controllers\EmployeursController@index');
//LETTRAGE
Route::put('/employeurs_lettrage/{id}/{origine}', 'App\Http\Controllers\EmployeursController@save_lettrage');
Route::get('/employeurs_lettrage/{id}/{origine}', 'App\Http\Controllers\EmployeursController@edit_lettrage');
Route::get('/view_lettrage/{id}/{origine}/{mode?}', 'App\Http\Controllers\EmployeursController@view_lettrage');


/* ************************************************** */
/*                  BENEFICIAIRES                        */
/* ************************************************** */
Route::resource('beneficiaires', 'App\Http\Controllers\BeneficiairesController');
Route::resource('beneficiaires_filtre', 'App\Http\Controllers\BeneficiairesController');
Route::get('beneficiaires_liste/{benef_type?}/{select_benef_type?}', 'App\Http\Controllers\BeneficiairesController@index');
Route::get('beneficiaires_add/{benef_type}', 'App\Http\Controllers\BeneficiairesController@create');
Route::get('beneficiaires_filtre/{beneficiaire_id}/{benef_type}/{onglet_actif?}', 'App\Http\Controllers\BeneficiairesController@show');
Route::get('beneficiaires_filtre/{beneficiaire_id}/{benef_type}/{onglet_actif?}/edit', 'App\Http\Controllers\BeneficiairesController@edit_s');
Route::get('auto_responsable', 'App\Http\Controllers\BeneficiairesController@autocomplete_conjoint');
Route::get('auto_conjoint', 'App\Http\Controllers\BeneficiairesController@autocomplete_conjoint');

//Route::get('beneficiaires_filtre/{beneficiaire_id}', 'App\Http\Controllers\BeneficiairesController@show');
//Route::get('/tiers/beneficiaires_filtre/limit/{param?}', 'App\Http\Controllers\BeneficiairesController@index');
//Route::get('beneficiaires_filtre/{beneficiaire_id}/{type_liste}/{onglet_actif?}/edit', 'App\Http\Controllers\BeneficiairesController@edit_s');


//Enfants
Route::resource('enfants', 'App\Http\Controllers\EnfantsController');
Route::get('enfants_show/{id}/{benef_type}', 'App\Http\Controllers\EnfantsController@show');
Route::get('enfants_liste/{benef_type}', 'App\Http\Controllers\EnfantsController@index');
Route::get('enfants/limit/{param}', 'App\Http\Controllers\EnfantsController@index');
Route::get('enfants/limit/enfants/create', 'App\Http\Controllers\EnfantsController@create');

Route::get('enfants_create_avec_benef/{beneficiaire_id}', 'App\Http\Controllers\EnfantsController@create_avec_benef');
Route::get('enfants_edit_avec_benef/{id}/{beneficiaire_id}', 'App\Http\Controllers\EnfantsController@edit_avec_benef');
Route::get('enfants_show_avec_benef/{id}/{beneficiaire_id}', 'App\Http\Controllers\EnfantsController@show_avec_benef');
Route::get('enfants_in/{param}', 'App\Http\Controllers\EnfantsController@index_in');
Route::post('enfants_in/{param}', 'App\Http\Controllers\EnfantsController@index_in');

/* RAZ */
Route::get('raz_rappel/{type}/{nbraz?}', 'App\Http\Controllers\VersementsRAZController@index');
Route::post('raz_rappel/{type}', 'App\Http\Controllers\VersementsRAZController@raz_rappel');
Route::get('maj_certificats_etrangers/{type}/{nbraz?}', 'App\Http\Controllers\VersementsRAZController@index_certificats_etrangers');
Route::get('maj_certificats/{type}/{nbraz?}/{etrangers?}', 'App\Http\Controllers\VersementsRAZController@index_certificats');
Route::post('maj_certificats/{type}', 'App\Http\Controllers\VersementsRAZController@maj_certificats');
Route::post('maj_certificats_etrangers/{type}', 'App\Http\Controllers\VersementsRAZController@maj_certificats_etrangers');
Route::get('maj_certificats_info/{type}/{etrangers?}', 'App\Http\Controllers\VersementsRAZController@info_certificats');

//VERSEMENTS
Route::get('versements_encours/{type}', 'App\Http\Controllers\VersementsBrouillonController@index');
Route::get('versements_brouillon_print/{type}', 'App\Http\Controllers\EditionsVersementsController@imprimer_brouillon');
Route::get('versements_generation_b/{type}', 'App\Http\Controllers\VersementsBrouillonController@generation');
Route::post('versements_generation_b/{type}', 'App\Http\Controllers\VersementsBrouillonController@set_generation_brouillon');
Route::get('versement_annee/{employeur_id?}', 'App\Http\Controllers\VersementsController@index');
Route::get('versements_print/{type}/{num_imp}', 'App\Http\Controllers\EditionsVersementsController@imprimer_definitif');
Route::get('versements_export_fichier_complet/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@index_export_fichier_complet');
Route::post('versements_export_fichier_complet/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@export_fichier_complet');
//Route::get('versements_export_fichier/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@index_export_fichier');
//Route::post('versements_export_fichier/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@export_fichier');
//Route::get('versements_export_fichier_BWF_TP/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@index_export_fichier_BWFTP');
//Route::post('versements_export_fichier_BWF_TP/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@export_fichier_BWFTP');
//Route::get('versements_export_fichier_TP/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@index_export_fichier_TP');
//Route::post('versements_export_fichier_TP/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@export_fichier_TP');


//Réajustements
Route::get('retraites/reajustement', 'App\Http\Controllers\RetraitesController@reajustement_index');
Route::post('retraites/reajustement_simulation', 'App\Http\Controllers\RetraitesController@simulation_index');
Route::post('retraites/reajustement_validation', 'App\Http\Controllers\RetraitesController@validation');

Route::get('retraites/reajustement_csr', 'App\Http\Controllers\RetraitesController@reajustementCSR_index');
Route::post('retraites/reajustement_csr_simulation', 'App\Http\Controllers\RetraitesController@simulationCSR_index');
Route::post('retraites/reajustement_csr_validation', 'App\Http\Controllers\RetraitesController@validationCSR');



/* ***** SALAIRES ***** */
Route::get('salaire_employe/{beneficiaire_id}/{employeur_id}', 'App\Http\Controllers\SalairesController@index_beneficiaire_employeur');
Route::get('salaire_annee/{employeur_id?}/{beneficiaire_id?}/{exercice?}', 'App\Http\Controllers\SalairesController@index');
Route::get('salaires/create/{beneficiaire_id}/{employeur_id}', 'App\Http\Controllers\SalairesController@create');
Route::delete('salaires/{id}/{employeur_id?}/{beneficiaire_id?}/{exercice?}','App\Http\Controllers\SalairesController@destroy');
Route::get('salaire_secteurs_iframe/{secteur}/{date}', 'App\Http\Controllers\SalairesController@index_iframe_secteur');

Route::resource('salaires', 'App\Http\Controllers\SalairesController');
Route::get('/salaire/liquidation/{beneficiaire_id}', 'App\Http\Controllers\EditionsPrestationsController@salaire_liquidation');
Route::get('salaire_liquidation/{beneficiaire_id}', 'App\Http\Controllers\Editions\EditionSalaires@liquidation');

Route::get('salaire_imprime/{beneficiaire_id}', 'App\Http\Controllers\Editions\EditionSalaires@imprime_salaires');
Route::get('/salaire/liquidation_simulation/{beneficiaire_id}', 'App\Http\Controllers\EditionsPrestationsController@salaire_simulation_liquidation');
Route::post('/salaire/liquidation/{beneficiaire_id}', 'App\Http\Controllers\EditionsPrestationsController@salaire_simulation_liquidation');

/* ********* LOGS SALAIRES ********** */
Route::get('/log_salaires/{id_salaire}', 'App\Http\Controllers\LogsSalairesController@index_salaires');
Route::get('/log_salaires/{annee?}/{employeur_id?}', 'App\Http\Controllers\LogsSalairesController@index_historique');

/* ***** COTISATIONS ***** */
Route::resource('cotisations', 'App\Http\Controllers\CotisationsController');
Route::get('cotisation_annee/{employeur_id?}/{exercice?}/{affiche_tout?}', 'App\Http\Controllers\CotisationsController@index');
Route::post('cotisation_saisie_filtre', 'App\Http\Controllers\CotisationsController@index_filtre');
Route::get('cotisations/create/{employeur_id}', 'App\Http\Controllers\CotisationsController@create');
Route::get('cotisations_encours', 'App\Http\Controllers\CotisationsController@index_encours');
Route::get('cotisations_encaissees/{exercice?}', 'App\Http\Controllers\CotisationsController@index_encaissees');
Route::get('cotisation_encaissees_annee/{exercice?}', 'App\Http\Controllers\CotisationsController@index_encaissees');
Route::post('cotisation_encaissees_annee', 'App\Http\Controllers\CotisationsController@index_encaissees_post');
//Reglements
Route::post('reglement_lettrage', 'App\Http\Controllers\CotisationsController@store_reglement_lettrage');
Route::post('reglement_simple', 'App\Http\Controllers\CotisationsController@store_reglement');
Route::get('reglement_pointage/{employeur_id?}/{exercice?}/{affiche_tout?}', 'App\Http\Controllers\CotisationsController@pointage');
Route::put('reglement_pointage/{employeur_id?}/{exercice?}/{affiche_tout?}', 'App\Http\Controllers\CotisationsController@lettrer');
Route::get('pointage_encaissement/{cotisation_id}', 'App\Http\Controllers\CotisationsController@encaissement_compta');
Route::get('reglement_create/{employeur_id?}/{exercice?}', 'App\Http\Controllers\CotisationsController@reglement_create');
Route::put('cotisations_lettrage/{employeur_id?}/{exercice?}/{cotisations?}', 'App\Http\Controllers\CotisationsController@lettrage_bef');
Route::get('cotisations_lettrage/{employeur_id?}/{exercice?}/{cotisations?}', 'App\Http\Controllers\CotisationsController@lettrage');
Route::get('cotisations_recu/{cotisation_id}', 'App\Http\Controllers\Editions\EditionsCotisationsRecu@recu');
Route::get('cotisations_ordre/{cotisation_id}', 'App\Http\Controllers\Editions\EditionsCotisationsOrdre@ordre');
Route::get('cotisations_encaiss/{cotisation_id}', 'App\Http\Controllers\CotisationsController@encaissement');
Route::put('cotisations_encaiss/{cotisation_id}', 'App\Http\Controllers\CotisationsController@update_encaiss');



/* ***** CONTROLE-RECOUVREMENT ***** */
Route::get('bordereaux/{annee?}/{bdx_id?}/{pupri?}', 'App\Http\Controllers\RecouvrementController@index_bordereaux');
Route::get('bordereaux_liste/{annee?}', 'App\Http\Controllers\RecouvrementController@index_bordereaux_liste');
Route::get('bordereaux_val/{type_val}/{bdx_id}/{type}/{annee}', 'App\Http\Controllers\RecouvrementController@valider');
Route::get('bordereaux_etat/{bdx_id}/{type}/{annee}', 'App\Http\Controllers\Editions\BordereauEtatRecapitulatif@impression_bordereau');
Route::get('rappels', 'App\Http\Controllers\RecouvrementController@index_rappel');


Route::get('reste_a_payer', 'App\Http\Controllers\RecouvrementController@index_resteapayer');
Route::get('reste_a_payer_annee/{exercice?}/{date_obs?}', 'App\Http\Controllers\RecouvrementController@index_resteapayer_annee');
Route::get('cotisations_employeur_exercice/{employeur_id}/{exercice?}/{date?}','App\Http\Controllers\CotisationsController@index_cotis_emp_exercice');
Route::get('cotisations_employeur_cumule/{employeur_id}/{exercice?}/{date?}','App\Http\Controllers\CotisationsController@index_cotis_emp_cumule');

Route::post('recouvrement_sendmail/{employeur_id}', 'App\Http\Controllers\RecouvrementController@sendmail');
Route::get('recouvrement_sendmail/{employeur_id}', 'App\Http\Controllers\RecouvrementController@saisie_email');
Route::get('recouvrement_email_sent/{employeur_id}', 'App\Http\Controllers\RecouvrementController@saisie_email');
Route::get('recouvrement_emails', 'App\Http\Controllers\RecouvrementController@index_emails');
Route::get('recouvrement_showmails/{employeur_id}', 'App\Http\Controllers\RecouvrementController@show_emails');

/* CONTROLE UPLOAD FILES */
Route::get('controles/addpiece/{controle_id}', 'App\Http\Controllers\ControlesController@add_piece');
Route::get('upload/delete/{upload_id}', 'App\Http\Controllers\UploadFileController@destroy');
Route::post('uploadfile','App\Http\Controllers\UploadFileController@showUploadFile');
Route::get('controles/create/{employeur_id}', 'App\Http\Controllers\ControlesController@create');
Route::get('controles/show_box/{controle_id}', 'App\Http\Controllers\ControlesController@show_box');

/* ***** CONTROLE-RECOUVREMENT ***** */
Route::resource('controles', 'App\Http\Controllers\ControlesController');
Route::get('controle_annee/{employeur_id?}', 'App\Http\Controllers\ControlesController@index');

Route::get('med_prepa/{exercice?}', 'App\Http\Controllers\RecouvrementController@index_med');
//Route::get('med_create/{employeur_id}', 'App\Http\Controllers\MedController@create');
Route::resource('med', 'App\Http\Controllers\MedController');
Route::get('med_print/{med_id}', 'App\Http\Controllers\Editions\EditionsRecouvrementMED@impression_med');
Route::get('cotisations_bordereau_cotisation/{employeur_id}/{annee}/{trimestre}/{periode?}', 'App\Http\Controllers\Editions\EditionsCotisationsBordereau@bordereau');






/* ***** STATISTIQUES ***** */
Route::get('/stats/tdb/{benef_type}', 'App\Http\Controllers\StatistiquesController@index_tdb');
Route::get('/stats/tdb_nbenfant/{benef_type}/{annee?}/{mois?}', 'App\Http\Controllers\StatistiquesController@index_periode_tdb');
Route::get('/stats/graph/{type}', 'App\Http\Controllers\StatistiquesController@graph_tdb');
Route::get('/stats/secteur', 'App\Http\Controllers\StatistiquesController@index_secteurs');
Route::get('/stats/secteur_general/{date?}', 'App\Http\Controllers\StatistiquesController@index_secteurs_gene');
Route::get('/stats/salaires/{exercice?}/{mois?}', 'App\Http\Controllers\StatistiquesController@index_salaries');
Route::get('/stats/optimind/{annee?}', 'App\Http\Controllers\StatistiquesController@index_optimind');




//Route::get('recouvrement/controle_employe/{employeur_id}', 'App\Http\Controllers\ControlesController@index_employeur');
//
//
//


//
//



//Route::get('recouvrement/taxe_office/{exercice?}','App\Http\Controllers\RecouvrementTaxationController@index');


////Route::get('recouvrement/cotisation_employe/{employeur_id}', 'App\Http\Controllers\CotisationsController@index_employeur');
//Route::get('recouvrement/cotisations/delete/{cotisation_id}/{exercice?}', 'App\Http\Controllers\CotisationsController@destroy');
//Route::get('recouvrement/cotisations/show_box/{cotisation_id}', 'App\Http\Controllers\CotisationsController@show_box');

//Route::get('recouvrement/nouveau_reglement/{employeur_id?}', 'App\Http\Controllers\CotisationsController@index');


//Route::get('cotisations_attestation_regul/{employeur_id}', 'App\Http\Controllers\Editions\EditionsCotisationsAttRegu@attestation_regul');
//Route::get('cotisations_attestation_pmtech/{employeur_id}', 'App\Http\Controllers\Editions\EditionsCotisationsAttPmtEch@attestation_pmtech');
//Route::get('cotisations_attestation/{employeur_id}', 'App\Http\Controllers\Editions\EditionsCotisationsAtt@attestation_normale');
//Route::get('cotisations_attestation_simple/{employeur_id}', 'App\Http\Controllers\Editions\EditionsCotisationsAttSimple@attestation_simple');
//Route::get('cotisations_attestation_cotisation/{employeur_id}', 'App\Http\Controllers\Editions\EditionsCotisationsAttSituation@attestation_situation');


/* OLD */




/*
Route::get('grand_livre_maj/{id}/{id_edit}', 'App\Http\Controllers\GrandLivreController@edit_ligne');
Route::post('grand_livre_maj/{id}', 'App\Http\Controllers\GrandLivreController@update_ligne');

Route::get('comptabilite/employeurs/{statut?}/{ile?}', 'App\Http\Controllers\EmployeursController@index_comptabilite');
*/


/* ***** PARAMETRES ***** */
Route::resource('/parametres', 'App\Http\Controllers\ParametresController');
Route::PUT('/parametres_detail/{page}', 'App\Http\Controllers\ParametresController@update');
Route::get('/parametres_detail/{page}', 'App\Http\Controllers\ParametresController@index');

Route::resource('/benef_statuts', 'App\Http\Controllers\BenefstatutsController');
Route::resource('/benef_types', 'App\Http\Controllers\BeneftypesController');

/* ***** ACCES / USERS / ROLES / PERMISSIONS ***** */
Route::resource('/users', 'App\Http\Controllers\UsersController');
Route::delete('/users/delete/{id}','App\Http\Controllers\UsersController@destroy');
Route::resource('/roles', 'App\Http\Controllers\RolesController');
Route::get('/roles_det', 'App\Http\Controllers\RolesController@index_det');
Route::resource('/permissions', 'App\Http\Controllers\PermissionsController');
Route::get('/roles_tableau', 'App\Http\Controllers\RolesController@index_tableau');
Route::get('/role_tableau_filtre/{id}', 'App\Http\Controllers\RolesController@index_tableau');

/* ***** BENEFICIAIRES ***** */



/* ***** ENFANTS ***** */


/* ***** BANQUES ***** */
Route::resource('banques', 'App\Http\Controllers\BanquesController');
Route::get('/autocomplete_banque', array('as' => 'autocomplete_banque', 'uses'=>'App\Http\Controllers\BanquesController@autocomplete_banque'));

/* ***** SECTEURS ***** */
Route::resource('/param/secteurs', 'App\Http\Controllers\SecteursController');
Route::get('/param/secteurs_edition', 'App\Http\Controllers\Editions\EditionSecteur@secteur_entreprise');





/* ***** CREANCIERS ***** */
Route::resource('creanciers', 'App\Http\Controllers\CreanciersController');
Route::get('creanciers_mandat/{exercice?}', 'App\Http\Controllers\CreanciersController@index_mandat');
Route::get('creanciers_mandat_show/{id}', 'App\Http\Controllers\CreanciersController@show_mandat');

Route::delete('creanciers_delete/{id}', 'App\Http\Controllers\CreanciersController@delete_form');
Route::get('creanciers_annee/{exercice?}', 'App\Http\Controllers\CreanciersController@index');
Route::get('auto_creancier_beneficiaire', 'App\Http\Controllers\CreanciersController@autocomplete_creancier_beneficiaire');
Route::get('auto_creancier_employeur', 'App\Http\Controllers\CreanciersController@autocomplete_creancier_employeur');
Route::get('auto_creancier_creancier', 'App\Http\Controllers\CreanciersController@autocomplete_creancier_creancier');
Route::get('creancier_show_frame/{creancier_id}/{mandat_id}', 'App\Http\Controllers\CreanciersController@show_frame');
Route::get('creancier_create_avec_mandat/{mandat_id}', 'App\Http\Controllers\CreanciersController@create_avec_mandat');
Route::get('creancier_edit_avec_mandat/{id}/{mandat_id}', 'App\Http\Controllers\CreanciersController@edit_avec_mandat');

/* ***** IMPUTATIONS ***** */
Route::resource('/imputations', 'App\Http\Controllers\ImputationsController');
Route::get('imputations_show_frame/{imputation_id}/{mandat_id}', 'App\Http\Controllers\ImputationsController@show_frame');
Route::get('imputations_edit_avec_mandat/{id}/{mandat_id}', 'App\Http\Controllers\ImputationsController@edit_avec_mandat');


/* Mandatements */
Route::resource('/mandats', 'App\Http\Controllers\MandatsController');
Route::get('/mandats_annee/{exercice?}', 'App\Http\Controllers\MandatsController@index');
Route::get('/generations', 'App\Http\Controllers\MandatsController@index_generations');
Route::get('/mandatements/imputations_annee/{exercice?}', 'App\Http\Controllers\ImputationsController@index');
Route::get('imputation_create_avec_mandat/{mandat_id}', 'App\Http\Controllers\ImputationsController@create_avec_mandat');
// Transfert Trésor */
Route::get('mandatements_settransfert/{id}/{exercice?}', 'App\Http\Controllers\MandatsController@set_transfert');
Route::get('mandatements_unsettransfert/{id}/{exercice?}', 'App\Http\Controllers\MandatsController@unset_transfert');
Route::get('mandats_export_fichier_TP', 'App\Http\Controllers\Editions\ExportMandatsController@index_export_fichier_TP');
Route::post('mandats_export_fichier_TP', 'App\Http\Controllers\Editions\ExportMandatsController@export_fichier_TP');


/* ***** VERSEMENTS ***** */
//Route::resource('prestations/versements_brouillon', 'App\Http\Controllers\VersementsBrouillonController');
//Route::post('prestations/versements_brouillon', 'App\Http\Controllers\VersementsController@update_brouillon');



/* versements définitifs */
Route::get('versements/{type}/{num_imp?}', 'App\Http\Controllers\VersementsController@index');
Route::get('prestations/versement_employe/{employeur_id}', 'App\Http\Controllers\VersementsController@index_employeur');
Route::get('alprestationsloc/versements/create/{employeur_id}', 'App\Http\Controllers\VersementsController@create');


//Historiqye fiche bénéficiaire
Route::get('versements_historique/{beneficiaire_id}', 'App\Http\Controllers\VersementsHGController@index');

Route::get('versements_imprime/{beneficiaire_id}', 'App\Http\Controllers\Editions\EditionVersements@imprime_versements');
Route::get('versements_generation_def/{type}', 'App\Http\Controllers\VersementsController@generation_definitive');
Route::post('versements_generation_def/{type}', 'App\Http\Controllers\VersementsController@set_generation_definitive');



/* ***** COMPTABILITE ***** */
Route::resource('compta/plan', 'App\Http\Controllers\PlanController');
Route::get('/compta/plan_annee/{exercice?}', 'App\Http\Controllers\PlanController@index');
Route::get('compta_plan_visu/{plan_id}/{exercice?}', 'App\Http\Controllers\PlanController@show');
Route::resource('compta/journal', 'App\Http\Controllers\JournauxController');
Route::get('compta/journal_ltd/{exercice}/{compte}', 'App\Http\Controllers\JournauxController@index_ltd');
Route::get('compta/journal_compense/{list_ecritures?}', 'App\Http\Controllers\JournauxController@create_compense');

Route::get('compta/journal_exercice/{exercice}', 'App\Http\Controllers\JournauxController@index');
Route::get('api_get_budget_plan/{plan_id}', 'App\Http\Controllers\PlanController@api_get_budget');
Route::get('compta_plan/{categ}/{exercice?}','App\Http\Controllers\Editions\EditionPlan@Edition_plan');
Route::get('compta_grandlivre/{compte}/{exercice?}','App\Http\Controllers\Editions\EditionGrandLivre@Edition_grandlivre');
Route::get('auto_compte_compta', 'App\Http\Controllers\JournauxController@auto_compte_compta');

Route::get('compta/bilan/{categ}', 'App\Http\Controllers\BilansController@index');
Route::get('compta_bilan/{categ}/{exercice?}','App\Http\Controllers\Editions\EditionBilan@Edition_bilan');


Route::get('compta/compte_resultat/{categ?}','App\Http\Controllers\CompteResultatController@index');
Route::get('compta/tableau_amortissement/{categ?}','App\Http\Controllers\TableauAmortissementController@index');




/* ***** BORDEREAUX ***** */
Route::resource('editions_aidessociales', 'App\Http\Controllers\Editions\BordereauxAidesSociales');
Route::get('/alloc/versements_retraite', 'App\Http\Controllers\VersementsController@retraite');


// TRANSFERTS
Route::get('transferts', 'App\Http\Controllers\TransfertsController@index');
Route::get('transfert_filtre/{type}/{date_deb?}/{date_fin?}/{compte_aux?}', 'App\Http\Controllers\TransfertsController@index_filtre');
Route::post('transfert_valide', 'App\Http\Controllers\TransfertsController@valide');
//Route::post('transferts_reglements', 'TransfertsController@transfertReglements');


//1-OK
Route::get('mandat_imputation/{mandat_id}/{imputation_id?}', 'App\Http\Controllers\Editions\EditionMandatImputation@mandat_imputation');
//2-OK
Route::get('mandat_ordre_pmt_imp/{mandat_id}/{imputation_id?}/{creancier_id?}', 'App\Http\Controllers\Editions\EditionMandatOrdrePmtImputation@mandat_ordre_pmt_imp');
Route::get('mandat_ordre_pmt_imp_nom/{mandat_id}/{nom_creancier?}', 'App\Http\Controllers\Editions\EditionMandatOrdrePmtImputation@mandat_ordre_pmt_imp_nom');

//3-OK
Route::get('mandat_mandat_pmt_imp/{mandat_id}/{imputation_id?}/{creancier_id?}', 'App\Http\Controllers\Editions\EditionMandatPaiement@mandat_mandat_pmt');

//4-A FAIRE
Route::get('mandat_bordereau_rglmt/{creancier_id}', 'App\Http\Controllers\Editions\EditionsMandatsBordereauRglmt@mandat_bordereau_rglmt');

//5-OK
Route::get('mandat_mandat_pmt_cre/{mandat_id}/{creancier_id?}', 'App\Http\Controllers\Editions\EditionMandatPaiement@mandat_mandat_pmt');

//6-A FAIRE
Route::get('mandat_mandat_annulation/{mandat_id}/{imputation_id?}/{creancier_id?}', 'App\Http\Controllers\Editions\EditionMandatAnnulation@mandat_mandat_annulation');






/* PAS OK */





/* PARAMETRES */
Route::get('/param/importations', 'App\Http\Controllers\ImportationController@index');
Route::get('/param/hyperfile', 'App\Http\Controllers\ImportationController@index_hyper');
Route::post('/param/load_table', array('as'=>'param.load_table', 'uses' =>'App\Http\Controllers\ImportationController@load'));
Route::post('/param/load_odbc_table', array('as'=>'param.load_odbc_table', 'uses' =>'App\Http\Controllers\ImportationController@load_odbc'));
Route::post('/param/load_txt_table', array('as'=>'param.load_txt_table', 'uses' =>'App\Http\Controllers\ImportationController@load_txt'));

Route::get('api_importe/{origine}/{path}/{destination}', 'App\Http\Controllers\ImportationController@importe');
Route::get('attestation_edition/{beneficiaire_id}/{statut}/{modele}/{annee?}', 'App\Http\Controllers\Editions\EditionsAttestationsController@imprime');





Route::get('/analyses/benef_doublons', 'App\Http\Controllers\AnalysesController@index_benef_doublons');
Route::get('/analyses/histo_rib', 'App\Http\Controllers\AnalysesController@index_histo_rib');

/* ********* LOGS ********** */
Route::get('/log_user/{usr_id}', 'App\Http\Controllers\LogsController@index_user');


/* ***** TESTS ***** */
Route::get('test', 'App\Http\Controllers\TestController@index');
Route::get('test_form', 'App\Http\Controllers\TestController@index_form');
Route::get('/test_editon', 'App\Http\Controllers\Editions\BordereauEtatRecapitulatif@impression_bordereau');
Route::get('mail', 'App\Http\Controllers\HomeController@mail');
