<?php $__env->startSection('title'); ?> Imputations <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Imputations <?php $__env->stopSection(); ?>
<?php $__env->startSection('subtitle_card',"Liste complète"); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <?php if(Session::has('message')): ?>
            <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
        <?php endif; ?>

        <div class="card-header">
            <div class="form-group row">
                <div class='col-md-3'>
                <?php echo html()->label('Années :','annes'); ?>

                <?php echo html()->select('exercice')->options($exercices)
                    ->value($exercice)
                    ->placeholder('Choisir un exercice')
                    ->attributes(['class' => 'form-control','id' => 'exercice_id']); ?>

                </div>
            </div>
        </div>

        <div class="card-body">
            <table id="_table" style="background-color:white"
                class="table table-striped table-bordered table-hover" width="100%">
                <thead>
                    <tr>
                        <th width='1px' nowrap>Id</th>
                        <th width='1px' nowrap>N°Compte</th>
                        <th>Désignation</th>
                        <th width='1px'>Montant</th>
                        <th width='1px'>Type</th>
                        <th width='1px'>Id&nbsp;Mandat</th>
                        <th width='1px'>Statut&nbsp;Mandat</th>
                        <th width='1px'>Transfert&nbsp;Mandat</th>
                        <th>Observations</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $imputations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imputation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $imputations=App\Models\Imputation::find($imputation->idmandat);
                    ?>
                    <tr class="clickable-row" data-href="<?php echo url('imputations/'.$imputation->id); ?>">
                        <td align="center">
                            <?php if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                <a href="<?php echo url('imputations/'.$imputation->id); ?>"
                                    class="" style="margin-right: 3px;">
                            <?php endif; ?>
                            <?php echo str_pad($imputation->id,5,'0',STR_PAD_LEFT); ?>

                            <?php if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                </a>
                            <?php endif; ?>
                        </td>
                        <td align="center"><?php echo $imputation->cpt_imp; ?></td>
                        <td><?php echo $imputation->designation; ?></td>
                        <td align="right"><?php echo $imputation->montant; ?></td>
                        <td align="center"><?php echo $imputation->type_imp; ?></td>
                        <td align="center"><?php echo $imputation->idmandat; ?></td>
                        <td align="center"><?php echo $imputation->MandatStatut; ?></td>
                        <td align="center"><?php echo $imputation->DateTransfert; ?></td>
                        <td><?php echo $imputation->obs; ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

        </div>


        <?php if($user->can("IMP_AJO") || $user->HasRole("ADMINISTRATEUR")): ?>
            <div class="card-footer">
                <h4><a href="<?php echo url('imputations/create'); ?>"
                    class="btn btn-success">Ajouter une Imputation</a></h4>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable_btn", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        $(document).ready(function() {
            $('#exercice_id').on('change', function() {
                location.href="<?php echo url('/mandatements/imputations_annee/'); ?>/"
                    +$('#exercice_id').val();
            });
        });
    </script>
    <?php if($user->can("IMP_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
        <script>
        jQuery(document).ready(function($) {
            $(".clickable-row").click(function() {
                window.document.location = $(this).data("href");
            });
        });
        </script>
    <?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/mandatements/imputations/index.blade.php ENDPATH**/ ?>