<?php $__env->startSection('title'); ?> Cotisations <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',""); ?>
<?php $__env->startSection('subtitle_card',""); ?>


<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="col-lg-max col-lg-offset-1 container-fluid">
            <div class="card-header bg-info">
                Reste à payer par année de rattachement<small> - Employeurs Actifs et non actifs</small>
            </div>
            <div class="card-body">
                <div class="row">   
                    <div class='col-md-2' >
                        <?php echo html()->label( 'Exercice','exercice'); ?>

                        <?php echo html()->select('exercice',$exercices,$exercice)
                            ->placeholder('A définir')
                            ->attributes(['id' => 'exercice_id','class' => 'form-control selectpicker','data-width' => "100%",'style' => 'font-weight:bold;background:whitesmoke']); ?>

                    </div>
                    <div class='col-md-2' >
                        <?php echo html()->label( 'Date d\'observation','date_obs'); ?>

                        <div class="input-group">
                            <div class='input-group date' id='datepicker_date_obs'>
                                <?php echo html()->text('date_obs',$date_obs_fr)->placeholder('Date')->attributes(['size'=>'8', 'class' => 'form-control']); ?>

                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                            </div>
                        </div>
                    </div>
                    <div class='col-md-2 mt-2' >
                        <a href="#" class="btn btn-info pull-left" 
                            onclick="javascript:valide_date();" style="margin-top:25px;margin-right: 3px;">Filtrer
                        </a>
                    </div>
                </div>
                <div class="row  mt-4">   
                    <table id="_table" style="background-color:white"  
                        class="table table-condensed table-striped table-hover table-bordered">
                        <thead>
                            <tr>
                                <th width='1%'>N°</th>
                                <th width='10%'>Nom</th>
                                <th width='1%'>Statut</th>
                                <th width='1%'>Reste&nbsp;a&nbsp;payer<br>sur&nbsp;Exercice&nbsp;<?php echo $exercice; ?></th>
                                <th width='1%'>Reste&nbsp;a&nbsp;payer<br>au&nbsp;<?php echo $date_obs_fr; ?></th>
                            </tr>
                        </thead>
             
                        <tbody>
                            <?php $__currentLoopData = $employeurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employeur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $rap_an=$employeur->getResteAPayerExercice($exercice,$date_obs);
                                    $rap_date=$employeur->getResteAPayerCumule($exercice,$date_obs);
                                    $style_rap_an=($rap_an<0)?"color:red":"color:green";
                                    $style_rap_date=($rap_date<0)?"color:red":"color:green";
                                ?>
                                <tr>
                                    <td><?php echo str_pad($employeur->id,4,'0',STR_PAD_LEFT); ?></td>
                                    <td><a href="<?php echo url('employeurs_filtre/').'/'.$employeur->id.'/V'; ?>" target="_blank"><?php echo $employeur->NomReduit; ?></a></td>
                                    <td align="center"><?php echo $employeur->statut; ?></td>
                                    <td align="right" style="<?php echo $style_rap_an; ?>"><a href="<?php echo url('cotisations_employeur_exercice/'.$employeur->id.'/'.$exercice.'/'.$date_obs); ?>" id='btn_ajout_imputation' class="box_detail fancybox.iframe" target="_blank"><?php echo $rap_an; ?></a></td>
                                    <td align="right" style="<?php echo $style_rap_date; ?>"><a href="<?php echo url('cotisations_employeur_cumule/'.$employeur->id.'/'.$exercice.'/'.$date_obs); ?>" id='btn_ajout_imputation' class="box_detail fancybox.iframe" target="_blank"><?php echo $rap_date; ?></a></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox.css')); ?>">
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox-buttons.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts0'); ?>
    <script src="<?php echo e(url('js/jquery.fancybox.js')); ?>"></script>
    <script src="<?php echo e(url('js/magicsuggest.js')); ?>"></script>

    <script>
        $(".box_detail").fancybox({
            width:'70%',
            autoDimensions:false,
            fitToView   : false,
            autoSize    : false,
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
            afterLoad: function () {

            },
            afterClose: function () {

                return;
            }
        });

        $('#exercice_id').on('change', function() {
            $('#date_obs').val("");
        });
        $('#datepicker_date_obs').datepicker({
            format: "dd/mm/yyyy",
            language: "fr",
            autoclose: true
        });

        function valide_date() {
            var date =$('#date_obs').val();
            if(date=="") {
                alert("Il faut saisir une date valide");
                return;
            } 
            var elem = date.split('/');
            jour = elem[0];mois=elem[1];annee=elem[2];
            date=  annee+"-"+mois+"-"+jour; 
            date=date.replace(/\//g, "-");

            location.href="<?php echo url('/reste_a_payer_annee/'); ?>"+"/"+$('#exercice_id').val()+"/"+date;
        };
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function() {
        var table =$('#_table').DataTable( {
            bAutoWidth: false,
            bPaginate: false,
            bInfo: true,
            bFilter: true,
            scrollY:        400,
            scrollX:        true,
            scrollCollapse: true,
            oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "decimal": ",",
                "thousands": " ",
                "sSearch":"Chercher",

                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',
                    print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                    }
                }

                },
                "aaSorting": [
                    [0,'desc']
                ],

                "aoColumnDefs": [
                    { "sTypes": "numeric", "aTargets": [ 3,4 ] },
                    { bSortable: false, aTargets: [] },
                    { visible: false, targets: [] },
                ],

                dom: "<'row'<'col-sm-2 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                buttons: [ 
                    {extend: 'copy',exportOptions: {columns: ':visible'} },
                    {extend: 'excel',exportOptions: {columns: ':visible'} },
                    {extend: 'print',exportOptions: {columns: ':visible'} },
                    'colvis'
                ],

            } );
    } );
</script>

<?php $__env->stopSection(); ?>






<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/recouvrement/suivi/index_resteapayer_annee.blade.php ENDPATH**/ ?>