
<?php $__env->startSection('title'); ?> Cotisations à encaisser <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',""); ?>
<?php $__env->startSection('subtitle_card',""); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>
    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>
    <div class='col-lg-max'>
        <div class="card">
            <div class="card-header bg-info">
                <h3>Cotisations à encaisser</h3>
            </div>
            <div class="card-body">
                <div class="row col-md-12">
                    <table id="_table" style="width:100%;background-color:white" 
                        class="table table-striped table-bordered table-hover" width="100%" >
                        <thead>
                            <tr>
                                <th width="1px">N°</th>
                                <th width="1px">Ex</th>
                                <th>Employeur</th>
                                <th width="1px">Date</th>
                                <th >Pmt</th> 
                                <th >CLR</th> 
                                <th >CCPF</th>
                                <th >Débit</th>
                                <th >Crédit</th>
                                <th width="1px">Mois</th>
                                <th width="1px">NbMois</th>
                                <th >BdPu</th>
                                <th >BdPr</th>
                                <th>Observations</th>
                                <th width="1px">&nbsp</th>
                            </tr>
                        </thead> 
                        <tfoot>
                            <tr style='background-color:lightgrey'>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>                        
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                            </tr>
                        </tfoot>

                        <tbody>
                            <?php $__currentLoopData = $cotisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cotisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td id='id_<?php echo $cotisation->id; ?>' style="color:grey">
                                    <?php if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                        <a class="btn btn-sm bg-info" href="<?php echo url('cotisations/'.$cotisation->id ); ?>">
                                    <?php endif; ?>
                                        <?php echo $cotisation->id; ?>

                                    <?php if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                        </a>
                                    <?php endif; ?>
                                </td>
                                <td align="center"><?php echo $cotisation->exercice; ?></td>
                                <td ><?php echo $cotisation->employeur; ?></td>
                                <td align="center"><?php echo $cotisation->date; ?></td>
                                <td align="center"><?php echo $cotisation->typepmt; ?></td>
                                <td align="right" nowrap><?php echo $cotisation->clr; ?></td>
                                <td align="right" nowrap><?php echo $cotisation->ccpf; ?></td>
                                <td align="right" style="font-weight:bold;color:darkred" class="" nowrap><?php echo $cotisation->debit; ?></td>
                                <td align="right" style="font-weight:bold;color:darkblue" class="" nowrap><?php echo $cotisation->credit; ?></td>
                                <td><?php echo $cotisation->mois; ?></td>
                                <td align="center"><?php echo $cotisation->nbmois; ?></td>
                                <td align="right"><?php echo $cotisation->bdx; ?></td>
                                <td align="right"><?php echo $cotisation->bdx_prive; ?></td>
                                <td><?php echo $cotisation->observation; ?></td>
                                
                                <td nowrap> 
                                <?php if(1==0): ?>                           
                                    <?php if( ($user->can("COT_ENC") || $user->HasRole("ADMINISTRATEUR"))
                                        ): ?>
                                        <a href="<?php echo url('cotisations_encaiss/'.$cotisation->id ); ?>"
                                             class="btn btn-primary pull-left" style="margin-right: 3px;">Encaisser</a>
                                    <?php endif; ?> 
                                 <?php endif; ?> 
                                </td>
                                
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <div class="row form-group" style='font-weight:bold;margin-top:20px;margin-bottom:20px'>
                    <div class="col-md-2">
                        <div>TOTAL&nbsp;CLR&nbsp;:&nbsp;</div>
                        <div class='form-control' align='right' id='total_CLR'></div>
                    </div>

                    <div class="col-md-2">TOTAL&nbsp;CCPF&nbsp;:&nbsp;
                        <div class='form-control' align='right' id='total_CCPF'></div>
                    </div>

                    <div class="col-md-2">TOTAL&nbsp;DEBIT&nbsp;:&nbsp;
                        <div class='form-control' style='color:red' align='right' id='total_DEBIT'></div>
                    </div>

                    <div class="col-md-2">TOTAL&nbsp;CREDIT&nbsp;:&nbsp;
                        <div class='form-control' style='color:blue' align='right' id='total_CREDIT'></div>
                    </div>

                    <div class="col-md-2">SOLDE&nbsp;:&nbsp;
                        <div class='form-control' style='color:green' align='right' id='total_SOLDE'></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function() {
        $.fn.dataTable.moment('D/M/YYYY');
    
        function format(n, sep) {
            sep = sep || "."; // Default to period as decimal separator
            return n.toLocaleString().split(sep)[0]
                + sep;
        }

        // Setup - add a text input to each footer cell
        $('#_table tfoot th:lt(14)').each( function (i) {
            var title = $('#_table thead th').eq( $(this).index() ).text();
                size=4;
                if (title === "N°") size=2;
                if (title === "Ex") size=2;
                if (title === "Employeur") size=12;
                if (title === "Observations") size=18;
                $(this).html( '<input size='+size+' type="text" placeholder="'+title+'" data-index="'+i+'" />' );
        } );


        var table =$('#_table').DataTable( {
            bAutoWidth: false,
            bPaginate: false,
            bInfo: true,
            bFilter: true,
            //deferRender:    true,
            scrollY:        "400px",
            scrollX:        true,
            scrollCollapse: true,
            oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "decimal": ",",
                "thousands": " ",
                "sSearch":"Chercher",

                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',
                    print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                        }
                    }
                },


                "footerCallback": function(row, data, start, end, display) {
                    var api = this.api(), data;
                    var intVal = function ( i ) {
                        return typeof i === 'string' ?
                            i.replace(/[\$,]/g, '')*1 :
                            typeof i === 'number' ?
                                i : 0;
                    };

                    total = api.column(5, { page: 'current'}).data().reduce(function(a, b) {
                            return intVal(a) + intVal(b);}, 0);
                    total=format(total,' ');
                    $('#total_CLR').html(total);

                    total = api.column(6, { page: 'current'}).data().reduce(function(a, b) {
                            return intVal(a) + intVal(b);}, 0);
                    total=format(total, ' ');
                    $('#total_CCPF').html(total);


                    total = api.column(7, { page: 'current'}).data().reduce(function(a, b) {
                            return intVal(a) + intVal(b);}, 0);
                    var total_debit=total;
                    total=format(total, ' ');
                    $('#total_DEBIT').html(total);

                    total = api.column(8, { page: 'current'}).data().reduce(function(a, b) {
                            return intVal(a) + intVal(b);}, 0);
                    var total_credit=total;
                    total=format(total, ' ');
                    $('#total_CREDIT').html(total);


                    total=total_credit-total_debit;
                    total=format(total, ' ');
                    $('#total_SOLDE').html(total);
                },

                "aaSorting": [
                    [0,'desc']
                ],

                "aoColumnDefs": [
                    { "sTypes": "numeric", "aTargets": [ 3 ] },
                    { bSortable: false, aTargets: [13,14] },
                    { visible: false, targets: [10,11,12] },
                ],


                dom: "<'row'<'col-sm-1 text-left'f><'col-sm-4'><'col-sm-7 text-right'B>>" +
                    "<'row'<'col-sm-12'tr>>" +"<'row'<'col-sm-3 text-left'i><'col-sm-9 text-left'>>",

                buttons: [ 
                    {extend: 'copy',exportOptions: {columns: ':visible'} },
                    {extend: 'excel',exportOptions: {columns: ':visible'} }, 
                    'colvis'
                ],

            } );

            // Filter event handler
            $( table.table().container() ).on( 'keyup', 'tfoot input', function () {
                table
                    .column( $(this).data('index') )
                    .search( this.value )
                    .draw();
            } );

            $('#_table').DataTable().draw();

            $(window).resize(function () {
                $('#_table').DataTable().draw();
            });
    } );
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/recouvrement/cotisations/index_encours.blade.php ENDPATH**/ ?>