<?php $__env->startSection('title'); ?> Cotisations <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',""); ?>
<?php $__env->startSection('subtitle_card',""); ?>


<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="col-lg-max col-lg-offset-1 container-fluid">
            <div class="card-header bg-info">
                Mises en demeure<small> - Employeurs Actifs</small>
            </div>
            <div class="card-body">
                <div class="row form-group col-md-10 form-inline">
                    <?php echo html()->label( 'Année :&nbsp;','annee'); ?>

                    <?php echo html()->select('exercice',$exercices,$exercice)
                        ->placeholder('A définir')
                        ->attributes(['id' => 'exercice_id','class' => 'form-control']); ?>

                </div>
                <div class="row ">
                    <div class="col-lg-max">
                        <table id="_table" style="background-color:white" class="table table-condensed table-striped table-hover table-bordered">
                            <thead>
                                <tr>
                                    <th >N°</th>
                                    <th>Nom</th>
                                    <th >Adresse</th>
                                    <th >Ile</th>
                                    <th >NbSal</th>
                                    <th >Date<br>1er Immat.</th>
                                    <th >Masse<br>Derniers Salaires</th>
                                    <th >Dernier<br/>mois</th>
                                    <th >Mois<br>Manquants</th>
                                    <th >Cotis.<br>Manquante</th>
                                    <th >Maj</th>
                                    <th >Total</th>
                                    <th >Mise en<br>demeure</th>
                                    <th ></th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php $__currentLoopData = $employeurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employeur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $masse_dernier=$employeur->getMasseDerniersSalaires($exercice);

                                        $masse_dernier=0;
                                        $mois_manquants=0;
                                        $dernier_mois="";
                                        $taux_total=0;
                                        $cotis=0;

                                        if($exercice=="")
                                        /**/
                                        $mois_manquants=$employeur->getNbMoisManquantsSalaires($exercice);
                                        $dernier_mois=$employeur->DateDernierSalaire;
                                        $taux_total=$taux;
                                        $cotis=round($masse_dernier*$taux_total/100,0);
                                        $cotis=round($cotis*$mois_manquants);

                                        if(!is_numeric($exercice)) $exercice=0;
                                        $maj=$employeur->getMajoration($exercice);//round($prc_maj*$cotis/100);

                                        $numero="";
                                    ?>
                                    <tr>
                                        <td><?php echo str_pad($employeur->id,4,'0',STR_PAD_LEFT); ?></td>
                                        <td><a href="<?php echo url('employeurs/')."/".$employeur->id; ?>" target="_blank"><?php echo $employeur->NomReduit; ?></a></td>
                                        <td><?php echo $employeur->adresse; ?></td>
                                        <td><?php echo $employeur->ile; ?></td>
                                        <td><?php echo $employeur->getNbEmployes($exercice); ?></td>
                                        <td ><?php echo $employeur->date_deb; ?></td>
                                        <td align="right"><?php echo $masse_dernier; ?></td>
                                        <td ><?php echo $dernier_mois; ?></td>
                                        <td ><?php echo $mois_manquants; ?></td>
                                        <td align="right"><?php echo $cotis; ?></td>
                                        <td align="right"><?php echo $maj; ?></td>
                                        <td align="right"><?php echo $cotis+$maj; ?></td>
                                        <td align="center"><?php echo $employeur->ListeMedHTML; ?></td>
                                        <td >
                                            <?php if($cotis+$maj>0): ?>
                                            <a href="<?php echo url('med_create/')."/".$employeur->id; ?>"
                                                class="btn btn-success pull-left"
                                                style="margin-right: 3px;"
                                                 target="_blank">
                                                <span class="glyphicon glyphicon-plus">MED</span>
                                            </a>
                                            <?php endif; ?>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox.css')); ?>">
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox-buttons.css')); ?>">

    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery-ui.structure.min.css')); ?>">
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery-ui.theme.min.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts0'); ?>
    <script src="<?php echo e(url('js/jquery.fancybox.js')); ?>"></script>
    <script src="<?php echo e(url('js/magicsuggest.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            $('#exercice_id').on('change', function() {
                location.href="<?php echo url('med_prepa/'); ?>/"
                    +$('#exercice_id').val();
            });
        });
    </script>
<?php $__env->stopSection(); ?>                  


<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            var table =$('#_table').DataTable( {
                bAutoWidth: false,
                bPaginate: true,
                bInfo: true,
                bFilter: true,
                //scrollY:        500,
                //scrollX:        true,
                //scrollCollapse: true,
                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "decimal": ",",
                    "thousands": " ",
                    "sSearch":"Chercher",

                    buttons: {
                        colvis: 'Colonnes à afficher',
                        copy: 'Copier',
                        print: 'Imprimer',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                        }
                    }

                    },
                    "aaSorting": [[0,'desc']],

                    "aoColumnDefs": [
                        { "sTypes": "numeric", "aTargets": [ 5,6,7 ] },
                        { bSortable: false, aTargets: [] },
                        { visible: false, targets: [] },
                    ],
                    dom: "<'row'<'col-sm-2 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                    buttons: [
                        {extend: 'copy',exportOptions: {columns: ':visible'} },
                        {extend: 'excel',exportOptions: {columns: ':visible'} },
                        'colvis'
                    ],
                } );

        } );
    </script>
<?php $__env->stopSection(); ?> 




<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/recouvrement/med/index.blade.php ENDPATH**/ ?>