

<?php $__env->startSection('title'); ?> Employeurs <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Employeurs <?php $__env->stopSection(); ?>
<?php $__env->startSection('subtitle_card',"Liste complète"); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">

        <?php if(Session::has('message')): ?>
            <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
        <?php endif; ?>

        <div class="card-header">
            <div class="form-group row">
                <div class='col-md-3'>
                    <?php echo Form::label('select_statut', 'Statut'); ?>

                    <?php echo Form::select('select_statut',
                            $statuts,isset($statut)?$statut:"",
                                ['placeholder'=>'Choisir un statut','class' => 'form-control','onchange' => 'valide()']); ?> 
                </div>
                <div class='col-md-2'>
                    <?php echo Form::label('select_ile', 'Ile'); ?>

                    <?php echo Form::select('select_ile',
                            $iles,isset($ile)?$ile:"",
                                ['placeholder'=>'Choisr une origine','class' => 'form-control','onchange' => 'valide()']); ?> 
                </div>
            </div>

            <script>
                function valide() {
                    var select_statut = [...document.getElementById('select_statut').selectedOptions].map(option => option.value);
                    if(select_statut=="") select_statut=0;
                    var select_ile = [...document.getElementById('select_ile').selectedOptions].map(option => option.value);
                    if(select_ile=="") select_ile=0;

                    var url="<?php echo url('tiers/employeurs/'); ?>/"+select_statut+"/"+select_ile  ; 
                    location.href=url;
                }
            </script>
        </div>


        <div class="card-body">
            <table id="_table" style="background-color:white"  
                class="table table-condensed table-striped table-hover table-bordered">
                <thead>
                    <tr>
                        <th width='1%'>N°</th>
                        <th>Nom</th>
                        <th>CompteAux</th>
                        <th width='1%'>NbSalariés</th>
                        <th width='1%'>ile</th>
                        <th width='30%'>Responsable</th>
                        <th width='30%'>Email</th>
                        <th width='1%'>Secteur</th>
                        <th width='5%'>Statut</th>
                        <?php if(1==0): ?>
                        <th width='1%'>
                            <?php if($user->can("EMP_AJO") || $user->HasRole("ADMINISTRATEUR")): ?>
                                <a href="./employeurs/create" class="btn btn-success">Ajouter un Employeur</a> 
                            <?php endif; ?> 
                        </th>
                        <?php endif; ?>
                    </tr>
                </thead>
     
                <tbody>
                    <?php $__currentLoopData = $employeurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employeur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class=""><?php echo str_pad($employeur->id,4,'0',STR_PAD_LEFT); ?></td>
                        <td>
                            <?php if($user->can("EMP_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                <a href="<?php echo url('/tiers/employeurs/'.$employeur->id); ?>" ><?php echo $employeur->NomReduit; ?></a>
                            <?php else: ?>
                                <?php echo $employeur->NomReduit; ?>

                            <?php endif; ?> 
                        </td>
                        <td><?php echo $employeur->compte_aux; ?></td>
                        <td><?php echo $employeur->Nbemployes; ?></td>
                        <td><?php echo $employeur->ile; ?></td>
                        <td><?php echo (strlen($employeur->responsable)>20)?substr($employeur->responsable,0,20):$employeur->responsable; ?></td>
                        <td><?php echo $employeur->email; ?></td>
                        <td><?php echo $employeur->secteur; ?></td>
                        <td><?php echo $employeur->statut; ?></td>
                        <?php if(1==0): ?>
                        <td>
                        <?php if($user->can("EMP_MAJ") || $user->HasRole("ADMINISTRATEUR")): ?>
                            <a href="<?php echo url('/tiers/employeurs/'.$employeur->id.'/edit'); ?>" class="btn btn-info pull-left" style="margin-right: 3px;">Modifier</a>
                        <?php endif; ?> 
                        <?php if($user->can("EMP_SUP")): ?>   
                            <?php if($employeur->has_cascade): ?>      
                                <?php echo Form::open(['url' => '/tiers/employeurs/' . $employeur->id, 'method' => 'DELETE']); ?>

                                <?php echo Form::submit('Supprimer', ['class' => 'btn btn-danger']); ?>

                                <?php echo Form::close(); ?>

                            <?php endif; ?> 
                        <?php endif; ?> 
                        </td>
                        <?php endif; ?>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre_new\resources\views/tiers/employeurs/index.blade.php ENDPATH**/ ?>