
<?php $__env->startSection('title'); ?>Consultation d'un bénéficiaire <?php $__env->stopSection(); ?>
 

<?php $__env->startSection('styles'); ?>
    <?php echo Html::style('css/jquery.fancybox.css'); ?> 
    <?php echo Html::style('css/jquery.fancybox-buttons.css'); ?> 
    <!-- Datatable -->
    <?php echo Html::style('css/dataTables.bootstrap.css'); ?> 
    <?php echo Html::style('css/buttons.bootstrap.css'); ?> 
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
 
<div class='col-lg-max col-lg-offset-1'>
 
    <h2>Bénéficiaire <span style='color:darkblue'><?php echo $beneficiaire->nomcomplet; ?></span>
    <small></small></h2>

    <?php echo Form::model($beneficiaire, ['beneficiaire' => 'form'
        , 'url' => '', 'method' => '', 'class' => 'form-horizontal']); ?>

  
      <ul class="nav nav-tabs">
        <li class="active"><a href="#nom" data-toggle="tab">Etat civil-Statut</a></li>
        <li><a href="#adresse" data-toggle="tab">Adresse</a></li>
        <li><a href="#famille" data-toggle="tab">Conjoint-Famille</a></li>
        <li><a href="#banque" data-toggle="tab">Employeur/Banque</a></li>
        <li><a href="#allocation" data-toggle="tab">Allocations</a></li>
        <?php if( $user->HasRole('ADMINISTRATEUR')|| $user->can('SAL_VISU') ): ?> 
            <li><a href="#salaires" data-toggle="tab">Salaires</a></li>
        <?php endif; ?>
        <?php if( $user->HasRole('ADMINISTRATEUR')|| $user->can('VER_VISU') ): ?>
        <li><a href="#versements" data-toggle="tab">Versements</a></li>
        <?php endif; ?>
        <?php if( $user->HasRole('ADMINISTRATEUR')|| $user->can('RET_VISU') ): ?>
        <li><a href="#retraite" data-toggle="tab">Retraite</a></li>
        <?php endif; ?>
        <li><a href="#editions" data-toggle="tab">Editions</a></li>
    </ul>
    <script>
        $('#rowTab a:first').tab('show');
        $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
            var nom_onglet=$(e.target).attr('name');
        });
    </script>


<div class="tab-content" style="padding-top:15px">
<!-- ------------------------------------- ONGLET NOM ------------------------------- -->
    <div class="tab-pane active" id="nom">
        <div class="form-group">
            <div class="col-md-2">
            <div class="has-success has-feedback">
                <div class="input-group">
                    <span class="input-group-addon">N°</span>
                    <input readonly="readonly" type="text" class="form-control" name="id" id="id" 
                    value='<?php echo str_pad($beneficiaire->id, 6, "0", STR_PAD_LEFT); ?>' />
                </div>
           </div>
           </div>
        </div>
        <div class="col-md-9 bg-success">
            <div class="form-group">
                <div class="col-md-3">
                        <?php echo Form::label('nom', 'Nom'); ?>

                        <?php echo Form::text('nom', null, ['placeholder' => 'Nom', 'class' => 'form-control text-uppercase','readonly'=>'true']); ?>

                </div>
                <div class="col-md-3">
                        <?php echo Form::label('prenom', 'Prenom'); ?>

                        <?php echo Form::text('prenom', null, ['placeholder' => 'Prénom', 'class' => 'form-control','readonly'=>'true']); ?>

                </div>

                <div class="col-md-3">
                <?php echo Form::label('civilite', 'Civilité'); ?>

                <br/>
                <?php echo Form::select('civilite',[''=>'A définir','Mr'=>'Monsieur','Mme' => 'Madame', 'Mll' => 'Mademoiselle'],$beneficiaire->civilite,['class' => 'selectpicker','disabled'=>'true'] ); ?>

                </div>
            </div>

            <div class="form-group">
                <div class="col-md-3">
                    <?php echo Form::label('datenaiss', 'date de naissance'); ?>

                    <div class="input-group">
                        <div class='input-group date' id='datepicker_datenaiss'>
                                <?php echo Form::text('datenaiss', $beneficiaire->datenaiss, ['placeholder' => 'Date de naissance', 'class' => 'form-control','readonly'=>'true']); ?>

                        </div>
                    </div>
                </div>

                <div class="col-md-4">
                <?php echo Form::label('lieunaiss', 'Lieu de naissance'); ?>

                <?php echo Form::text('lieunaiss', null, ['placeholder' => 'Lieu de naissance', 'class' => 'form-control text-uppercase','readonly'=>'true']); ?>

                </div>

                <div class='col-md-2'>
                    <?php echo Form::label('n_all', 'Certificat de vie'); ?>

                    <?php echo Form::text('n_all', null, ['placeholder' => 'Certificat de vie', 'class' => 'form-control','readonly'=>'true']); ?>

                </div>

                <div class="col-md-3">
                    <?php echo Form::label('date_deces', 'date de décès'); ?>

                    <div class="input-group">
                        <div class='input-group date' id='datepicker_date_deces'>
                                <?php echo Form::text('date_deces', $beneficiaire->date_deces, ['placeholder' => 'Date de décès', 'class' => 'form-control','readonly'=>'true']); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class='form-group'>
                <div class="col-md-6">
                <?php echo Form::label('statut', 'Statut'); ?>

                <br/>
                <?php echo Form::select('statut',$liste_benefstatut,$beneficiaire->statut,
                    ['class' => 'selectpicker','data-width' => "100%",'disabled']); ?>

                </div>
            </div>

            <div class='form-group'>

                <div class="col-md-3">
                    <?php echo Form::label('created_at', 'Date de création'); ?>

                    <?php echo Form::text('created_at', null, ['class' => 'form-control','readonly'=>'true']); ?>

                </div>

                <div class="col-md-3">
                    <?php echo Form::label('date_pi', 'Date 1ère immatriculation'); ?>

                    <div class="input-group">
                        <div class='input-group date' id='datepicker_datepi'>
                                <?php echo Form::text('date_pi', $beneficiaire->date_pi, ['placeholder' => 'Date 1ère immatriculation', 'class' => 'form-control','readonly'=>'true']); ?>

                        </div>
                    </div>
                </div>
            </div>

            <div class="form-group"> 
                <div class='col-md-2'>
                    <?php echo Form::label('verrou', 'Verrou'); ?>

                    <?php echo Form::checkbox('verrou', null, ['class' => 'form-control','disabled']); ?>

                </div>
            </div>

            <div class='form-group'>
                <div class="col-md-8">
                <?php echo Form::label('obs', 'Observations'); ?>

                <?php echo Form::textarea('obs', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'3','readonly'=>'true']); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- ------------------------------------- ONGLET ADRESSE ------------------------------- -->

    <div class="tab-pane col-md-9 bg-info" id="adresse">
        <div class="form-group"> 
            <div class='col-md-8'>
                <?php echo Form::label('adresse', 'Adresse'); ?>

                <?php echo Form::textarea('adresse', null, ['placeholder' => 'ADRESSE', 'class' => 'form-control', 'rows'=>'2','readonly'=>'true']); ?>

            </div>
        </div>
 
        <div class="form-group"> 
            <div class='col-md-2'>
                <?php echo Form::label('code_postal', 'Code postal'); ?>

                <?php echo Form::text('code_postal', null, ['placeholder' => 'CODE POSTAL', 'class' => 'form-control','readonly'=>'true']); ?>

            </div>

            <div class='col-md-3'>
                <?php echo Form::label('district', 'District - Zone'); ?>

                <br/>
                <?php echo Form::select(
                    'district',
                    [''=>'AUTRE','HAHAKE' => 'HAHAKE', 'HIHIFO' => 'HIHIFO', 'MUA' => 'MUA','TEPA' => 'MUA-TEPA', 'SIGAVE' => 'SIGAVE', 'ALO' => 'ALO', 'NOUVELLE-CALEDONIE' => 'NOUVELLE-CALEDONIE', 'TAHITI' => 'TAHITI'],
                    $beneficiaire->district,
                    [
                        'class' => 'selectpicker','disabled','data-width' => "100%",
                    ]
                ); ?>

            </div>
        </div>     

        <div class="form-group"> 
            <div class='col-md-3'>
                <?php echo Form::label('ile', 'Ile'); ?>

                <br/>
                    <?php echo Form::select(
                        'ile',
                        [''=>'AUTRE','W' => 'Wallis', 'F' => 'Futuna', 'N' => 'Nouvelle-Calédonie', 'P' => 'Polynésie'],
                        $beneficiaire->ile,
                        [
                            'class' => 'selectpicker','disabled','data-width' => "100%",
                        ]
                    ); ?>                
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-6">
                <?php echo Form::label('email', 'Email'); ?>

                <?php echo Form::email('email', null, ['placeholder' => 'EMAIL', 'class' => 'form-control','readonly'=>'true'] ); ?>

            </div>
        </div>

        <div class="form-group"> 
            <div class='col-md-3'>
                <?php echo Form::label('tel', 'Téléphone'); ?>

                <?php echo Form::text('tel', null, ['placeholder' => 'TELEPHONE', 'class' => 'form-control','readonly'=>'true']); ?>

            </div>

            <div class='col-md-3'>
                <?php echo Form::label('fax', 'Fax'); ?>

                <?php echo Form::text('fax', null, ['placeholder' => 'FAX', 'class' => 'form-control','readonly'=>'true']); ?>

            </div>
        </div>
    </div>

    <!-- ------------------------------------- ONGLET FAMILLE ------------------------------- -->

    <div class="tab-pane" id="famille">
        <div class="form-group">
            <div class="col-md-6">
                <?php echo Form::label('nom_conjoint', 'Conjoint'); ?>


                <div class="input-group">
                    <span class="input-group-addon"><?php echo str_pad($beneficiaire->conjoint, 6, "0", STR_PAD_LEFT); ?></span>
                    <input type="text" class="form-control" name="nom_conjoint" id="nom_conjoint" 
                        value='<?php echo $beneficiaire->nom_conjoint; ?>' placeholder="Conjoint" />
                </div>
            </div>
        </div>

        <div class="form-group"> 
            <div class='col-md-2'>
                <?php echo Form::label('nb_enf', "Nombre d'enfants"); ?>

                <?php echo Form::text('nb_enf', null, ['placeholder' => "Nombre d'enfants", 'class' => 'form-control','readonly'=>'true']); ?>

            </div>

            <div class='col-md-2'>
                <?php echo Form::label('nb_enf_tot', "Nombre d'enfants total"); ?>

                <?php echo Form::text('nb_enf_tot', null, ['placeholder' => "Nombre d'enfants total", 'class' => 'form-control','readonly'=>'true']); ?>

            </div>
        </div> 

        <br/>

        <div class="row">
            <div class="col-xs-8" >
                <h4>Enfants</h4>
                <table id="_table" class="table table-condensed table-striped table-bordered" width="90%" >
                    <thead>
                        <tr>
                            <th width='1%'>Id</th>
                            <th width='20%'>Nom</th>
                            <th width='10%'>Prenom</th>
                            <th width='5%'>Date de naissance</th>
                            <th width='1%'>Sexe</th>
                            <th width='20%'>Certificat</th>
                            <th  width='220px'>&nbsp;</th>
                        </tr>
                    </thead>
         
                    <tbody>
                        <?php $__currentLoopData = $enfants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enfant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo str_pad($enfant->id, 6, "0", STR_PAD_LEFT); ?></td>
                            <td nowrap><?php echo $enfant->nom; ?></td>
                            <td nowrap><?php echo $enfant->prenom; ?></td>
                            <td nowrap><?php echo $enfant->datenais; ?></td>
                            <td nowrap><?php echo $enfant->sexe; ?></td>
                            <td nowrap><?php echo $enfant->certif; ?></td>
                            <td nowrap>
                                <a href="<?php echo url('tiers/enfants/'.$enfant->id); ?>" 
                                    class="various fancybox.iframe btn btn-warning" 
                                    style="margin-right: 3px;">Consulter</a>           
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
         
                </table>
             </div> 
         </div> 
    </div>


    <!-- ------------------------------------- ONGLET BANQUE ------------------------------- -->

    <div class="tab-pane" id="banque">
        <div class="form-group">
            <div class="col-md-8">
                <?php echo Form::label('employeur', 'Employeur'); ?>

                <div class="input-group">
                    <div class="input-group-addon" id="ref_banque"><?php echo $beneficiaire->sonum; ?></div>
                    <?php echo Form::text('employeur', $beneficiaire->Employeur, ['disabled' => 'true', 'class' => 'form-control']); ?>

                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-5">
                <?php echo Form::label('banque_id', 'Banque'); ?>

                <div class="input-group">
                    <div class="input-group-addon" id="ref_banque"><?php echo (isset($beneficiaire_banque->banque_id)?$beneficiaire_banque->banque_id:""); ?></div>
                    <?php echo Form::text('banque', (isset($beneficiaire_banque->NomBanque)?$beneficiaire_banque->NomBanque:""), ['disabled' => 'true', 'class' => 'form-control']); ?>

                </div>
            </div>
        </div>

        <!--
        <div class="form-group">
            <div class="col-md-3">
                <?php echo Form::label('compte', 'Compte'); ?>

                <?php echo Form::text('compte', null, ['placeholder' => 'COMPTE', 'class' => 'form-control','readonly'=>'true']); ?>

            </div>
        </div>
        -->



            <div class="form-group bg-info alert">
                <div class="col-md-12 ">
                <?php echo Form::label('IBAN', 'IBAN'); ?>

                </div>

                <div class="col-md-1">
                    <?php echo Form::label('IBAN_pays', 'Pays'); ?>

                    <?php echo Form::text('IBAN_pays',( isset($beneficiaire_banque->IBAN_pays)?$beneficiaire_banque->IBAN_pays:""), ['readonly'=>'true',
                        'class' => 'form-control text-uppercase']); ?>

                </div>
                <div class="col-md-1">
                    <?php echo Form::label('IBAN', 'Clé IBAN'); ?>

                    <?php echo Form::text('IBAN_cle', (isset($beneficiaire_banque->IBAN_cle)?$beneficiaire_banque->IBAN_cle:""), ['readonly'=>'true',
                        'class' => 'form-control text-uppercase']); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::label('IBAN_banque', 'Banque'); ?>

                    <?php echo Form::text('IBAN_banque', (isset($beneficiaire_banque->IBAN_banque)?$beneficiaire_banque->IBAN_banque:""), ['readonly'=>'true', 
                        'class' => 'form-control text-uppercase']); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::label('IBAN_guichet', 'Guichet'); ?>

                    <?php echo Form::text('IBAN_guichet',(isset($beneficiaire_banque->IBAN_guichet)?$beneficiaire_banque->IBAN_guichet:""), ['readonly'=>'true',
                        'class' => 'form-control text-uppercase']); ?>

                </div>
                <div class="col-md-3">
                    <?php echo Form::label('IBAN_compte', 'Numéro de compte'); ?>

                    <?php echo Form::text('IBAN_compte', (isset($beneficiaire_banque->IBAN_compte)?$beneficiaire_banque->IBAN_compte:""), ['readonly'=>'true',
                        'class' => 'form-control text-uppercase']); ?>

                </div>
                <div class="col-md-1">
                    <?php echo Form::label('IBAN_clerib', 'Clé RIb'); ?>

                    <?php echo Form::text('IBAN_clerib', (isset($beneficiaire_banque->IBAN_clerib)?$beneficiaire_banque->IBAN_clerib:""), ['readonly'=>'true',
                        'class' => 'form-control text-uppercase']); ?>

                </div>
            </div>

    </div>

    <!-- ------------------------------------- ONGLET ALLOCATION ------------------------------- -->

    <div class="tab-pane" id="allocation">      
        <div class="form-group">
            <div class="col-md-2">
                <?php echo Form::label('nb_enf', 'Nb enfants'); ?>

                <?php echo Form::text('nb_enf', null, ['placeholder' => 'Nombre d\'enfants', 'class' => 'form-control','readonly'=>'true']); ?>

            </div>
        </div>

        <?php echo Form::label('montants_allocations', 'Montants'); ?>

        <div class="form-group">
            <div class="col-md-4">
                <div class="input-group has-success">
                    <div class="input-group-addon" style="width:100px">Montant allocation</div>
                    <?php echo Form::text('mt_allloc', null, ['placeholder' => 'Montant', 'class' => 'text-right form-control','readonly'=>'true']); ?>

                    <div class="input-group-addon">CFP</div>
                </div>
            </div>
        </div>


        <div class="form-group">
            <div class="col-md-4">
                <div class="input-group has-warning">
                    <div class="input-group-addon">Montant calculé</div>
                    <?php echo Form::text('mt_calc', null, ['placeholder' => 'Montant calculé', 'class' => 'text-right form-control','readonly'=>'true']); ?>

                    <div class="input-group-addon">CFP</div>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-4">
                <div class="input-group has-error">
                    <div class="input-group-addon ">Montant rappel</div>
                    <?php echo Form::text('rappel', null, ['placeholder' => 'Montant rappel', 'class' => 'text-right form-control','readonly'=>'true']); ?>

                    <div class="input-group-addon">CFP</div>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-8">
                <?php echo Form::label('obs_vers', 'Observations'); ?>

                <?php echo Form::textarea('obs_vers', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'3','readonly'=>'true']); ?>

            </div>
         </div>
    </div>

    <!-- ------------------------------------- ONGLET SALAIRES ------------------------------- -->
    <div class="tab-pane" id="salaires">
        <div class="form-group">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table id="_table_longue" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1%'>N°</th>
                                <th width='20%'>Employeur</th>
                                <th width='1%'>Année</th>
                                <th width='5%'>Jan</th>
                                <th width='5%'>Fév</th>
                                <th width='5%'>Mar</th>
                                <th width='5%'>Avr</th>
                                <th width='5%'>Mai</th>
                                <th width='5%'>Jui</th>
                                <th width='5%'>Jui</th>
                                <th width='5%'>Aou</th>
                                <th width='5%'>Sep</th>
                                <th width='5%'>Oct</th>
                                <th width='5%'>Nov</th>
                                <th width='5%'>Déc</th>
                                <th width='5%'>&nbsp;</th>
                            </tr>
                        </thead>
             
                        <tbody>
                            <?php
                               
                            ?>
                            <?php $__currentLoopData = $salaires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salaire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $style='success';
                                $class_jan=isset($t_salaires_ref[$salaire->annee.'-01'])?$style:'';
                                $class_fev=isset($t_salaires_ref[$salaire->annee.'-02'])?$style:'';
                                $class_mar=isset($t_salaires_ref[$salaire->annee.'-03'])?$style:'';
                                $class_avr=isset($t_salaires_ref[$salaire->annee.'-04'])?$style:'';
                                $class_mai=isset($t_salaires_ref[$salaire->annee.'-05'])?$style:'';
                                $class_jun=isset($t_salaires_ref[$salaire->annee.'-06'])?$style:'';
                                $class_jui=isset($t_salaires_ref[$salaire->annee.'-07'])?$style:'';
                                $class_aou=isset($t_salaires_ref[$salaire->annee.'-08'])?$style:'';
                                $class_sep=isset($t_salaires_ref[$salaire->annee.'-09'])?$style:'';
                                $class_oct=isset($t_salaires_ref[$salaire->annee.'-10'])?$style:'';
                                $class_nov=isset($t_salaires_ref[$salaire->annee.'-11'])?$style:'';
                                $class_dec=isset($t_salaires_ref[$salaire->annee.'-12'])?$style:'';
                            ?>
                            <tr>
                                <td><?php echo $salaire->id; ?></td>
                                <td nowrap><?php echo $salaire->employeur_nom; ?></td>
                                <td nowrap><?php echo $salaire->annee; ?></td>
                                <td nowrap class='<?php echo $class_jan; ?>' align='right'><?php echo $salaire->jan; ?></td>
                                <td nowrap class='<?php echo $class_fev; ?>' align='right'><?php echo $salaire->fev; ?></td>
                                <td nowrap class='<?php echo $class_mar; ?>' align='right'><?php echo $salaire->mar; ?></td>
                                <td nowrap class='<?php echo $class_avr; ?>' align='right'><?php echo $salaire->avr; ?></td>
                                <td nowrap class='<?php echo $class_mai; ?>' align='right'><?php echo $salaire->mai; ?></td>
                                <td nowrap class='<?php echo $class_jun; ?>' align='right'><?php echo $salaire->jun; ?></td>
                                <td nowrap class='<?php echo $class_jui; ?>' align='right'><?php echo $salaire->jui; ?></td>
                                <td nowrap class='<?php echo $class_aou; ?>' align='right'><?php echo $salaire->aou; ?></td>
                                <td nowrap class='<?php echo $class_sep; ?>' align='right'><?php echo $salaire->sep; ?></td>
                                <td nowrap class='<?php echo $class_oct; ?>' align='right'><?php echo $salaire->oct; ?></td>
                                <td nowrap class='<?php echo $class_nov; ?>' align='right'><?php echo $salaire->nov; ?></td>
                                <td nowrap class='<?php echo $class_dec; ?>' align='right'><?php echo $salaire->dec; ?></td>
                                <td nowrap align='right'></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
             
                    </table>
                </div>

                <div class="form-group">
                    <div class='col-md-8'>
                        <?php
                            $t=explode('~',$beneficiaire->MoyenneMeilleursSalaires);
                        ?>
                        <?php echo Form::label('best_sal', 'Le salaire moyen des '.$t[1].' meilleurs mois est de : '.number_format($t[0],0,","," ")." CFP"); ?>

                    </div>
                </div>

                <div class="form-group">
                    <div class="col-md-3">

                        <a href="<?php echo url('salaire_imprime/'.$beneficiaire->id); ?>" 
                        class="btn btn-info" 
                        target="_blank">Imprimer</a>
                        
                        <a href="<?php echo url('/salaire_liquidation/'.$beneficiaire->id); ?>" 
                        id=''  class="btn btn-info" 
                        target="_blank">Feuille de Liquidation</a>

                    </div>

                    <?php if( ($beneficiaire->sonum>0) && ($user->can("SAL_AJO") || $user->HasRole("ADMINISTRATEUR") ) ): ?>
                     <div class="col-md-3">
                        <a href="<?php echo url('recouvrement/salaire_annee/'.$beneficiaire->sonum.'/'.$beneficiaire->id); ?>" 
                            class="btn btn-success"
                            target="_blank">Gestion des Salaires</a>
                    </div> 
            <?php endif; ?> 
                </div>                
            </div>
        </div>
     </div>

    <!-- ------------------------------------- ONGLET VERSEMENTS ------------------------------- -->
    <div class="tab-pane" id="versements">
        <div class="form-group">
            <div class="col-md-8">
                <?php if(count($versements)>0): ?>
                <div class="table-responsive">
                    <table id="_table_vers" style="width:100%" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1%'>N°</th>
                                <th width='10%'>Montant</th>
                                <th width='1%' >Date</th>
                                <th width='10%'>Banque</th> 
                                <th width='10%'>Compte</th>
                                <th width='5%'>Type</th>
                                <th >Observations</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $versements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $versement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo $versement->id; ?></td>
                                <td><?php echo $versement->montant; ?></td>
                                <td><?php echo $versement->date; ?></td>
                                <td><?php echo $versement->banque_nom; ?></td>
                                <td><?php echo $versement->compte; ?></td>
                                <td><?php echo $versement->type; ?></td>
                                <td><?php echo $versement->obervations; ?></td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <?php else: ?>
                    <h3>Aucun versements à afficher</h3>
                <?php endif; ?>
            </div>

            <div class="col-md-4" style="padding-top:20px">
                <a href="<?php echo url('versements_imprime/'.$beneficiaire->id); ?>" 
                class="btn btn-info" 
                target="_blank">Imprimer</a>
            </div>

            <div class="col-md-4" style="padding-top:20px">
                <a href="<?php echo url('versements_historique/'.$beneficiaire->id); ?>" 
                id='btn_ajout_enfant' 
                class="box_versement fancybox.iframe btn btn-success" 
                target="_blank">Consulter l'historique des versements</a>
            </div>
        </div>
     </div>

    <!-- ------------------------------------- ONGLET RETRAITE ------------------------------- -->

    <div class="tab-pane" id="retraite">
        <div class="form-group">
            <div class='col-md-3'>
                <?php echo Form::label('ret_numdec', 'Numéro de décision'); ?>

                <?php echo Form::text('ret_numdec', null, ['placeholder' => 'Numéro de décision', 'class' => 'form-control','readonly'=>'true']); ?>

            </div>

            <div class="col-md-3">
                <?php echo Form::label('ret_dateed', 'Date'); ?>

                <div class='input-group date' id='datepicker_ret_dateed'>
                        <?php echo Form::text('ret_dateed', $beneficiaire->date_med, ['placeholder' => 'Date', 'class' => 'form-control','readonly'=>'true']); ?>

                    <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                    <script type="text/javascript">
                        $(function () {
                            $('#datepicker_ret_dateed').datepicker({
                                format: "dd/mm/yyyy",language: "fr",autoclose: true
                            });
                        });
                    </script>
                </div>
            </div>

            <div class='col-md-3'>
                <?php echo Form::label('ret_type', 'Type de retraite'); ?>

                <br/>
                    <?php echo Form::select(
                        'ret_type',
                        ['' => 'A définir' , 'PRE' =>'PRE' , 'PRV' => 'PRV', 'PAV' => 'PAV', 'PRA' => 'PRA', 'AUT' => 'Autre'],
                       $beneficiaire->ret_type,
                        [
                            'class' => 'selectpicker','disabled'=>'true'
                        ]
                    ); ?>                
            </div>
        </div>

        <br/>
        <?php echo Form::label('montants_retraite', 'Montants'); ?>

        <div class="form-group">
            <div class="col-md-4">
                <div class="input-group has-success">
                    <div class="input-group-addon ">Montant retraite</div>
                    <?php echo Form::text('ret_montant', null, ['placeholder' => 'Montant rappel', 'class' => 'text-right form-control','readonly'=>'true']); ?>

                    <div class="input-group-addon">CFP</div>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-4">
                <div class="input-group has-error">
                    <div class="input-group-addon ">Montant rappel</div>
                    <?php echo Form::text('ret_rappel', null, ['placeholder' => 'Montant rappel', 'class' => 'text-right form-control','readonly'=>'true']); ?>

                    <div class="input-group-addon">CFP</div>
                </div>
            </div>
        </div>


        <hr>
        <fieldset>
            <?php echo Form::label('montants_csr', 'Montants CSR'); ?>

            <div class="form-group">
                <div class="col-md-4">
                    <div class="input-group has-success">
                        <div class="input-group-addon ">Montant CSR (Dernier versement)</div>
                        <?php echo Form::text('csr_montant', null, ['placeholder' => 'Montant CSR', 'class' => 'text-right form-control','readonly'=>'true']); ?>

                        <div class="input-group-addon">CFP</div>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="col-md-4">
                    <div class="input-group has-error">
                        <div class="input-group-addon ">Montant rappel CSR</div>
                        <?php echo Form::text('csr_rappel', null, ['placeholder' => 'Montant rappel CSR', 'class' => 'text-right form-control','readonly'=>'true']); ?>

                        <div class="input-group-addon">CFP</div>
                    </div>
                </div>
            </div>
        </fieldset>
    </div>


    <!-- ------------------------------------- ONGLET Editions ------------------------------- -->

    <div class="tab-pane" id="editions">


        <?php if($beneficiaire->sonum<>""): ?>
            <!--
            <div class="col-lg-max col-lg-offset-1">
            <fieldset>
                <legend>Attestation de déclaration<span style="color:grey"></span></legend>
                <div class="form-group">
                    <div class="col-md-8 col-md-offset-1">
                        <?php echo Form::radio('optionsRadios', 'att_revenu', ['id' => 'optionsRadios', 'class' => 'radio']); ?>

                        <?php echo Form::label('att_revenu', 'Attestation de déclaration'); ?>

                    </div>
                </div>
            </fieldset>
            </div>
        -->
        <?php endif; ?>

        <?php if( ($type_liste=="A") || ($type_liste=="S") || ($type_liste=="R")|| ($type_liste=="C")): ?>
            <div class="col-lg-max col-lg-offset-1">
                <?php if( ($type_liste=="A") || ($type_liste=="S") ): ?>
                    <fieldset>
                        <legend>Attestation de Paiements<span style="color:grey"></span></legend>
                        <div class="form-group">
                            <div class="col-md-8 col-md-offset-1">
                                <?php echo Form::radio('optionsRadios', 'att_pmt', ['id' => 'optionsRadios', 'class' => 'radio']); ?>

                                <?php echo Form::label('att_pmt', 'Attestation de paiement'); ?>

                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-8 col-md-offset-1">
                                <?php echo Form::radio('optionsRadios', 'att_last_pmt', ['id' => 'optionsRadios', 'class' => 'radio']); ?>

                                <?php echo Form::label('att_last_pmt', 'Attestation de Dernier paiement'); ?>

                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-8 col-md-offset-1">
                                <?php echo Form::radio('optionsRadios', 'att_no_pmt', ['id' => 'optionsRadios', 'class' => 'radio']); ?>

                                <?php echo Form::label('att_no_pmt', 'Attestation de non paiement'); ?>

                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-8 col-md-offset-1">
                                <?php echo Form::radio('optionsRadios', 'att_cess_pmt', ['id' => 'optionsRadios', 'class' => 'radio']); ?>

                                <?php echo Form::label('att_cess_pmt', 'Attestation de cessation de paiement'); ?>

                            </div>
                        </div>
                    </fieldset>
                <?php endif; ?>



                <?php if( ($type_liste=="R") || ($type_liste=="SAV") || ($type_liste=="SAR")|| ($type_liste=="C")): ?>
                <fieldset>
                    <legend>Retraite</legend>
                    <div class="form-group">
                        <div class="col-md-8 col-md-offset-1">
                            <?php echo Form::radio('optionsRadios', 'att_ret_mens', ['id' => 'optionsRadios', 'class' => 'radio']); ?>

                            <?php echo Form::label('att_ret_mens', 'Attestation de retraite mensuelle'); ?>

                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-4 col-md-offset-1 row">
                            <?php echo Form::radio('optionsRadios', 'att_ret_an', ['id' => 'optionsRadios', 'class' => 'radio']); ?>

                            <?php echo Form::label('att_ret_an', 'Attestation de retraite annuelle'); ?>

                        </div>
                        <div class="col-md-1" style="margin-left:-80px;margin-top:-5px">
                            <?php echo Form::text('ret_ann_annee', date('Y')-1
                                , ['placeholder' => 'Année', 'id'=>'ret_ann_annee'
                                ,'class' => 'form-control','style'=>'padding-left:2px;text-align:center']); ?>

                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-8 col-md-offset-1">
                            <?php echo Form::radio('optionsRadios', 'att_alloc_vieil', ['id' => 'optionsRadios', 'class' => 'radio']); ?>

                            <?php echo Form::label('att_alloc_vieil', "Attestation de paiement de l'allocation vieillesse"); ?>

                        </div>
                    </div>
                </fieldset>
                <?php endif; ?>

   
            
                <div class="form-group">
                    <div class="col-md-8 col-lg-offset-2">
                        <a href="javascript:"  
                            id='edition' 
                            class="btn btn-success pull-left"
                            style="margin-right: 3px;">Imprimer</a>
                    </div>
                </div>

                <script type="text/javascript">
                    $(document).ready(function(){
                        $("#edition").click(function(){
                            var radioValue = $("input[name='optionsRadios']:checked").val();
                            var annee = ($("#ret_ann_annee").val()?$("#ret_ann_annee").val():<?php echo date('Y')-1; ?>);
                            if(radioValue){
                                url="<?php echo url('attestation_edition/'.$beneficiaire->id.'/'.$type_liste); ?>"+"/"+radioValue+"/"+annee;
                                window.open(url,'_blank');
                            }
                            return;
                        });
                    });
                </script>
            </div>
        <?php else: ?>
            <div class="col-md-8 col-lg-offset-1">
                <h2>Aucune édition n'est disponible pour le statut :
                    <small style="font-size:32px"></small>
                </h2>
                <div class="bg-danger alert">
                    Si ce bénéficiaire a un autre statut (Allocataire, Aides Social ...) vous devez accéder à sa fiche via la statut correspondant
                </div>
            </div>
        <?php endif; ?>
    </div>
 </div>    


<?php if($user->can("BEN_MAJ") || $user->HasRole("ADMINISTRATEUR") || ($type_liste!="")): ?>
    <div class="alert col-sm-9" >
        <div class='form-group'>
        <?php if($type_liste!=""): ?>
            <a href="<?php echo url('tiers/beneficiaires/limit/'.$type_liste); ?>" 
                class="btn btn-warning pull-left" style="margin-right: 3px;">
                Retour
            </a>
        <?php endif; ?>

        <?php if(1==0): ?>
            <?php if($user->can("BEN_MAJ") || $user->HasRole("ADMINISTRATEUR")): ?>
                <a href="<?php echo url('tiers/beneficiaires_statut/'.$beneficiaire->id.'/'.$type_liste.'/edit'); ?>" 
                    class="btn btn-info pull-left" style="margin-right: 3px;">
                    Modifier
                </a>
            <?php endif; ?>
        <?php endif; ?>


        </div>
    </div>
<?php endif; ?>

<?php echo Form::close(); ?> 
</div>
<?php $__env->stopSection(); ?>



<?php $__env->startSection('scripts'); ?>
    <?php echo Html::script('js/magicsuggest.js'); ?>

    <?php echo Html::script('js/jquery.fancybox.js'); ?>

    
    <!-- <?php echo Html::script('js/jquery.dataTables.editable.js'); ?>


    <!-- Datatable  -->
    <?php echo Html::script('js/jquery.dataTables.js'); ?>

    <?php echo Html::script('js/dataTables.bootstrap.js'); ?>



    <!-- Datatable Button --> 
    <?php echo Html::script('js/dataTables.buttons.js'); ?>

    <?php echo Html::script('js/buttons.bootstrap.js'); ?>

    <?php echo Html::script('js/buttons.html5.js'); ?>

    <?php echo Html::script('js/buttons.print.js'); ?>

    <?php echo Html::script('js/jszip.min.js'); ?>

    <?php echo Html::script('js/pdfmake.min.js'); ?>

    <?php echo Html::script('js/vfs_fonts.js'); ?>

    <?php echo Html::script('js/buttons.colVis.min.js'); ?>


    <?php echo Html::script('js/moment.min.js'); ?>

    <?php echo Html::script('js/datetime-moment.js'); ?>



    <script type="text/javascript">
        $(document).ready(function() {
             $('#_table tbody').on( 'click', 'tr', function () {
                $(this).toggleClass('selected');
            } );

            function fnGetSelected( oTableLocal )
            {
                var aReturn = new Array();
                var rowLength = oTableLocal.rows('.selected').data().length;
                //loops through rows    
                for (i = 0; i < rowLength; i++){
                   //gets cells of current row
                   var cellVal = oTableLocal.rows('.selected').data()[i][0];
                   aReturn.push(cellVal);
                }
                return aReturn;
            }

            $(".box_versement").fancybox({
                fitToView   : true,
                width       : '85%',
                height      : '70%',
                closeClick  : true,
                openEffect  : 'fade',
                closeEffect : 'fade',
            });
            
            $(".various").fancybox({
                maxWidth    : 800,
                maxHeight   : 600,
                fitToView   : false,
                width       : '70%',
                height      : '70%',
                autoSize    : false,
                autoScale   : false,
                closeClick  : false,
                openEffect  : 'none',
                closeEffect : 'none'
            });
        });
    </script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts_end'); ?>
<script>
  $.fn.dataTable.moment('D/M/YYYY');

  var table =$('#_table_longue').dataTable( {
      bAutoWidth: false,bPaginate: false,bInfo: false,
      bFilter: false,deferRender:    true,
      scrollCollapse: false,scroller:false,iDisplayLength:10,
      oLanguage: {
          "sZeroRecords": "Aucune ligne",
          "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
          "sInfoEmpty": "Showing 0 to 0 of 0 records",
          "sInfoFiltered": "(sur un total de _MAX_ lignes)",
          "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
              ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
              "sSearch":"Chercher ",
          buttons: {
              colvis: 'Colonnes',
              copy: 'Copier',print: 'Imprimer',
              copyTitle: 'Ajouté au presse-papiers',
              copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
              copySuccess: {
                  _: '%d lignes copiées',
                  1: '1 ligne copiée'
                  }
              }
          },
           dom: "<'row'<'col-sm-4 text-left'f><'col-sm-4'><'col-sm-6 text-right'>B>" +
          "<'row'<'col-sm-12'tr>>" +"<'row'<'col-sm-5'i><'col-sm-7'p>>",
          buttons: [ 
              {extend: 'copy',exportOptions: {columns: ':visible'} },
              {extend: 'excel',exportOptions: {columns: ':visible'} },
              {extend: 'print',exportOptions: {columns: ':visible'} },
              'colvis'
          ],

          "order": [[ 2, "desc" ]],
      } );



    //enfants
    var table =$('#_table').dataTable( {
      bAutoWidth: false,bPaginate: false,bInfo: false,
      bFilter: false,deferRender:    false,
      scrollCollapse: false,scroller:false,iDisplayLength:10,
      dom: "<'row'<'col-sm-4 text-left'><'col-sm-4'><'col-sm-6 text-right'>>" +
          "<'row'<'col-sm-12't>>" +"<'row'<'col-sm-5'i><'col-sm-7'>>",
          buttons: [ 
              {extend: 'copy',exportOptions: {columns: ':visible'} },
              {extend: 'excel',exportOptions: {columns: ':visible'} },
              {extend: 'print',exportOptions: {columns: ':visible'} },
              'colvis'
          ],
      } );
    

        //Versements
    var table =$('#_table_vers').dataTable( {
      bAutoWidth: false,bPaginate: false,bInfo: false,
      bFilter: false,deferRender:    false,
      scrollCollapse: false,scroller:false,iDisplayLength:10,
      dom: "<'row'<'col-sm-4 text-left'><'col-sm-4'><'col-sm-6 text-right'>>" +
          "<'row'<'col-sm-12't>>" +"<'row'<'col-sm-5'i><'col-sm-7'>>",
          buttons: [ 
              {extend: 'copy',exportOptions: {columns: ':visible'} },
              {extend: 'excel',exportOptions: {columns: ':visible'} },
              {extend: 'print',exportOptions: {columns: ':visible'} },
              'colvis'
          ],
      } );
</script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp7422\htdocs\sysinfo\cpswf\sipre9\resources\views/tiers/beneficiaires/show.blade.php ENDPATH**/ ?>