

<?php $__env->startSection('title'); ?> Plan comptable général <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Plan comptable général <?php $__env->stopSection(); ?>
<?php $__env->startSection('subtitle_card',"Liste complète"); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
        <?php if(Session::has('message')): ?>
            <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
        <?php endif; ?>
        </div>

        <div class="card-body">
            <table id="_table" width="100%" class="table table-bordered">
                <thead>
                    <tr>
                        <th width='1%'>CompteTri</th>
                        <th width='1%'>Compte</th>
                        <th>Designation</th>
                        <th width='1%'>Prévisionnel</th>
                        <th width='1%'>Categorie</th>
                        <?php if($user->hasRole("ADMINISTRATEUR") || $user->can("PLA_AJO")): ?>
                        <th width='1px'>
                            <a href="<?php echo url('plan_comptable/create'); ?>" class="btn  btn-sm btn-success">
                                <span class='fas fa-plus'></span></a> 
                        </th>
                        <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $plancomptables; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plancomptable): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="<?php echo ($plancomptable->titre==1)?'p_titre':''; ?>">
                        <td nowrap><?php echo str_pad($plancomptable->compte,7,'0',STR_PAD_RIGHT); ?></td>
                        <td nowrap >
                            <a href="<?php echo url('plan_comptable/'.$plancomptable->id); ?>" >
                                <?php echo $plancomptable->compte; ?>

                            </a>
                        </td>
                        <td><?php echo $plancomptable->libelle; ?></td>
                        <td nowrap align="right" style='font-style:italic'><?php echo $plancomptable->previsionnel; ?></td>
                        <td nowrap><?php echo $plancomptable->categ_bilan; ?></td>
                        <td nowrap>
                            <?php if($user->hasRole("ADMINISTRATEUR") || $user->can("PLA_SUP")): ?>
                            <?php echo Form::open(['url' => url('plan_comptable/' . $plancomptable->id), 'method' => 'DELETE']); ?>                            
                            <?php echo e(csrf_field()); ?>

                            
                                <button class="btn btn-danger btn-sm"><span class='fas fa-trash'></span></button>
                            <?php endif; ?>
                        </td>
                        <?php echo Form::close(); ?>

                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script>
  $(function () {
    $("#_table").DataTable({
      "paging": false,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": false,
      "responsive": true, 
      "autoWidth": true,
      iDisplayLength:20,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }
        },
        dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",

        "buttons": ["copy", "excel", "colvis"], //"print", "pdf", "csv", 
        "aaSorting": [
            [0,'asc']
        ],
        "columnDefs": [
            { "targets": [ 4], "orderable": false,"searchable": false},
            { "targets": [ 0], "visible": false},
            { "targets": [ 1-4], "orderable": false},
        ]
    })
    .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre_new\resources\views/comptabilite/plan_comptable/index.blade.php ENDPATH**/ ?>