
<?php $__env->startSection('title'); ?> Cotisations <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',""); ?>
<?php $__env->startSection('subtitle_card',""); ?>


<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="col-lg-max col-lg-offset-1 container-fluid">
            <div class="card-header bg-info">
                Employeurs Actifs<small> - Envoi des appels de cotisations</small>
            </div>
            <div class="card-body">
                <table id="_table" style="background-color:white"  
                    class="table table-condensed table-striped table-hover table-bordered">
                    <thead>
                        <tr>
                            <th >N°</th>
                            <th>Nom</th>
                            <th >NbSal</th>
                            <th >Email</th>
                            <th >ile</th>
                            <th width='30%'>Responsable</th>
                            <th >DernierEmail</th>
                            <th >PJ</th>
                            <th width='5%'>Statut</th>
                            <th ></th>
                        </tr>
                    </thead>
         
                    <tbody>
                        <?php $__currentLoopData = $employeurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employeur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $date=$employeur->getSendEmailLastDate("REC_BRD_RELEVE");
                            $nom_fichier=$employeur->getSendEmailLastPJ("REC_BRD_RELEVE");
                            $pj="";
                            if($nom_fichier!="") $pj=url("/upload/recouvrement/bordereau/".$nom_fichier);
                        ?>
                        <tr>
                            <td><?php echo str_pad($employeur->id,4,'0',STR_PAD_LEFT); ?></td>
                            <td><?php echo $employeur->NomReduit; ?></td>
                            <td align="center"> <?php echo $employeur->Nbemployes; ?></td>
                            <td><?php echo $employeur->email; ?></td>
                            <td align="center"><?php echo $employeur->ile; ?></td>
                            <td><?php echo (strlen($employeur->responsable)>20)?substr($employeur->responsable,0,20):$employeur->responsable; ?></td>
                            <td><?php echo $date; ?></td>
                            <td nowrap><a href="<?php echo $pj; ?>" target="_blank"><?php echo ($pj=="")?'':'<i class="fas fa-file"></i>.pdf'; ?></a></td>
                            <td align="center"><?php echo $employeur->statut; ?></td>
                            <td nowrap>
                                <span>
                                    <?php if($user->can("COT_EMAIL") || $user->HasRole("ADMINISTRATEUR")): ?>
                                        <?php if(trim($employeur->email)!=""): ?>
                                       <a href="<?php echo url('recouvrement_sendmail').'/'.$employeur->id; ?>" 
                                                class="box_email fancybox.iframe btn btn-info" 
                                                style="margin-right: 3px;">Email</a> 
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    <a href="javascript:"  
                                    onclick="$('#employeur_id').val(<?php echo $employeur->id; ?>);$('#dialog-percotis').dialog( 'open' );return false;" 
                                    class="box_versement fancybox.iframe btn btn-warning pull-left" 
                                    target="_blank">Bordereau</a>
                                </span>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <div id="dialog-percotis" title="Période">
        <?php echo html()->label( 'Veuillez saisir la période de cotisation','per_cotis'); ?>

        <?php echo html()->select('annee_cotis',$exercices,date('Y')-1)
            ->placeholder('A définir')
            ->attributes(['id' => 'annee_cotis','class' => 'form-control selectpicker','data-width' => "100%",'style' => 'font-weight:bold;background:whitesmoke']); ?>

        <br/>
        <?php echo html()->select('tri_cotis',["T1"=>"1er trimestre","T2"=>"2e trimestre","T3"=>"3e trimestre","T4"=>"4e trimestre"],"")
            ->placeholder('Choisissez un trimestre')
            ->attributes(['id' => 'tri_cotis','class' => 'form-control selectpicker','data-width' => "100%"]); ?>

        <br/>
        <?php echo html()->text('per_cotis',null)->placeholder('Libellé de la période')->attributes(['class' => 'form-control','id'=>'per_cotis']); ?>

    </div>

    <div id="dialog-email" title="Email">
        <?php echo html()->hidden('employeur_id', '')->attributes(['id' => 'employeur_id']); ?>

        <?php echo html()->text('email',$employeur->email)->placeholder('email')->attributes(['class' => 'form-control','id'=>'email']); ?>


            <br/>
        <?php echo html()->label( "Veuillez saisir l'objet et le texte :",'email_sujet'); ?>

        <?php echo html()->text('email_objet',null)->placeholder('Objet')->attributes(['class' => 'form-control','id'=>'email_objet']); ?>


        <?php echo html()->textarea('email_texte',null)->placeholder('Texte')->attributes(['class' => 'form-control','id'=>'email_texte','row'=>'4']); ?>

    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox.css')); ?>">
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox-buttons.css')); ?>">

    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery-ui.structure.min.css')); ?>">
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery-ui.theme.min.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts0'); ?>
    <script src="<?php echo e(url('js/jquery.fancybox.js')); ?>"></script>
    <script src="<?php echo e(url('js/magicsuggest.js')); ?>"></script>

    <script>
        $(".box_email").fancybox({
            fitToView   : false,
            width       : '85%',
            height      : '70%',
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
        });


        $( "#dialog-percotis" ).dialog({
            closeOnEscape: false,
            open: function(event, ui) { $(".ui-dialog-titlebar-close").hide(); },
            resizable: false,
            height: "auto",
            width: 400,
            modal: true,
            autoOpen: false,
            buttons: {
            "OK": function() {
                var tri_cotis=$('#tri_cotis').val();
                var per_cotis=$('#per_cotis').val();
                var annee_cotis=$('#annee_cotis').val();
                var employeur_id=$('#employeur_id').val();
                if(tri_cotis=="") {alert("Vous devez choisir un trimestre");return;}
                if(annee_cotis=="") return;
                var url='<?php echo url('cotisations_bordereau_cotisation'); ?>'+"/"+employeur_id; 
                url+="/"+annee_cotis;
                url+="/"+tri_cotis; 
                if(per_cotis!="") url+="/"+per_cotis.replace(/\//g,"_"); 
                window.open(url,'_blank');
                $( this ).dialog( "close" );
            },
            Annuler: function() {
              $( this ).dialog( "close" );
            }
            }
        });


      $( "#dialog-email" ).dialog({
        closeOnEscape: false,
        open: function(event, ui) { $(".ui-dialog-titlebar-close").hide(); },
        resizable: false,
        height: 400,
        width: 600,
        modal: true,
        autoOpen: false,
        buttons: {
        "Envoyer": function() {
            var email=$('#email').val();
            var email_objet=$('#email_objet').val();
            var email_texte=$('#email_texte').val();
            if(email_objet=="") return;
            if(email_texte=="") return;
            var param=email_objet+"@@"+email_texte;
            var url="<?php echo url('recouvrement_sendmail/'); ?>"+"/"+email+"/"+email_objet+"/"+email_texte; 
            window.open(url,'_blank');
            $( this ).dialog( "close" );
        },
        Annuler: function() {
          $( this ).dialog( "close" );
        }
        }
    });

</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            var table =$('#_table').DataTable( {
                bAutoWidth: false,
                bPaginate: true,
                bInfo: true,
                bFilter: true,
                //scrollY:        400,
                //scrollX:        false,
                //scrollCollapse: true,
                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "decimal": ",",
                    "thousands": " ",
                    "sSearch":"Chercher",

                    buttons: {
                        colvis: 'Colonnes à afficher',
                        copy: 'Copier',
                        print: 'Imprimer',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                        }
                    }

                    },
                    "aaSorting": [
                        [0,'desc']
                    ],

                    "aoColumnDefs": [
                        { "sTypes": "numeric", "aTargets": [ 3,4 ] },
                        { bSortable: false, aTargets: [] },
                        { visible: false, targets: [] },
                    ],

                    dom: "<'row'<'col-sm-2 text-left'f><'col-sm-4'><'col-sm-6 text-right'B>>" +
                    "<'row'<'col-sm-12'tr>>" +
                    "<'row'<'col-sm-5'i><'col-sm-7'p>>",

                    buttons: [ 
                        {extend: 'copy',exportOptions: {columns: ':visible'} },
                        {extend: 'excel',exportOptions: {columns: ':visible'} },
                        {extend: 'print',exportOptions: {columns: ':visible'} },
                        'colvis'
                    ],

                } );
        } );

    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/recouvrement/suivi/index_rappel.blade.php ENDPATH**/ ?>