
<?php $__env->startSection('title'); ?> Créancier <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-success"><?php echo e(Session::get('message')); ?></div>
        <script>
            parent.location.reload();
            parent.jQuery.fancybox.close();
        </script>
    <?php else: ?>
        <?php if($errors): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class='bg-danger alert'><?php echo $error; ?></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        <div class="card card-info">
            <div class="card-header">
                <h2>Nouveau Creancier</small></h2>
            </div>
            <div class='card-body'>
                <?php echo e(html()->form('POST', url('creanciers'))->open()); ?>

                    <input type="hidden" name="mode_frame" id="mode_frame" value="<?php echo $frame; ?>">
                    <input type="hidden" name="num_creancier" id="num_creancier" value="<?php echo $frame; ?>">

                    <div class="form-group row " >
                        <div class="col-md-6" style="padding-left:0px">
                            <?php echo html()->label('Origine','origine'); ?>

                            <?php echo html()->select('origine',['BEN'=>'Bénéficiaires','EMP' => 'Employeurs','CRE' => 'Créanciers','AUT' => 'Autre'],null)
                                    ->placeholder('A définir')
                                    ->attributes(['class' => 'form-control','id'=>'origine']); ?> 
                        </div>

                        <div class="col-md-6 form_detail">
                            <div id='creancier_beneficiaire'>
                                <?php echo html()->label('Créancier&nbsp;(bénéficiaire)','creancier_benef'); ?>

                                <?php echo html()->text('creancier_benef', null)->placeholder("Numéro de créancier")
                                    ->attributes(['id'=>'creancier_benef','class' => 'form-control']); ?>

                            </div>
                            <div id='creancier_employeur'>
                                <?php echo html()->label('Créancier&nbsp;(Employeur)','creancier_emp'); ?>

                                <?php echo html()->text('creancier_emp', null)->placeholder("Numéro de créancier")
                                    ->attributes(['id'=>'creancier_emp','class' => 'form-control']); ?>

                            </div>
                            <div id='creancier_creancier'>
                                <?php echo html()->label('Créancier&nbsp;(Creancier)','creancier_cre'); ?>

                                <?php echo html()->text('creancier_cre', null)->placeholder("Numéro de créancier")
                                    ->attributes(['id'=>'creancier_cre','class' => 'form-control']); ?>

                            </div>
                        </div>
                    </div>
                           
                    <div class="form_detail">
                        <?php echo $__env->make("tiers.creanciers.content", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>   
                <?php echo e(html()->form()->close()); ?>

            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts0'); ?>
    <script type="text/javascript">
        $(function() {
            $('.form_detail').hide();
            
            set_origine();

            function set_origine() {
                
                var origine_value=$("#origine option:selected").val();
                if(origine_value!='AUT')  $('.identifiants').attr('readonly','true');
                $('.form_detail').show();
                $('#creancier_beneficiaire').hide();
                $('#creancier_employeur').hide();
                $('#creancier_creancier').hide();
                if(origine_value=='BEN') $('#creancier_beneficiaire').show();
                if(origine_value=='EMP') $('#creancier_employeur').show();  
                if(origine_value=='CRE') $('#creancier_creancier').show();
                if(origine_value=='AUT') {
                    $('.identifiants').removeAttr('readonly');}

                if(origine_value=='') {
                    $('.form_detail').hide();
                    $('.identifiants').attr('readonly','true');
                }
            }

            $("#origine").change(function() {
                $('#num_creancier').val('');
                $('#nom').val('');
                $('#prenom').val('');
                $('#datenaiss').val('');
                $('#compte').val('');
                $('#bqcle_creancier').val('');
                set_origine();
            });


            $("#creancier_emp").autocomplete({
                source: "<?php echo url('auto_creancier_employeur'); ?>",
                minLength: 2,
                select: function(event, ui) {
                    $('#num_creancier').val(ui.item.employeur_id);
                    $('#nom').val(ui.item.employeur_nom);
                    $('#prenom').val('');
                    $('#datenaiss').val('');
                    $('#compte').val(ui.item.compte);
                    $('#bqcle_creancier').val(ui.item.banque_id);
                    $('.selectpicker').selectpicker('refresh');
                },
                close: function(event, ui) {
                    
                }
            });  


            $("#creancier_benef").autocomplete({
                source: "<?php echo url('auto_creancier_beneficiaire'); ?>",
                minLength: 2,
                select: function(event, ui) {
                    $('#num_creancier').val(ui.item.beneficiaire_id);
                    $('#nom').val(ui.item.beneficiaire_nom);
                    $('#prenom').val(ui.item.prenom);
                    var datenaiss=ui.item.datenaiss;
                    $('#compte').val(ui.item.compte);
                    $('select[id="bqcle_creancier"]').val(ui.item.banque_id);
                    $('.selectpicker').selectpicker('refresh');
                    //MEF de la date de naissance
                    var annee=datenaiss.substr(0,4);
                    var mois=datenaiss.substr(5,2);
                    var jour=datenaiss.substr(8,2);
                    $('#datenaiss').val(jour+"/"+mois+"/"+annee);

                },
                close: function(event, ui) {
                    
                }
            });    

            $("#creancier_cre").autocomplete({
                source: "<?php echo url('auto_creancier_creancier'); ?>",
                minLength: 2,
                select: function(event, ui) {
                    $('#num_creancier').val(ui.item.creancier_id);
                    $('#nom').val(ui.item.creancier_nom);
                    $('#prenom').val(ui.item.prenom);
                    var datenaiss=ui.item.datenaiss;
                    if(datenaiss.length>=10) {
                        //MEF de la date de naissance
                        var annee=datenaiss.substr(0,4);
                        var mois=datenaiss.substr(5,2);
                        var jour=datenaiss.substr(8,2);
                    }
                    $('#datenaiss').val(jour+"/"+mois+"/"+annee);
                    $('#compte').val(ui.item.compte);
                    $('#bqcle_creancier').val(ui.item.banque_id);
                    $('.selectpicker').selectpicker('refresh');
                },
                close: function(event, ui) {
                    
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash'.($frame?'_pop':''), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/tiers/creanciers/create.blade.php ENDPATH**/ ?>