
<?php $__env->startSection('title'); ?> Utilisateurs <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',"Utilisateur"); ?>
<?php $__env->startSection('subtitle_card',"Liste complète"); ?>
<?php $__env->startSection('content'); ?>

    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>
    <div class="card">
        <div class="card-body">
            <table id="_table" width="100%" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th >Nom</th>
                        <th width='10%'>Identifiant</th>
                        <th width='10%'>Rôles</th>
                        <th width='10%'>Dernière connexion</th>
                        <th width='1px'>
                            <?php if($user->hasRole("ADMINISTRATEUR")|| $user->can("ajouter utilisateurs")): ?>
                            <a href="<?php echo url('users/create'); ?>" class="btn btn-success">
                                <span class='ti-plus'></span></a> 
                            <?php endif; ?>
                        </th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $users_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user_row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <a href="<?php echo url('users/'.$user_row->id); ?>" ><?php echo $user_row->name; ?></a></td>
                        <td nowrap><?php echo $user_row->email; ?></td>
                        <td nowrap><?php echo $user_row->getRoles(); ?></td>
                        <td nowrap><?php echo $user_row->last_connection; ?></td>
                        <td nowrap>
                            <?php if($user->hasRole("ADMINISTRATEUR")|| $user->can("supprimer utilisateurs")): ?>
                                <?php echo Form::open(['url' => url('users/' . $user_row->id), 'method' => 'DELETE']); ?>

                                <?php echo e(csrf_field()); ?>

                             <?php endif; ?>

                            <a href="<?php echo url('users/'.$user_row->id); ?>" class="btn btn-warning btn-sm pull-left" style="margin-right: 3px;">
                                <i title="consulter" class="fas fa-eye"></i>
                            </a>
                            <?php if($user->hasRole("ADMINISTRATEUR") || $user->can("modifier utilisateurs")): ?>
                            <a href="./users/<?php echo $user_row->id; ?>/edit" class="btn btn-info pull-left" style="margin-right: 3px;">
                                <span class='ti-pencil-alt'></span>
                            </a>
                            <?php endif; ?>

                            <?php if($user->hasRole("ADMINISTRATEUR")|| $user->can("supprimer utilisateurs")): ?>
                                <button class="btn btn-danger">
                                    <span class='ti-trash'></span>
                                </button>
                                <?php echo Form::close(); ?>

                             <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>

            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp7422\htdocs\sysinfo\cpswf\sipre_dashboard\resources\views/acces/users/index.blade.php ENDPATH**/ ?>