
<?php $__env->startSection('title'); ?> Consultation <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> <?php $__env->stopSection(); ?>
<?php $__env->startSection('subtitle_card',""); ?>

<?php $__env->startSection('content'); ?>
    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    
     <div class="card card-primary">
        <div class="card-header">
            Cotisation N°<?php echo $cotisation->id; ?>

        </div>
        <div class="card-body">
            <?php echo e(html()->modelForm($cotisation, 'PUT', url('cotisations/' . $cotisation->id))->open()); ?>

                <?php echo e(html()->hidden( 'sonum',$cotisation->sonum)); ?>

                <?php echo $__env->make('recouvrement.cotisations.content', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo e(html()->closeModelForm()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts0'); ?>
    <script>
        $("#mois").change(function() { set_Taux(); });
        $("#assiette").change(function() { set_Taux(); });
        $("#box_clr").change(function() { set_Taux(); });
        $("#box_ccpf").change(function() { set_Taux(); });


        //Positionne les taux en fonction de l'année
        function set_Taux() {
            var taux_CLR = <?php echo json_encode($taux_CLR) ?>;
            var taux_CPF = <?php echo json_encode($taux_CPF) ?>;
            var statut = <?php echo json_encode($employeur->statut) ?>;
            
            var exercice=$("#mois").val();
            if(exercice.length<10) return;
            var year=parseInt(exercice.substr(6,4));

            $("#PrcCLR").val("");
            $("#PrcCCPF").val("");
            $("#PrcTot").val("");

            if(taux_CLR[year]) $("#PrcCLR").val(taux_CLR[year]);
            if(statut=="ASV") {
                $("#PrcCCPF").val("Non concerné");
            } else {
                if(taux_CPF[year]) $("#PrcCCPF").val(taux_CPF[year]);
            }

            var t1=parseFloat($("#PrcCLR").val());
            var t2=0;
            if(statut!="ASV") {
                t2=parseFloat($("#PrcCCPF").val());
            }

            if($("#box_clr").is(':checked')) {t1=0;$("#PrcCLR").val(0);}
            if($("#box_ccpf").is(':checked')) {t2=0;$("#PrcCCPF").val(0);}

            $("#PrcTot").val(t1+t2);
            $("#PrcTot").val(t1+t2);

            taux_CLR[year];

            calcul();
            return;
        }

        //Calcul le total
        function calcul() {
            var t_CLR=($("#PrcCLR").val());
            var t_CCPF=($("#PrcCCPF").val());
            var statut = <?php echo json_encode($employeur->statut) ?>;

            var assiette = $("#assiette").val();
            if(assiette=="")  $("#assiette").val(0);

            var CLR = t_CLR*assiette/100;
            var CCPF = 0;
            var total=0;
            if(statut!="ASV") CCPF = t_CCPF*assiette/100;

            $("#CLR").val(parseInt(CLR));
            if(statut!="ASV") {
                $("#CCPF").val(parseInt(CCPF));
                total=parseInt(CLR+CCPF);
            } else {
                $("#CCPF").val("Non concerné");
                total=parseInt(CLR);
            }



            $("#total").val(total);

            $("#PrcCLR").val($("#PrcCLR").val()+"%");
            if(statut!="ASV") $("#PrcCCPF").val($("#PrcCCPF").val()+"%");
            else $("#PrcCCPF").val("");
            $("#PrcTot").val($("#PrcTot").val()+"%");
        }

        if($("#CLR").val()==0) {$("#box_clr").prop( "checked", true );$("#PrcCLR").val(0);}
        if($("#CCPF").val()==0) {$("#box_ccpf").prop( "checked", true );$("#PrcCCPF").val(0);}
        set_Taux();
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/recouvrement/cotisations/edit.blade.php ENDPATH**/ ?>