

<?php $__env->startSection('title'); ?> RAN <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Report à Nouveau <?php $__env->stopSection(); ?>
<?php $__env->startSection('subtitle_card',"Liste complète"); ?>
<?php $__env->startSection('content'); ?>


    <div class="card">
        <?php if(Session::has('message')): ?>
            <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-warning"><?php echo e($errors->first()); ?></div>
        <?php endif; ?>
              <div class="row">
                <!-- /.col (LEFT) -->
                <div class="col-md-12">
                  <div class="card card-default">
                    <div class="card-header">
                        <h3 class="card-title">Génération des reports à nouveau : 
                        </h3>
                    </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="form-group col-md-2">
                                    <?php echo html()->label('Exercice','exercice'); ?>&nbsp;
                                    <?php echo html()->select('exercice',$exercices,$exercice)->attributes(['id' => 'exercice','class' => 'form-control ']); ?>

                                </div>
                                <div class='form-group col-md-5'  style="margin-left:5px">
                                    <?php echo html()->label('Comptes Aux. (Tous par défaut)','sel_compte_aux'); ?>&nbsp;
                                    <?php echo html()->select('sel_compte_aux')->options([])
                                        ->attributes(['id'=>'sel_compte_aux','class' => 'select2 form-control','style' => 'padding:2px']); ?>

                                </div>
                                <div class="col-md-6">
                                    <a href="#" id="btn_generate" class="btn btn-info">Générer les lignes RAN</a>
                                    <a href="#" id="btn_destroy" class="btn btn-danger">Supprimer les lignes RAN</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable_btn_nopage", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script type="text/javascript">
        $(function () {
                var data_comptes_aux=<?php echo $comptes_aux_json; ?>;
                var compte_aux="<?php echo $compte_aux; ?>";
                

                $(document).on('select2:open', '.select2', function (e) {
                    setTimeout(() => {
                        const $elem = $(this).attr("id");
                        document.querySelector(`[aria-controls="select2-${$elem}-results"]`).focus();
                    });
                });

                $('#sel_compte_aux').select2({
                    width:'80%',
                    data: data_comptes_aux,
                    placeholder:"Compte auxiliaire"
                });

                $('#btn_generate').click( function() {
                    generate();
                });

                $('#btn_destroy').click( function() {
                    destroy();
                });

                function generate() {
                    var select_exercice = [...document.getElementById('exercice').selectedOptions].map(option => option.value);
                    if(select_exercice=="") select_exercice=0;
                    select_compte_aux = $('#sel_compte_aux').val();
                    if((select_compte_aux=="")||(select_compte_aux==null)) select_compte_aux=0; 
                    var url="<?php echo url('ran_generate/'); ?>/"+select_exercice+"/"+select_compte_aux ; 
                    location.href=url;
                }
                function destroy() {
                    var select_exercice = [...document.getElementById('exercice').selectedOptions].map(option => option.value);
                    if(select_exercice=="") select_exercice=0;
                    select_compte_aux = $('#sel_compte_aux').val();
                    if((select_compte_aux=="")||(select_compte_aux==null)) select_compte_aux=0; 
                    if(confirm("Voulez-vous vraiment supprimer le report à nouveau "+select_exercice)) {
                        var url="<?php echo url('ran_destroy/'); ?>/"+select_exercice+"/"+select_compte_aux ; 
                        location.href=url;
                    }
                    return;
                }
                if(compte_aux!='') {$('#sel_compte_aux').val('<?php echo e($compte_aux); ?>'); $('#sel_compte_aux').trigger('change');} 
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/comptabilite/ran/index_ran.blade.php ENDPATH**/ ?>