
<?php $__env->startSection('title'); ?> Ecriture <?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="card card-info">
        <div class="card-header">
            <h2>Nouvelle écriture</h2>
        </div>
        <div class='card-body'>
            <?php echo e(html()->form('POST', url('/compta_old/journal'))->open()); ?>

                <div class='row form-group'>
                    <div class="col-md-2">
                        <?php echo html()->label('Date','date'); ?>

                        <div class='input-group date' id='datepicker_date'>
                            <?php echo html()->text('date', date('d/m/Y'))->attributes(['class' => 'form-control']); ?>

                            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                        </div>
                    </div>
                </div>
                <div class="row  form-group">
                    <div class="col-md-6">
                        <?php echo html()->label('Numéro de compte','numcpt' ); ?>

                        <?php echo html()->hidden('numcpt', null)->attributes(['id' => 'numcpt']); ?>

                        <?php echo html()->hidden('nomcpt', null)->attributes(['id' => 'nomcpt']); ?>

                        <div class="input-group">
                            <span class="input-group-addon"  id='compte_addon'><?php echo old('numcpt'); ?></span>
                            <input type="text" class="form-control" name="nom_compte" id="nom_compte" value="<?php echo old('nomcpt'); ?>" placeholder="Numéro" />
                        </div>
                    </div>
                    <div class="col-md-3">
                        <?php echo html()->label('Budget', 'budjet'); ?>

                        <div class="input-group has-warning">
                            <?php echo html()->text('budget', null)->attributes(['id'=>'budget','class' => 'text-right form-control','readonly']); ?>

                        </div>
                    </div>
                </div>
                <div class="row form-group">
                    <div class="col-md-2">
                        <?php echo html()->label('Référence', 'ref'); ?>

                        <?php echo html()->text('ref', null)->attributes(['placeholder' => 'Référence', 'class' => 'form-control']); ?>

                    </div>

                    <div class='col-md-7'>
                        <?php echo html()->label( 'Libellé','libelle'); ?>

                        <?php echo html()->text('libelle', null)->attributes(['placeholder' => 'Libellé', 'class' => 'form-control']); ?>

                    </div>
                </div>
                <div class="row form-group">
                    <div class="col-md-4 callout callout-danger">
                        <div class="input-group has-error">
                            <div class="input-group-addon" style="width:100px">Débit</div>
                            <?php echo html()->text('debit', null)->attributes(['placeholder' => 'Débit', 'class' => 'text-right form-control']); ?>

                        </div>
                    </div>
                </div>
                <div class="row form-group">
                    <div class="col-md-4 callout callout-success">
                        <div class="input-group has-success">
                            <div class="input-group-addon" style="width:100px">Crédit</div>
                            <?php echo html()->text('credit', null)->attributes(['placeholder' => 'Crédit', 'class' => 'text-right form-control']); ?>

                        </div>
                    </div>
                </div>
                <div class="row form-group callout callout-warning">
                    <legend>Compensation (facultatif)</legend>
                    <div class="col-md-6">
                        <?php echo html()->label('Numéro de compte (compensation)', 'numcpt2'); ?>

                        <?php echo html()->hidden('numcpt2', null)->attributes(['id' => 'numcpt2']); ?>

                        <?php echo html()->hidden('nomcpt2', null)->attributes(['id' => 'nomcpt2']); ?>

                        <div class="input-group">
                            <span class="input-group-addon"  id='compte2_addon'><?php echo old('numcpt2'); ?></span>
                            <input type="text" class="form-control" name="nom_compte2" id="nom_compte2" 
                                value="<?php echo old('nomcpt2'); ?>" placeholder="Numéro" />
                        </div>
                    </div>
                    <div class="col-md-3">
                        <?php echo html()->label( 'Budget (compensation)','budget2'); ?>

                        <div class="input-group has-warning">
                            <?php echo html()->text('budget2', null)->attributes(['id'=>'budget2','class' => 'text-right form-control','readonly']); ?>

                        </div>
                    </div>
                </div>
                <div class="row form-group">
                    <div class=''>
                        <?php echo html()->submit('Enregistrer')->attributes(['class' => 'btn btn-primary']); ?>

                    </div>
                </div>
            <?php echo e(html()->form()->close()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>


        
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $(function () {
            $('#datepicker_date').datepicker({
                format: "dd/mm/yyyy",
                language: "fr",
                autoclose: true
            });

            $("#nom_compte").autocomplete({
                source: "<?php echo url('auto_compte_compta'); ?>",
                minLength: 2,
                select: function(event, ui) {
                    $('#numcpt').val(ui.item.id);
                    var nom=ui.item.value;
                    var num=ui.item.id;
                    nom=nom.substr(nom,7);
                    $('#nom_compte').html(nom);
                    $('#nomcpt').val(nom);
                    $('#compte_addon').html(ui.item.id);
                    $('#budget').val(ui.item.budget);
                },
                change: function( event, ui ) {
                    var id_nom=ui.item.value.trim();
                    var nom;
                    if(id_nom.length>7) nom=(id_nom.substring(6)).trim();
                    $('#nom_compte').val(nom);
                    $('#nomcpt').val(nom);
                    $('#compte_addon').html(ui.item.id);
                    $('#numcpt').val(ui.item.id);
                }
            }); 

            $("#nom_compte2").autocomplete({
                source: "<?php echo url('auto_compte_compta'); ?>",
                minLength: 2,
                select: function(event, ui) {
                    $('#numcpt2').val(ui.item.id);
                    var nom=ui.item.value;
                    var num=ui.item.id;
                    nom=nom.substr(nom,7);
                    $('#nom_compte2').html(nom);
                    $('#nomcpt2').val(nom);
                    $('#compte2_addon').html(ui.item.id);
                    $('#budget2').val(ui.item.budget);
                },
                change: function( event, ui ) {
                    var id_nom=ui.item.value.trim();
                    var nom;
                    if(id_nom.length>7) nom=(id_nom.substring(6)).trim();
                    $('#nom_compte2').val(nom);
                    $('#nomcpt2').val(nom);
                    $('#compte2_addon').html(ui.item.id);
                    $('#numcpt2').val(ui.item.id);
                }
            });    
        });
    </script>
<?php $__env->stopSection(); ?>


    

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/compta_old/journal/create.blade.php ENDPATH**/ ?>