<?php $__env->startSection('title'); ?> Bénéficiaire <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Consultation d'une fiche Bénéficiaire <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card card-success">
        <div class="card-header">
            <h2>Bénéficiaire <span style='color:darkblue'><?php echo $beneficiaire->nomcomplet; ?></span></h2>
        </div>
        <div class='card-body'>
            <?php echo e(html()->modelForm($beneficiaire)->open()); ?>

                <?php echo e(html()->hidden( 'benef_type',$benef_type)); ?>

                <?php echo $__env->make('tiers.beneficiaires.content', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <input type="hidden" value="<?php echo e($onglet_actif); ?>" id="tab_inplace" />
            <?php echo e(html()->closeModelForm()); ?>

        </div>
        <div class='card-footer'>
            <?php if($beneficiaire->IsSupprimable && ($user->hasRole("ADMINISTRATEUR") || $user->can("CRE_SUP"))): ?>
                <?php echo e(html()->form('DELETE', url('/beneficiaires/'. $beneficiaire->id."?benef_type=".$benef_type))->open()); ?>

                &nbsp;<?php echo html()->button('Supprimer')->value('Supprimer')->type('submit')
                    ->attributes(['onclick'=>'if(!confirm("Voulez-vous vraiment supprimer ce bénéficiaire ?")) return false;','class' => 'btn btn-danger']); ?>

                <?php echo e(html()->form()->close()); ?>

            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox.css')); ?>">
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox-buttons.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts0'); ?>
    <script src="<?php echo e(url('js/jquery.fancybox.js')); ?>"></script>
    <script src="<?php echo e(url('js/magicsuggest.js')); ?>"></script>

    <script type="text/javascript">
        //EDITIONS
        $(function() {
            $("#imprimer").click(function(){
                var radioValue = $("input[name='optionsRadios']:checked").val();
                var annee = ($("#ret_ann_annee").val()?$("#ret_ann_annee").val():<?php echo date('Y')-1; ?>);
                if(radioValue){
                    url="<?php echo url('attestation_edition/'.$beneficiaire->id.'/'.$benef_type); ?>"+"/"+radioValue+"/"+annee;
                    window.open(url,'_blank');
                }
                return;
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript">
        $(function () {
            $('.nav-item a').click(function(){
                var tab = $(this).attr("href").replace("#","");
                $('#tab_inplace').val(tab);
            })

            $('#mdyTab').click(function() {
                $('a[data-toggle="tab"]').bind('click', function (e) {
                    e.preventDefault();
                    var tab = $(this).attr("href").replace("#","");
                    $('#tab_inplace').val(tab);
                });
            });

            $('#btn_modifier').click(function() {
                var onglet=$('#tab_inplace').val();;
                var url="<?php echo url('beneficiaires_filtre/'.$beneficiaire->id).'/'.$benef_type; ?>"+"/"+onglet+"/edit";
                location.href=url;
            });
        });
    </script>
    <?php echo $__env->make('tiers.beneficiaires.scripts_beneficiaire', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;
    <?php echo $__env->make('tiers.beneficiaires.scripts_beneficiaire_tables', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/tiers/beneficiaires/show.blade.php ENDPATH**/ ?>