<?php $__env->startSection('title'); ?> Mandats <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Mandats <?php $__env->stopSection(); ?>
<?php $__env->startSection('subtitle_card',"Liste complète"); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">

        <?php if(Session::has('message')): ?>
            <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
        <?php endif; ?>

        <div class="card-header">
            <div class="form-group row">
                <div class='col-md-3'>
                    <?php echo html()->label('Années :','annes'); ?>

                    <?php echo html()->select('exercice')->options($exercices)
                        ->value($exercice)
                        ->placeholder('Choisir un exercice')
                        ->attributes(['class' => 'form-control','id' => 'select_exercice']); ?>

                </div>
                <?php if($user->can("MDT_AJO") || $user->HasRole("ADMINISTRATEUR")): ?>
                    <div class="col-md-3 ">
                        <?php echo html()->label( '&nbsp;',''); ?><br/>
                        <?php echo html()->a(url('mandats/create'),"Ajouter un Mandat")->attributes(['class' => 'btn btn-success']); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>

        <div class="card-body">
            <table id="_table" class="table table-condensed table-striped table-hover table-bordered">
                <thead>
                    <tr>
                        <th width='1px' nowrap>N°</th>
                        <th width='1px'>Exe.</th>
                        <th width='1px'>Date</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'>Statut<br/>Transfert</th>
                        <th width='1px'>Date de validation</th>
                        <th>Créanciers</th>
                        <th>Imputations</th>
                        <th width='1px'>Total</th>
                        <th width='1px'></th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $mandats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mandat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $imputation=App\Models\Imputation::find($mandat->id);
                            $class_type="";
                            if($mandat->type=='A') $class_type='bg-danger';
                        ?>
                    <tr>
                        <td align="center">
                            <?php if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                <a href="<?php echo url('mandats/'.$mandat->id); ?>"
                                    class="" style="margin-right: 3px;">
                            <?php endif; ?>

                            <?php echo str_pad($mandat->id,6,'0',STR_PAD_LEFT); ?>


                            <?php if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                </a>
                            <?php endif; ?>
                        </td>
                        <td><?php echo $mandat->exercice.$mandat->statut_transfert; ?></td>
                        <td><?php echo $mandat->date_sai; ?></td>
                        <td><?php echo $mandat->statut_mdt; ?></td>
                        <td>
                            <?php echo $mandat->StatutTransfertLibelle; ?>

                            <?php if($mandat->statut_transfert=="TRA"): ?>
                                <br/><?php echo $mandat->DateTransfert; ?>

                            <?php endif; ?>
                        </td>
                        <td><?php echo $mandat->date_valid; ?></td>
                        <td style='font-size:12px'><?php echo $mandat->getListeCreancierHTML(); ?></td>
                        <td style='font-size:12px'><?php echo $mandat->getListeImputationsHTML(); ?></td>
                        <td class='<?php echo $class_type; ?>' nowrap align="right" style="color:darkblue;"><?php echo $mandat->montant; ?></td>
                        <td>
                        <?php if($user->can("MDT_MAJ") || $user->HasRole("ADMINISTRATEUR")): ?>
                            <a href="<?php echo url('mandats/'.$mandat->id.'/edit'); ?>" class="btn btn-sm btn-info pull-left" style="margin-right: 3px;margin-bottom: 3px;">Modifier
                            </a>
                        <?php endif; ?>
                        <?php if($user->can("MDT_TRF") || $user->HasRole("ADMINISTRATEUR")): ?>
                                <?php if(!$mandat->statut_transfert): ?>
                                    <a href="<?php echo url('mandatements_settransfert/'.$mandat->id.'/'.$exercice); ?>" class="btn btn-sm btn-primary" >A&nbsp;Transférer
                                    </a>
                                <?php endif; ?>
                                <?php if($mandat->statut_transfert=="ATR"): ?>
                                    <a href="<?php echo url('mandatements_unsettransfert/'.$mandat->id.'/'.$exercice); ?>" class="btn btn-sm btn-warning" >Ne&nbsp;pas&nbsp;Transférer
                                    </a>
                                <?php endif; ?>
                        <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>


    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable_btn", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        $(function () {
            $('#select_exercice').change(function() {

                var exercice=$('#select_exercice').val();
                if((exercice==undefined)||(exercice=="")) return false;;
                url="<?php echo url('mandats_annee/'); ?>/"+exercice  ;
                location.href=url;
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/mandatements/mandats/index.blade.php ENDPATH**/ ?>