

<?php $__env->startSection('title',"Analyses"); ?>
<?php $__env->startSection('title_card',$titre); ?>

<?php $__env->startSection('styles'); ?>
    <?php echo Html::style('css/morris.css'); ?>


    <style>
        td.right {
          text-align: right;
        }
        td.center {
          text-align: center;
        }
        #overlay{   
          position: fixed;
          top: 0;
          z-index: 100;
          width: 100%;
          height:100%;
          display: none;
          background: rgba(0,0,0,0.2);
        }
        .cv-spinner {
          height: 100%;
          display: flex;
          justify-content: center;
          align-items: center;  
        }
        .spinner {
          width: 40px;
          height: 40px;
          border: 4px #ddd solid;
          border-top: 4px #2e93e6 solid;
          border-radius: 50%;
          animation: sp-anime 0.8s infinite linear;
        }
        @keyframes  sp-anime {
          100% { 
            transform: rotate(360deg); 
          }
        }
        .is-hide{
          display:none;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div id="overlay">
      <div class="cv-spinner">
        <span class="spinner"></span>
      </div>
    </div>

    <div class="card">
        <div class="card-header">
            <div class="form-group row">
                <input type="hidden" id="numgraph" name="numgraph" value="<?php echo (isset($numgraph)?$numgraph:'1'); ?>" />
                <div class="row">
                    <h1 id="libelle_tab">Statistiques sur les bénéficiaires</h1>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-2" >
                    <?php if($user->HasRole("ADMINISTRATEUR") || $user->can("ANA_ASOC")): ?>
                    <div class="btn_mode" style='margin-bottom:20px;'>
                        <span class="btn_type_benef btn btn-sm btn-info active" style='width:100px'>
                            <a id='graph1' href="#" style="color:white;text-decoration: none;" data-range='1'>Aides sociales</a>
                        </span>
                    </div>
                    <?php endif; ?>

                    <?php if($user->HasRole("ADMINISTRATEUR") || $user->can("ANA_ALL")): ?>
                    <div class="btn_mode"  style='margin-bottom:20px;'>
                        <span class="btn_type_benef btn btn-sm btn-primary"  style='width:100px'>
                            <a id='graph2' href="#" style="color:white;text-decoration: none;" data-range='2'>Allocations</a>
                        </span>
                    </div>
                    <?php endif; ?>

                    <?php if($user->HasRole("ADMINISTRATEUR") || $user->can("ANA_RET")): ?>
                    <div class="btn_mode"  style='margin-bottom:20px;'>
                        <span class="btn_type_benef btn btn-sm btn-warning"  style='width:100px'>
                            <a id='graph3' href="#" style="color:white;text-decoration: none;" data-range='3'>Retraites</a>
                        </span>
                    </div>
                    <?php endif; ?>
                </div>

                <div class="col-md-10">
                    <div class="card card-primary card-outline card-tabs">
                      <div class="card-header p-0 pt-1 border-bottom-0">
                        <ul class="nav nav-tabs" id="custom-tabs-three-tab" role="tablist">
                          <li class="nav-item">
                            <a class="nav-link active" id="custom-tabs-three-home-tab" data-toggle="pill" href="#custom-tabs-three-home" role="tab" aria-controls="custom-tabs-three-home" aria-selected="true">Graphique</a>
                          </li>
                          <li class="nav-item">
                            <a class="nav-link" id="custom-tabs-three-profile-tab" data-toggle="pill" href="#custom-tabs-three-profile" role="tab" aria-controls="custom-tabs-three-profile" aria-selected="false">Données</a>
                          </li>
                        </ul>
                      </div>
                      <div class="card-body">
                        <div class="tab-content" id="custom-tabs-three-tabContent">
                            <div class="tab-pane fade active show" id="custom-tabs-three-home" role="tabpanel" aria-labelledby="custom-tabs-three-home-tab">
                                <div id='div_graph' class="">
                                    <div id="graph" style="height: 350px;"></div>  
                                </div>                
                            </div>
                            <div class="tab-pane fade" id="custom-tabs-three-profile" role="tabpanel" aria-labelledby="custom-tabs-three-profile-tab">
                                <div id='div_data2'  class="">
                                    <div  id="data_table" class="">
                                        <table id="_table" name="_table" class="table display"  cellspacing="0" width="100%"></table>
                                    </div>
                                </div>
                            </div>
                        </div>
                      </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <!-- Datatable  -->

    <!-- Graph  -->
    <?php echo Html::script('js/raphael-min.js'); ?>

    <?php echo Html::script('js/morris.min.js'); ?>


    <!-- Datatable  -->
    <?php echo Html::script('js/jquery.dataTables.js'); ?>


    <?php $nb_graph=3; //important poru charger les lib de graph ?>

    <script>
        // Define the area for the spinner
        var spinTarget = document.getElementById('graph');
        var graph_defaut="1"; //N°Graphique par defaut
        if($('#numgraph').val()!="") {graph_defaut=$('#numgraph').val();}
        $('#menu_'+graph_defaut).addClass('active');
        set(graph_defaut);

        var t_api=new Array();
        t_api[1]="api_nb_aidesocales";
        t_api[2]="api_nb_allocations";
        t_api[3]="api_nb_retraites";

        jQuery.ajaxSetup({
          beforeSend: function() {
             $("#overlay").fadeIn(300);
          },
          complete: function(){
             $('#overlay').hide();
          },
          success: function() {}
        });


        $('ul.nav-tabs a').click(function (e) {
            var el2 = $(this);
            typechart = el2.attr('data-range');
            el2.parent().addClass('active');
            el2.parent().siblings().removeClass('active');
            if($('.btn_mode span.active a')) numgraph=$('.btn_mode span.active a').attr('data-range');
            if(typechart=="G") {
                $("#div_graph").show();
                $("#div_data").hide();
            }
            if(typechart=="D") {
                $("#div_graph").hide();
                $("#div_data").show();
            }
            Graph(numgraph);
        })

        $('span.btn_type_benef a').click(function (e) {
            e.preventDefault();
            while (spinTarget.hasChildNodes()){
                spinTarget.removeChild(spinTarget.lastChild);
            }
            var el = $(this);
            $('.btn_type_benef').removeClass('active');
            el.parent().addClass('active');

            var numgraph="";
            if($('.btn_type_benef.active a')) numgraph=$('.btn_type_benef.active a').attr('data-range');
            Graph(numgraph);
        })

        function set(numgraph) {
            while (spinTarget.hasChildNodes()){
                spinTarget.removeChild(spinTarget.lastChild);
            }
            var el = $('#graph'+numgraph);
            el.parent().addClass('active');
            el.parent().siblings().removeClass('active');
            //Graph(numgraph);
        }

        // Create a function that will handle AJAX requests
        function requestData(numgraph,chart) {
            // Activate the spinner
            //var spinner = new Spinner().spin(spinTarget);
            var api=t_api[numgraph];
            $.ajax({
                type: "GET", dataType: 'json',
                url: "../../"+t_api[numgraph], 
                data: {  } //ex : days: days
            })
            .done(function (data) {
                if(chart!="") chart.setData(data);
                if(numgraph==1) $('#libelle_tab').html("Statistiques sur les bénéficiaires d'Aides Sociales");
                if(numgraph==2) $('#libelle_tab').html("Statistiques sur les bénéficiaires d'Allocations");
                if(numgraph==3) $('#libelle_tab').html("Statistiques sur les bénéficiaires de Retraites");
                $('#overlay').hide();
                
            })           
            .fail(function () {
                alert("Erreur");
            })
            .always(function () {
                
            });
        }

        function initData() {
            //Initialisation
            $('#_table').remove();    
            $('#data_table').html('<table width="100%" cellspacing="0" id="_table" class="display table"></table>');
        }

        // Graph chargement
        function Graph(numgraph) {
            initData();
            <?php for($i=1;$i<=$nb_graph;$i++): ?>
                <?php echo $__env->make('stats.stats_graph_'.$i, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endfor; ?>
            requestData(numgraph,chart);
        }  

        //Demarrage pagebdefaut
        $("#div_graph").show();
        $("#div_data").hide();
        Graph(graph_defaut);
    </script>



<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/stats/index_graph.blade.php ENDPATH**/ ?>