

<?php $__env->startSection('title'); ?> Balance <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Balance <?php $__env->stopSection(); ?>
<?php $__env->startSection('subtitle_card',""); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">

        <?php if(Session::has('message')): ?>
            <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
        <?php endif; ?>

        <?php if($errors): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class='bg-danger alert'><?php echo $error; ?></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <?php if(Session::has('success')): ?>
            <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
        <?php endif; ?>  

        <div class="card-header">
            <div class="form-group row">
                <div class='col-md-4'>
                    <?php echo Form::label('jnx', 'Journal'); ?>

                    <?php echo Form::select('jnx',
                            $liste_journaux+["ALL"=>"Tous"],isset($jnx)?$jnx:"",
                                ['placeholder'=>'Tous','id'=>'jnx','class' => 'form-control']); ?> 
                </div>

                <div class='col-md-2'>
                    <?php echo Form::label('date_debut', 'Date de début'); ?>

                    <div class='input-group date' id='datepicker_date_debut'>
                    <?php echo Form::text('date_debut',isset($date_deb)?$date_deb:'01/01/'.date('Y'), 
                            ['id'=>'date_debut','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']); ?>

                        <span class='input-group-addon'>
                            <span class='glyphicon glyphicon-calendar'></span>
                        </span>
                    </div>
                </div>
                <div class='col-md-2'>
                    <?php echo Form::label('date_fin', 'Date de fin'); ?>

                    <div class='input-group date' id='datepicker_date_fin'>
                    <?php echo Form::text('date_fin',isset($date_fin)?$date_fin:'31/12/'.date('Y'), 
                            ['id'=>'date_fin','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']); ?>

                        <span class='input-group-addon'>
                            <span class='glyphicon glyphicon-calendar'></span>
                        </span>
                    </div>
                </div>
                <div class='col-md-2 p-4' style="margin-top:5px" >
                    <a class="btn btn-primary"  href="#" onclick="valide()">Rechercher</a>
                </div>
            </div>

            <script>
                function valide() {
                    var select_jnx = [...document.getElementById('jnx').selectedOptions].map(option => option.value);
                    if(select_jnx=="") select_jnx=0;
                    var date_dep=document.getElementById('date_debut').value;
                    var date_fin=document.getElementById('date_fin').value;
                    var t_date_dep = date_dep.split('/');
                    date_dep= t_date_dep[2]+"-"+t_date_dep[1]+"-"+t_date_dep[0];
                    var t_date_fin = date_fin.split('/');
                    
                    date_fin= t_date_fin[2]+"-"+t_date_fin[1]+"-"+t_date_fin[0];
                    var url="<?php echo url('balance_filtre/'); ?>/"+select_jnx+"/"+date_dep+"/"+date_fin ; 
                    location.href=url;
                }
            </script>
        </div>

        <div class="card-body">
            <table id="_table" width="100%" class="table table-bordered">
                <thead>
                    <tr>
                        <th width='1%'>CompteTri</th>
                        <th width='1%'>Compte</th>
                        <th>Designation</th>
                        <th width='1%'>Débit</th>
                        <th width='1%'>Crédit</th>
                        <th width='1%'>Solde</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $t_plan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$ligne): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="p_titre">
                        <td nowrap><?php echo str_pad($ligne['compte'],7,'0',STR_PAD_RIGHT); ?></td>
                        <td nowrap >
                            <a href="<?php echo url('plan_comptable/'.$ligne['id_compte']); ?>" >
                                <?php echo $ligne['compte']; ?>

                            </a>
                        </td>
                        <td><?php echo $ligne['compte_libelle']; ?></td>
                        <td nowrap align="right" style='font-style:italic'><?php echo $ligne['debit']; ?></td>
                        <td nowrap align="right"><?php echo $ligne['credit']; ?></td>
                        <td nowrap align="right"><?php echo $ligne['solde']; ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script>
  $(function () {
    $("#_table").DataTable({
      "paging": false,
      "lengthChange": false,
      "searching": true,
      "ordering": false,
      "info": false,
      "responsive": true, 
      "autoWidth": true,
      iDisplayLength:20,
       oLanguage: {
            "sZeroRecords": "Aucune ligne",
            "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
            "sInfoEmpty": "Showing 0 to 0 of 0 records",
            "sInfoFiltered": "(sur un total de _MAX_ lignes)",
            "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                "sSearch":"Chercher",
            
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }
        },
        dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",

        "buttons": ["copy", "excel", "colvis"], //"print", "pdf", "csv", 
        "aaSorting": [
            [0,'asc']
        ],
        "columnDefs": [
            { "targets": [ 4], "orderable": false,"searchable": false},
            { "targets": [ 0], "visible": false},
            { "targets": [ 1-4], "orderable": false},
        ]
    })
    .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp7422\htdocs\sysinfo\cpswf\sipre_new\resources\views/comptabilite/balance/index.blade.php ENDPATH**/ ?>