

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header bg-info">
            <h4>Nombre d'employés au <?php echo $exercice; ?></h4>
        </div>
        <div class="card-body">
            <!-- ------------------------------------- ONGLET EMPLOYES ------------------------------- -->
            <div class="row">
                <div class="col-md-3">
                    <?php echo html()->label('Année :','annes' ); ?>

                    <?php echo html()->select('exercice',$exercices,$exercice)->placeholder('A définir')->attributes(['id' => 'exercice_id','class' => 'form-control']); ?>

                </div>

                <div class="col-md-3">
                    <?php echo html()->label( 'Mois :','mois'); ?>

                    <?php echo html()->select('mois',$t_mois,$mois)->placeholder('A définir')->attributes(['id' => 'mois_id','class' => 'form-control']); ?>

                </div>
            </div>
            <br/>
            <div class="row">
                <table id="_table" class="table table-striped table-bordered table-hover" >
                    <thead>
                        <tr>
                            <th width="1px" style="vertical-align:middle" rowspan="2">Id</th>
                            <th style="vertical-align:middle" rowspan="2">Employeur</th>
                            <th style="vertical-align:middle" rowspan="2">Secteur</th>
                            <th style="vertical-align:middle" rowspan="2">District</th>
                            <?php for($i=$deb_mois;$i<=$fin_mois;$i++): ?>
                                <th width="1%" style="text-align:center" colspan="2" ><?php echo $t_mois[$i]; ?></th>
                            <?php endfor; ?>
                        </tr>
                        <tr>
                            <?php for($i=$deb_mois;$i<=$fin_mois;$i++): ?>
                                <th width="1%" style="background-color:#A6BFE9;" align="right">NbSal</th>
                                <th width="1%" style="background-color:#B9F2CE;">MasseSal.</th>
                            <?php endfor; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $societes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $societe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo str_pad($societe->id,4,'0',STR_PAD_LEFT); ?></td>
                            <td>
                                <?php if($user->can("EMP_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                    <a href="<?php echo e(url('./employeurs/'.$societe->id)); ?>" target="_blank">
                                <?php endif; ?>

                                <?php echo (strlen($societe->nom)>30)?substr($societe->nom,0,40)."...":$societe->nom; ?>


                                <?php if($user->can("EMP_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                    </a>
                                <?php endif; ?> 
                            </td>
                            <td><?php echo $societe->Secteur; ?></td>
                            <td><?php echo $societe->district; ?></td>
                            <?php for($i=$deb_mois;$i<=$fin_mois;$i++): ?>
                                <td style="background-color:#A6BFE9;"  align="right"><?php echo $t_employeurs["nbsal"][$i][$societe->id]; ?></td>
                                <td style="background-color:#B9F2CE;" align="right"><?php echo $t_employeurs["massesal"][$i][$societe->id]; ?></td>
                            <?php endfor; ?>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div> 
    </div> 
<?php $__env->stopSection(); ?>




<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('#exercice_id').on('change', function() {
                location.href="<?php echo url('/stats/salaires'); ?>/"
                    +$('#exercice_id').val()+"/"+$('#mois_id').val();
            });

            $('#mois_id').on('change', function() {
                location.href="<?php echo url('/stats/salaires'); ?>/"
                    +$('#exercice_id').val()+"/"+$('#mois_id').val();
            });
        });
        var table =$('#_table').dataTable( {
            bAutoWidth: false,
            bPaginate: true,
            bInfo: false,
            bFilter: false,
            deferRender:    true,
            scrollCollapse: false,
            scroller:       false,
            iDisplayLength:20,
            oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                    ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                    "sSearch":"Chercher ",
                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',
                    print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                    }
                }

                },
                dom: "<'row'<'col-sm-4 text-left'f><'col-sm-8 text-right'B>>" +
                "<'row'<'col-sm-12'tr>>" +
                "<'row'<'col-sm-5'i><'col-sm-7'p>>",
                buttons: [ 
                    {extend: 'copy',exportOptions: {columns: ':visible'} },
                    {extend: 'excel',exportOptions: {columns: ':visible'} }
                ],
                
                columnDefs: [ {
                            targets: ['_all'],
                            visible: true
                        } ]
        } );
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/stats/index_salaries.blade.php ENDPATH**/ ?>