<?php $__env->startSection('title'); ?> Employeurs <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Employeurs <?php $__env->stopSection(); ?>
<?php $__env->startSection('subtitle_card',"Liste complète"); ?>
<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header">
            <div class="form-group row">
                <div class='col-md-3'>
                    <?php echo html()->label('Type de Statut','select_statut'); ?>

                    <?php echo html()->select('select_statut')->options($statuts)
                        ->value(isset($statut)?$statut:"")
                        ->placeholder('Choisir un statut')
                        ->attributes(['class' => 'form-control','id' => 'select_statut']); ?>

                </div>
                <div class='col-md-2'>
                    <?php echo html()->label('Type de Ile','select_ile'); ?>

                    <?php echo html()->select('select_ile')->options($iles)
                        ->value(isset($ile)?$ile:"")
                        ->placeholder('Choisr une origine')
                        ->attributes(['class' => 'form-control','id' => 'select_ile']); ?>

                </div>
                <?php if($user->can("EMP_AJO") || $user->HasRole("ADMINISTRATEUR")): ?>
                    <div class="col-md-3 ">
                        <?php echo html()->label( '&nbsp;',''); ?><br/>
                        <?php echo html()->a(url('employeurs_add/'.$origine),"Ajouter un employeur")->attributes(['class' => 'btn btn-success']); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="card-body">
            <table id="_table" class="table table-condensed table-striped table-hover table-bordered">
                <thead>
                    <tr>
                        <th width='1px'>N°</th>
                        <th>Nom</th>
                        <th width='1px'>CompteAux</th>
                        <th width='1px'>NbSalariés</th>
                        <th width='1px'>Ile</th>
                        <th width='30%'>Responsable</th>
                        <th width='30%'>Email</th>
                        <th width='1px'>Secteur</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'>Solde&nbsp;<?php echo e(date('Y')); ?></th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $employeurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employeur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $solde=$employeur->getSoldeCompta();
                    ?>
                    <tr>
                        <td class=""><?php echo str_pad($employeur->id,4,'0',STR_PAD_LEFT); ?></td>
                        <td>
                            <?php if($user->can("EMP_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                <a href="<?php echo url('employeurs_filtre/'.$employeur->id."/".$origine); ?>" ><?php echo $employeur->NomReduit; ?></a>
                            <?php else: ?>
                                <?php echo $employeur->NomReduit; ?>

                            <?php endif; ?>
                        </td>
                        <td><?php echo $employeur->compte_aux; ?></td>
                        <td><?php echo $employeur->Nbemployes; ?></td>
                        <td><?php echo $employeur->ile; ?></td>
                        <td><?php echo (strlen($employeur->responsable)>20)?substr($employeur->responsable,0,20):$employeur->responsable; ?></td>
                        <td><?php echo $employeur->email; ?></td>
                        <td><?php echo $employeur->secteur; ?></td>
                        <td><?php echo $employeur->statut; ?></td>
                        <td nowrap align="right" style="font-weight:bold;color:<?php echo e(($solde<0)?'red':'green'); ?>"><?php echo is_numeric($solde)?number_format($solde,0,","," "):"-"; ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script>
    $(function () {
        $('#select_statut').change(function() {select_filtre();});
        $('#select_ile').change(function() {select_filtre();});

        function select_filtre() {
            var statut=$('#select_statut').val();
            if(statut=="") statut=0;
            var ile=$('#select_ile').val();
            if(ile=="") ile=0;
            url="<?php echo url('employeurs/'.$origine); ?>"+"/"+statut+"/"+ile  ;
            location.href=url;
        }
    });
</script>
    <?php echo $__env->make("forms.scripts_datatable", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/tiers/employeurs/index.blade.php ENDPATH**/ ?>