<?php $__env->startSection('title'); ?> Enfants <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',"Enfants"); ?>
<?php $__env->startSection('subtitle_card',"Liste"); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header row">
            <div class="col-md-5">
                <?php echo html()->label( 'Dont un des parents à le statut :',''); ?>

                <?php echo html()->select('benef_type', $liste_beneftype,$benef_type)->attributes(['id' => 'benef_type2','class' => 'form-control']); ?>

            </div>
            <?php if($user->can("ENF_AJO") || $user->HasRole("ADMINISTRATEUR")): ?>
                <div class="col-md-3 ">
                    <?php echo html()->label( '&nbsp;',''); ?><br/>
                    <?php echo html()->a(url('enfants/create?benef_type='.$benef_type),"Ajouter un enfant")->attributes(['class' => 'btn btn-success']); ?>

                </div>
            <?php endif; ?>
        </div>
        <div class="card-body">
             <div class="row">
                <table id="_table"  style="background-color:white"
                    class="table table-condensed table-hover table-striped table-bordered">
                    <thead>
                        <tr>
                            <th width='1px'>Id</th>
                            <th>Nom</th>
                            <th width='1px'>Sexe</th>
                            <th width='1px'>Certif.</th>
                            <th width='1px'>Date de naissance</th>
                            <th nowrap width='1%'>N°Resp.</th>
                            <th width='10%'>Responsable</th>
                            <th width='1px'>Statut Resp.</th>
                            <th width='10%'>Conjoint</th>
                            <th width='1px'>Statut Conj.</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $enfants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enfant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo str_pad($enfant->id, 6, "0", STR_PAD_LEFT); ?></td>
                            <td nowrap>
                                <?php if($user->can("ENF_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                    <a href="<?php echo url('enfants_show/'.$enfant->id.'/'.$benef_type); ?>">
                                <?php endif; ?>
                                    <?php echo $enfant->nom.' '.$enfant->prenom; ?>

                                <?php if($user->can("ENF_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                    </a>
                                <?php endif; ?>
                            </td>
                            <td align="center"><?php echo $enfant->sexe; ?></td>
                            <td align="center"><?php echo $enfant->certif; ?></td>
                            <td nowrap><?php echo $enfant->datenais; ?></td>
                            <td align="center"><?php echo $enfant->parents1; ?></td>
                            <td nowrap><?php echo $enfant->nom_parent1_reduit; ?></td>
                            <td align="center"><?php echo $enfant->statut_parent1; ?></td>
                            <td nowrap><?php echo $enfant->nom_parent2_reduit; ?></td>
                            <td align="center"><?php echo $enfant->statut_parent2; ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
            $('#benef_type2').on('change', function() {
                var benef_type=$('#benef_type2').val();
                location.href="<?php echo url('enfants_in/'); ?>/"+benef_type;
            });
        });

        <?php if($user->can("ENF_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
            jQuery(document).ready(function($) {
                $(".clickable-row").click(function() {
                    window.document.location = $(this).data("href");
                });
            });

        <?php endif; ?>
    </script>

    <?php echo $__env->make("forms.scripts_datatable_btn", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/tiers/enfants/index.blade.php ENDPATH**/ ?>