
<div class="row form-group">
    <div class="col-md-4">
            <?php echo html()->label( 'Bénéficiaire','benum'); ?>

            <div class="input-group mb-5 ">
                <div class="input-group-prepend " >
                    <span class="input-group-text bg-info" id="ref_beneficiaire"><?php echo $beneficiaire->id; ?></span>
                </div>
                <?php echo html()->text('benom', $beneficiaire->NomComplet)->attributes(['disabled', 'class' => 'text-left form-control']); ?>

            </div>
    </div>
    <div class="col-md-8">
            <?php echo html()->label( 'Employeur','sonum'); ?>

            <div class="input-group mb-5 ">
                <div class="input-group-prepend " >
                    <span class="input-group-text bg-info" name="ref_employeur" id='ref_employeur'><?php echo $employeur->id; ?></span>
                </div>
                <?php echo html()->text('employeur_nom', $employeur->nom)->attributes([($mode=="show"?'disabled':''),'name'=>"employeur_nom",'id'=>"employeur_nom",'class' => 'form-control']); ?>

            </div>
    </div>
</div>

<div class="row form-group">
    <div class="col-md-1">
            <?php echo html()->label( 'Année','annee'); ?>

            <?php echo html()->text('annee', null)->attributes(['class' => 'form-control',($mode=="show"?'disabled':'')]); ?>

    </div>

    <div class="col-md-3">
        <?php echo html()->label( 'Date d\'entrée','dat_ent'); ?>

        <div class="input-group">
            <div class='input-group date' id='datepicker_dat_ent'>
                <?php echo html()->text('dat_ent', null)->placeholder('Date d\'entrée')->attributes([($mode=="show"?'disabled':''),'class' => 'form-control']); ?>

                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
            </div>
        </div>
    </div>

    <div class="col-md-3">
        <?php echo html()->label( 'Date de sortie','date_sor'); ?>

        <div class="input-group">
            <div class='input-group date' id='datepicker_date_sor'>
                <?php echo html()->text('date_sor', null)->placeholder('Date de sortie')->attributes([($mode=="show"?'disabled':''),'class' => 'form-control']); ?>

                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
            </div>
        </div>
    </div>
</div>


<hr/>
<div class="form-group">
    <?php if($mode=="edit"): ?>
        <button type="button" id="btn_ventiler" class="btn bt-sm btn-success">Ventiler un salaire</button>
        <input type='hidden' id='ventil_active' value="0" />
    <?php endif; ?>
    <?php if($mode=="show"): ?>
        <a href="<?php echo url('log_salaires/'.$salaire->id); ?> "
            class="btn bt-sm btn-warning box_log fancybox.iframe">Historique
        </a>
    <?php endif; ?>
    <?php if($mode!="show"): ?>
        <?php echo html()->button('Enregistrer')->value('Enregistrer')->type('submit')->attributes(['class' => 'btn btn-primary']); ?>

    <?php else: ?>
        <?php if($user->hasRole("ADMINISTRATEUR") || $user->can("SAL_MAJ")): ?>
            <a class="btn btn-primary" href="<?php echo e(url('salaires/'.$salaire->id.'/edit')); ?>" id="btn_modifier">Modifier</a>
        <?php endif; ?>
    <?php endif; ?>
</div>


    <div class="col-md-12">
        <table class="table table-condensed table-striped table-bordered">
            <thead>
                <tr>
                    <th ></th>
                    <?php $tmois=App\Models\MyApp::MOIS_COURT_LONG; ?>
                    <?php $__currentLoopData = $tmois; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois=>$libelle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td width='8%' >
                            <?php echo html()->label( $libelle,$mois); ?>

                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            </thead>
            <tbody>
                <?php if($mode=="edit"): ?>
                <tr>
                    <th><?php echo e(($mode!="show")?'Montant Origine':'Montant'); ?></th>
                    <?php $__currentLoopData = $tmois; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois=>$libelle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td style='vertical-align:middle;padding:3px'>
                            <?php echo html()->text('origine', isset($salaire)?$salaire->{$mois}:null)
                                ->attributes(['class' => 'form-control', 'style'=>'text-align:right;padding:2px','disabled']); ?>

                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <?php endif; ?>
                
                    <tr>
                        <th>Montant</th>
                        <?php $__currentLoopData = $tmois; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois=>$libelle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td style='vertical-align:middle;padding:3px'>
                                <?php echo html()->text($mois, null)
                                    ->attributes([($mode=="show"?'disabled':''),'class' => 'form-control', 'style'=>'text-align:right;padding:2px']); ?>

                            </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                    <tr>
                        <th>Suspendu</th>
                        <?php $__currentLoopData = $tmois; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois=>$libelle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <td align='center'>
                                <?php echo html()->checkbox('box_'.$mois, (isset($salaire)&&($salaire->getSuspendu($mois))?1:0),1)
                                    ->attributes([($mode=="show"?'disabled':''),'id'=>'box_'.$mois]); ?>

                            </td>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                
            </tbody>
        </table>
    </div>

<?php if($mode=="edit"): ?>
    <div class="col-md-12" id='div_ventil' style='visibility:hidden'>
        <div class="form-group">
            <div class="col-md-2">
                    <?php echo html()->label( 'Montant à ventiler','total_vent'); ?>

                    <?php echo html()->text('total_vent', null)->placeholder('Total à ventiler')->attributes(['id'=>'total_vent',
                                'class' => 'form-control',
                                'onchange'=>'set_vent()']); ?>


                    <?php echo html()->text('total_a_vent', null)->attributes(['id'=>'total_a_vent',
                                'class' => 'form-control',
                                'readonly', 'style'=>'color:grey;font-style:italic;']); ?>

            </div>
        </div>
        <table class="table table-striped table-condensed table-bordered">
            <theader>
                <tr>
                    <th ></th>
                    <?php $__currentLoopData = $tmois; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois=>$libelle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td width='8%' ><?php echo html()->label( substr($libelle.".",0,4),$mois); ?></td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            </theader>
            <tbody>
                <tr>
                    <th nowrap>Ventilation<small style='font-weight:normal'><br>Ajouté au salaire</small></th>
                    <?php $__currentLoopData = $tmois; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois=>$libelle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td  style='vertical-align:middle;padding:3px'>

                        <input class='ventil checkbox' type='checkbox'
                            value='0'
                            id='<?php echo $mois; ?>_check'
                            onchange='set_vent()'
                            style='visibility:hidden'/>

                            <?php echo html()->text($mois.'_vent', null)
                                ->attributes(['id'=>$mois.'_vent','class' => 'form-control input_vent_mois', 'style'=>'text-align:right;padding:2px']); ?>

                        </td>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            </tbody>
        </table>
    </div>
<?php endif; ?>
<?php if($mode=="show"): ?>
    <?php echo e(html()->form('DELETE', url('/salaires/'. $salaire->id))->open()); ?>

    &nbsp;<?php echo html()->button('Supprimer')->value('Supprimer')->type('submit')
    ->attributes(['onclick'=>'if(!confirm("Voulez-vous vraiment supprimer ce Salaire ?")) return false;','class' => 'btn btn-danger']); ?>

    <?php echo e(html()->form()->close()); ?>

<?php endif; ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/recouvrement/salaires/content.blade.php ENDPATH**/ ?>