<div class="col-lg-max">
    <div class="form-group row callout callout-danger">
        <div class="col-md-3">
            <?php echo html()->hidden('checklist','',['id'=>'checklist']); ?>

            <?php echo html()->label( 'Compte auxiliaire','compte_aux'); ?>

            <?php echo html()->text('compte_aux', null)->attributes(['disabled', 'placeholder' => '','class' => 'form-control']); ?>

        </div>
    </div>

    <?php if($origine=="C"): ?>
        <?php if($mode=="show" || (isset($mode_lettrage) && ($mode_lettrage)) ): ?>
            <div class="row ">
                <?php if(isset($mode_lettrage) && ($mode_lettrage)): ?>
                    <div class="col-md-8 " style="">
                        <span class="btn btn-default bts-sm"><a href="<?php echo url('view_lettrage/'.$employeur->id.'/'.$origine.'/lettrage'); ?>">
                            <?php echo ($view_lettrage==0)?"Voir les lignes lettrées":"Ne pas voir les ligne lettrées"; ?>

                        </a></span>
                    </div>
                    <div class="col-md-3" style="">
                        <?php echo html()->label( 'Total lettrage','montant_lettrage'); ?>

                        <?php echo html()->text('montant_lettrage', '')->attributes(['id'=>'montant_lettrage','readonly','class' => 'form-control','style'=>'text-align:right']); ?>

                    </div>
                    <div class="col-md-1" style="padding-top:34px">
                        <?php echo html()->button('Lettrer')->value('Lettrer')->type('submit')->attributes(['id'=>'bt_lettrer','class' => 'btn btn-success']); ?>

                    </div>
                <?php else: ?>
                    <div class="col-md-8 " style="">
                        <span class="btn btn-default bts-sm"><a href="<?php echo url('view_lettrage/'.$employeur->id.'/'.$origine); ?>">
                            <?php echo ($view_lettrage==0)?"Voir les lignes lettrées":"Ne pas voir les ligne lettrées"; ?>

                        </a></span>
                    </div>
                    <div class="col-md-4 " style="">
                        <div class="float-right">
                            <a class="btn btn-info"  href="<?php echo url('employeurs_lettrage').'/'.$employeur->id.'/'.$origine; ?>">Lettrage</a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    <?php endif; ?>


    <div class="row">
        <div class="col-md-12">
            <div class="tab-pane" id="compta">
                <legend>Liste des écritures</legend>
                <div class="form-group">
                    <div class="table">
                        <table id="_table_ecritures" class="table table-condensed table-striped table-bordered" >
                            <?php if(count($ecritures)>0): ?>
                                    <thead>
                                        <tr>
                                            <th width='1px'>Transaction</th>
                                            <th width='1px'>Date</th>
                                            <th width='1px'>Ref</th>
                                            <th width='1px'>Journal</th>
                                            <th width='1px'>Compte</th>
                                            <th >Désignation</th>
                                            <th width='1px'>Débit</th>
                                            <th width='1px'>Crédit</th>
                                            <th width='1px'>Lettrage
                                                <?php if(isset($mode_lettrage) && ($mode_lettrage) ): ?>
                                                    <span style="color:grey;">Tout&nbsp;</span>
                                                    <?php echo html()->checkbox('box_all', '1',false)->attributes(['id'=>'box_all','style'=>'']); ?>

                                                <?php endif; ?>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $total_debit=0;$total_credit=0;$solde=0;
                                        ?>
                                        <?php $__currentLoopData = $ecritures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ecriture): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            if(!$ecriture->debit) $ecriture->debit=0;
                                            if(!$ecriture->credit) $ecriture->credit=0;
                                            $total_debit+=$ecriture->debit;
                                            $total_credit+=$ecriture->credit;
                                            $solde+=$ecriture->credit-$ecriture->debit;

                                        ?>
                                        <tr>
                                            <td align="center">
                                                <a href="<?php echo url('transaction/'.$ecriture->IdTransaction); ?>" target="_blank">
                                                    <?php echo str_pad($ecriture->IdTransaction,5,"0", STR_PAD_LEFT); ?>

                                                </a>
                                            </td>
                                            <td><?php echo $ecriture->date_doc; ?></td>
                                            <td nowrap><?php echo $ecriture->ref_doc; ?></td>
                                            <td align="center"><?php echo $ecriture->journal; ?></td>
                                            <td align="center"><?php echo $ecriture->compte; ?></td>
                                            <td><?php echo $ecriture->designation; ?></td>
                                            <td id="debit_<?php echo $ecriture->id; ?>" class="text-danger" align="right"><?php echo $ecriture->debit; ?></td>
                                            <td id="credit_<?php echo $ecriture->id; ?>" class="text-success" align="right"><?php echo $ecriture->credit; ?></td>
                                            <td nowrap>
                                                <?php if(isset($mode_lettrage) && ($mode_lettrage) && ($ecriture->lettrage_code=="")): ?>
                                                    <input id="box_<?php echo $ecriture->id; ?>" class="form-control box_td"
                                                        name="box_<?php echo $ecriture->id; ?>" type="checkbox" value="1">
                                                <?php else: ?>
                                                    <?php echo $ecriture->lettrage_code; ?>

                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th rowspan="2" colspan="6" style='vertical-align:middle;text-align:right'>TOTAL</th>
                                            <th class="text-danger" style='text-align:right'><?php echo e($total_debit); ?></th>
                                            <th class="text-success" style='text-align:right'><?php echo e($total_credit); ?></th>
                                            <th rowspan="2" style='text-align:right'></th>
                                        </tr>
                                        <tr>
                                            <th colspan="2" nowrap style='text-align:center'>
                                                <span style="text-align:right;color:<?php echo e(($solde<0)?'red':'green'); ?>;"><?php echo e(number_format($solde,0,","," ")); ?></span></th>
                                        </tr>
                                    </thead>
                            <?php else: ?>
                                <thead>
                                    <tr>
                                        <td nowrap width='1px' style="font-style:italic;color:darkred">
                                            Aucune écriture
                                        </td>
                                    </tr>
                                </thead>
                            <?php endif; ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/tiers/employeurs/rows_compta.blade.php ENDPATH**/ ?>