

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header bg-info">
        <h1>Secteur <?php echo e($secteur->nom); ?></h1>
    </div>
    <div class="card-body">
        <table id="_table" style="background-color:white" class="table table-condensed table-striped table-bordered">
            <thead>
                <tr>
                    <th width='1%'>N°</th>
                    <th >Employé</th>
                    <th width='1%'>DateNais.</th>
                    <th width='1%'>Année</th>
                    <th width='1%'>DateEnt.</th>
                    <th width='1%'>DateSor</th>
                    <th >N°Emp.</th>
                    <th >Employeur</th>
                    <th >Statut Emp.</th>
                    <th class="sum" width='5%'>Jan</th>
                    <th width='5%'>Fév</th>
                    <th width='5%'>Mar</th>
                    <th width='5%'>Avr</th>
                    <th width='5%'>Mai</th>
                    <th width='5%'>Jui</th>
                    <th width='5%'>Jui</th>
                    <th width='5%'>Aou</th>
                    <th width='5%'>Sep</th>
                    <th width='5%'>Oct</th>
                    <th width='5%'>Nov</th>
                    <th width='5%'>Déc</th>
                    <th width='5%'>Total</th>
                </tr>
            </thead>


            <tbody>
                <?php $__currentLoopData = $salaires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salaire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo $salaire->benum; ?></td>
                    <td><?php echo $salaire->beneficiaire_Nom; ?></td>
                    <td nowrap><?php echo $salaire->BeneficiaireDateNaissance; ?></td>
                    <td nowrap align='center'><?php echo $salaire->annee; ?></td>
                    <td nowrap><?php echo $salaire->dat_ent; ?></td>
                    <td nowrap><?php echo $salaire->date_sor; ?></td>
                    <td nowrap><?php echo str_pad($salaire->sonum, 6, "0", STR_PAD_LEFT); ?></td>
                    <td><?php echo $salaire->EmployeurNom; ?></td>
                    <td><?php echo $salaire->EmployeurStatut; ?></td>
                    <td nowrap align='right'><?php echo $salaire->jan; ?></td>
                    <td nowrap align='right'><?php echo $salaire->fev; ?></td>
                    <td nowrap align='right'><?php echo $salaire->mar; ?></td>
                    <td nowrap align='right'><?php echo $salaire->avr; ?></td>
                    <td nowrap align='right'><?php echo $salaire->mai; ?></td>
                    <td nowrap align='right'><?php echo $salaire->jun; ?></td>
                    <td nowrap align='right'><?php echo $salaire->jui; ?></td>
                    <td nowrap align='right'><?php echo $salaire->aou; ?></td>
                    <td nowrap align='right'><?php echo $salaire->sep; ?></td>
                    <td nowrap align='right'><?php echo $salaire->oct; ?></td>
                    <td nowrap align='right'><?php echo $salaire->nov; ?></td>
                    <td nowrap align='right'><?php echo $salaire->dec; ?></td>
                    <td nowrap align='right'><?php echo $salaire->TotalAnnee; ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {
           $.fn.dataTable.moment('D/M/YYYY');

            var table =$('#_table').dataTable( {
                bAutoWidth: false,
                bPaginate: false,
                bInfo: true,
                bFilter: true,
                        scrollY:        400,
                        scrollX:        '100%',
                        scrollCollapse: true,
                        scroller:       true,

                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                    "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                        ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                        "sSearch":"Chercher ",
                    buttons: {
                        colvis: 'Colonnes à afficher',
                        copy: 'Copier',print: 'Imprimer',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                            }
                        }

                    },

                    //"dom": '<"top"fBl>rt<"bottom"ip><"clear">',
                    dom: "<'row'<'col-sm-3 text-left'f><'col-sm-4'><'col-sm-5 text-center'B>>" +
                    "<'row'<'col-sm-12'tir>>" +
                    "<'row'<'col-sm-5'><'col-sm-7'p>>",

                    "aaSorting": [
                        [1,'asc']
                    ],

                    buttons: [ 
                        {extend: 'copy',exportOptions: {columns: ':visible'} },
                        {extend: 'excel',exportOptions: {columns: ':visible'} },
                        //{extend: 'pdf',orientation: 'landscape',pageSize: 'A3',exportOptions: {columns: ':visible'} },
                        //{extend: 'print',exportOptions: {columns: ':visible'} },
                        //'colvis'
                    ],
                    
                } );

                $('#_table').DataTable().draw();

                $(window).resize(function () {
                            $('#_table').DataTable().draw();
                });
        } );
    </script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.dash_pop', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/recouvrement/salaires/index_secteurs_iframe.blade.php ENDPATH**/ ?>