
<?php $__env->startSection('title','Grand Livre'); ?>
<?php $__env->startSection('title_card',""); ?>
<?php $__env->startSection('subtitle_card',""); ?>
<?php $__env->startSection('content'); ?>


    <div class="card">
        <?php if(Session::has('message')): ?>
            <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
        <?php endif; ?>

        <?php if($errors): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class='bg-danger alert'><?php echo $error; ?></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <?php if(Session::has('success')): ?>
            <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
        <?php endif; ?>  
        
        <div class="card-header bg-warning">
            <h3 class="card-title"><i class="fa fa-plan"></i>Liste des Journaux
                <?php if($exercice_encours!=$exercice): ?>
                <small>Historique Non modififable</small>
                <?php endif; ?>
            </h3>
        </div>
        <div class="card-body">
            <?php echo html()->hidden('checklist','')->attributes(['id'=>'checklist']); ?>

            <div class="row form-group"> 
                 <div class="col-md-2"> 
                    <?php echo html()->select('exercice',$exercices,$exercice)->attributes(['id' => 'exercice','class' => 'form-control']); ?>

                </div>
            </div>

            <div class='row col-lg-max' style="padding-top:5px">
                <div class="alert" style="padding-top:0px">
                    <table id="_table" style="background-color:white" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th nowrap width='1%'></th>
                                <th nowrap width='1%'>N°Journal</th>
                                <th width='1%' >Date</th>
                                <th nowrap width='1%'>N°Compte</th>
                                <th width='1%'>Référence</th>
                                <th>Libelle</th>
                                <th width='5%'>Débit</th>
                                <th width='5%'>Crédit</th>
                                <th width='1%'>Enc</th>
                                <th width='1%'>
                                    <?php if($user->can("JOU_AJO") || $user->HasRole("ADMINISTRATEUR")): ?>
                                     <div>
                                        <a href="<?php echo url('/compta_old/journal/create'); ?>" class="btn btn-sm btn-success">
                                            Ajouter&nbsp;une&nbsp;écriture</a>
                                        &nbsp;
                                        <span >
                                            <a href="#" class="btn btn-sm btn-success" id='bt_compenser' disabled='disabled' onclick='compenser();return;'>
                                                Compenser&nbsp;la&nbsp;sélection</a>
                                        </span>
                                    </div> 
                                    <?php endif; ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $total=["debit"=>0,"credit"=>0]; ?>
                            <?php $__currentLoopData = $journaux; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $journal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $total["debit"]+=$journal->debit;
                                $total["credit"]+=$journal->credit;
                            ?>
                            <tr>
                                <td align="center" style="color:grey;padding:0px;margin:0px">
                                    <?php if($journal->IsCompensable): ?>
                                        <?php echo html()->checkbox('box_'.$journal->id, '1',false)->attributes(['id'=>'box_'.$journal->id,'onclick'=>"check($journal->id)"]); ?>

                                    <?php endif; ?>
                                </td>
                                <td style="color:grey;font-style:italic"><?php echo $journal->id; ?></td>
                                <td align="center"><?php echo $journal->date; ?></td>
                                <td align="center"><?php echo $journal->numcpt; ?></td>
                                <td nowrap><?php echo $journal->ref; ?></td>
                                <td><?php echo $journal->libelle; ?></td>
                                <td nowrap align="right" style="color:darkred;font-weight:bold"><?php echo number_format($journal->debit,0,","," "); ?></td>
                                <td nowrap align="right" style="color:darkblue;font-weight:bold"><?php echo number_format($journal->credit,0,","," "); ?></td>
                                <td nowrap align="right"><?php echo $journal->enc; ?></td>       
                                <td nowrap>
                                </td>  
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

        
<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function() {

            $('#exercice').on('change', function() {
                location.href="<?php echo url('compta_old/journal_exercice/'); ?>"+"/"+$('#exercice').val();
            });
        });
    </script>

    <script>
        //Complete la liste des boites cochées
        function check(id) {
            var list=$("#checklist").val();
            if($("#box_"+id).prop('checked')) {
                var value=id+"~";
                if(list.indexOf(id+"~")==-1) {
                    $("#checklist").val(list+value);
                }
            } else {
                var pos=list.split("~");
                var new_list="";
                for(var i=0;i<pos.length;i++) {
                    if((pos[i]!=id)&&(pos[i]!="")) new_list+=pos[i]+"~";
                }
                $("#checklist").val(new_list);
            }
            var list=$("#checklist").val();

            if(list=="") $("#bt_compenser").attr('disabled','disabled');   
            else $("#bt_compenser").removeAttr('disabled'); 

            $("#bt_compenser").attr('disabled','disabled');   
        }

        function compenser(id) {
            var list=$("#checklist").val();
            if(list=="") return;
            var url="<?php echo url('/compta_old/journal_compense'); ?>"+"/"+list;
            $.fancybox.open({ 
                'autoScale': true,
                'href': url, 
                'type': 'ajax',
                'width': '70%',
                'height': '70%',
                'autoSize': false,
                'autoScale': false,
                'transitionIn': 'elastic',
                'transitionOut': 'elastic',
                'speedIn': 500,
                'speedOut': 300,
                'autoDimensions': false,
                'centerOnScroll': true,

               afterClose: function () { // USE THIS IT IS YOUR ANSWER THE KEY WORD IS "afterClose"
                    parent.location.reload(true);
                }
            });
            return;
        }
    </script>


    <script>
      $(function () {
        $("#_table").DataTable({
          "paging": true,
          "lengthChange": false,
          "searching": true,
          "ordering": true,
          "info": true,
          "responsive": false,
          "autoWidth": false,
          "fixedHeader": true,
           oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                    ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                    "sSearch":"Chercher",
                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                        }
                    }

            },
            dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",
            "aaSorting": [
                [1,'desc']
            ],

            "aoColumnDefs": [
                { "sTypes": "numeric", "aTargets": [ 3 ] },

            ],
            "buttons": ["copy", "excel", "colvis"] //"print", "pdf", "csv",
        })
        .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

      });
    </script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/compta_old/journal/index.blade.php ENDPATH**/ ?>