<?php $__env->startSection('title'); ?> Créanciers <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Créanciers <?php $__env->stopSection(); ?>
<?php $__env->startSection('subtitle_card',"Liste complète"); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <?php if(Session::has('message')): ?>
            <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
        <?php endif; ?>

        <div class="card-header">
            <div class="form-group row">
                <div class='col-md-3'>
                    <?php echo html()->label('Années du mandat :','annes'); ?>

                    <?php echo html()->select('exercice')->options($exercices)
                        ->value($exercice)
                        ->placeholder('Choisir un exercice')
                        ->attributes(['class' => 'form-control','id' => 'select_exercice']); ?>

                </div>
            </div>
        </div>

        <div class="card-body">
            <table id="_table" class="table table-condensed table-striped table-hover table-bordered">
                <thead>
                    <tr>
                        <th width='1%' nowrap>N°</th>
                        <th >Nom</th>
                        <th width='1%'>Compte</th>
                        <th width='1%'>Montant</th>
                        <th width='1%'>IdMandat</th>
                        <th width='1%'>DateMandat</th>
                        <th width='1%'>TypePmt</th>
                        <th width='1%'>IdImputation</th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $creanciers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $creancier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $imputation=App\Models\Imputation::find($creancier->id);
                        $mandat=App\Models\Mandat::find($creancier->idmandat);
                    ?>
                    <tr>
                        <td><?php echo str_pad($creancier->id,5,'0',STR_PAD_LEFT); ?></td>
                        <td>
                            <?php if($user->can("CRE_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                <?php if($origine=='M'): ?> 
                                    <a href="<?php echo url('creanciers_mandat_show/'.$creancier->id); ?>" style="margin-right: 3px;">
                                <?php else: ?>
                                    <a href="<?php echo url('creanciers/'.$creancier->id); ?>" style="margin-right: 3px;">
                                <?php endif; ?>
                            <?php endif; ?>
                                <?php echo $creancier->nomcomplet; ?>

                            <?php if($user->can("CRE_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                </a>
                            <?php endif; ?>
                        </td>
                        <td><?php echo $creancier->Banque; ?><br/><?php echo $creancier->compte; ?></td>
                        <td align="right"><?php echo $creancier->montant; ?></td>
                        <td>
                            <?php if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                            <a href="<?php echo url('mandats/'.$creancier->idmandat); ?>" class="various fancybox.iframe " style="margin-right: 3px;">
                                <?php echo str_pad($creancier->idmandat,6,'0',STR_PAD_LEFT); ?>

                            </a>
                            <?php endif; ?>
                        </td>
                        <td align="center"><?php echo $mandat->date_sai; ?></td>
                        <td align="center"><?php echo $creancier->typepmt; ?></td>
                        <td align="center">
                            <?php if($user->can("IMP_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                            <a href="<?php echo url('imputations/'.$creancier->idimp_mdt); ?>"
                                class="various fancybox.iframe " style="margin-right: 3px;">
                                <?php echo str_pad($creancier->idimp_mdt,6,'0',STR_PAD_LEFT); ?>

                            </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox.css')); ?>">
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox-buttons.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
   <script src="<?php echo e(url('js/jquery.fancybox.js')); ?>"></script>

    <script>
        $(function () {
            $('#select_exercice').change(function() {
                var exercice=$('#select_exercice').val();
                if(exercice=="") return false;;
                url="<?php echo url('/creanciers_annee'); ?>/"+exercice  ;
                location.href=url;
            });
        });
    </script>

    <script type="text/javascript">
        $(".various").fancybox({
            //maxWidth    : 800,
            //maxHeight   : 600,
            fitToView   : true,
            width       : '85%',
            height      : '70%',
            //autoSize    : true,
            //autoScale   : true,
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
        });
    </script>

    <?php echo $__env->make("forms.scripts_datatable_btn", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/tiers/creanciers/index.blade.php ENDPATH**/ ?>