<?php $__env->startSection('title'); ?> Mandats <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Mandats <?php $__env->stopSection(); ?>
<?php $__env->startSection('subtitle_card',"Liste complète"); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">

        <?php if(Session::has('message')): ?>
            <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
        <?php endif; ?>

        <div class="card-header">
            <div class="form-group row">
                <h4>Mandats : Transferts des mandats</h4>
            </div>
        </div>

        <div class="card-body">
            <table id="_table" style="background-color:white"
                class="table table-striped table-bordered table-hover" width="100%">
                <thead>
                    <tr>
                        <th width='1%' nowrap>N°</th>
                        <th width='1%'>Exe.</th>
                        <th width='1%'>Date</th>
                        <th width='1%'>Statut</th>
                        <th width='1%'>Date de validation</th>
                        <th>Créanciers</th>
                        <th>Imputations</th>
                        <th width='1%'>Total</th>
                        <!--<th width='1%'></th>-->
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $mandats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mandat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td align="center"><?php echo str_pad($mandat->id,6,'0',STR_PAD_LEFT); ?></td>
                        <td><?php echo $mandat->exercice; ?></td>
                        <td><?php echo $mandat->date_sai; ?></td>
                        <td><?php echo $mandat->statut_mdt; ?></td>
                        <td><?php echo $mandat->date_valid; ?></td>
                        <td style='font-size:12px'><?php echo $mandat->getListeCreancierHTML(); ?></td>
                        <td style='font-size:12px'><?php echo $mandat->getListeImputationsHTML(); ?></td>
                        <td class='' nowrap align="right" style="color:darkblue;"><?php echo $mandat->montant; ?></td>
                        <!--
                        <td>
                            <div class="col-xs-3">
                                <a href="<?php echo url('/mandats_export_fichier_TP').'/'.$mandat->id; ?>"
                                        class="btn btn-danger"  target="_blank">Générer le fichier DFiP</a>
                            </div>
                        </td>
                        -->
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <div class="card-footer" style="">
            <a href="<?php echo url('/mandats_export_fichier_TP'); ?>" class="btn btn-danger"  target="_blank">Générer le fichier DFiP</a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable_btn", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/mandatements/mandats/index_generation.blade.php ENDPATH**/ ?>