<?php $__env->startSection('title'); ?> Versements <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',""); ?>
<?php $__env->startSection('subtitle_card',""); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>


    <div class="card">
        <div class="card-header bg-info">
            <?php echo "Versement en préparation des ".$user->getTitreStatut($type); ?>

        </div>
        <div class="card-body">
            <?php if($type!=""): ?>
                <?php if($error_compte>0): ?>
                        <div class='bg-danger alert'>
                        <?php if($error_compte==1): ?>
                            <?php echo "Attention : $error_compte compte bancaire est en anomalie !"; ?>

                        <?php else: ?>
                            <?php echo "Attention : $error_compte comptes bancaires sont en anomalie !"; ?>

                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                <div class="table-responsive">
                    <table id="_table" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1%'>N°</th>
                                <th width='1%'>N°Emp</th>
                                <th >Bénéficiaire</th>
                                <th width='1%'>NbEnf<?php echo ($type!="RET")?" Considérés":""; ?></th>
                                <th width='1%'>Naissance</th>
                                <th width='1%'>Statut</th>
                                <th width='1%'>Type</th>
                                <?php if($type=="RET"): ?>
                                <th width='1%'>RetType</th>
                                <th width='1%'>RetDate</th>
                                <th width='1%'>RetNum</th>
                                <?php endif; ?>
                                <!-- <th width='1%' nowrap>N°IMP</th> -->
                                <th width='1%'>Rappel</th>
                                <th width='1%'>Calcul</th>
                                <th width='1%'>Montant</th>
                                <th width='10%'>Banque</th>
                                <th width='10%'>Compte</th>
                                <th>Obs</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $versements_b; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $versement_b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $beneficiaire=App\Models\Beneficiaire::find($versement_b->benum);
                                    $beneftype=substr($type,0,1);
                                ?>
                                <tr>
                                    <td style="color:grey"><?php echo str_pad($versement_b->benum, 5, "0", STR_PAD_LEFT); ?></td>
                                    <td style="color:grey"><?php echo ($versement_b->sonum>0)?str_pad($versement_b->sonum, 5, "0", STR_PAD_LEFT):""; ?></td>
                                    <td style="">
                                        <a href="<?php echo url('beneficiaires_filtre/'.$beneficiaire->id.'/'.$beneftype); ?>" style="text-decoration:none;color:#000" target='_blank'>
                                            <b><?php echo $beneficiaire->nom_complet; ?></b>
                                        </a>
                                    </td>
                                    <td>
                                        <?php echo $versement_b->nb_enf.(($type=="RET")?"":"/".$beneficiaire->NbEnfants); ?>

                                    </td>
                                    <td><?php echo $versement_b->naissance_beneficiaire; ?></td>
                                    <td align="center"><?php echo $versement_b->statut_beneficiaire; ?></td>
                                    <td align="center"><?php echo $versement_b->type; ?></td>
                                    <?php if($type=="RET"): ?>
                                    <td align="center"><?php echo $versement_b->ret_type; ?></td>
                                    <td align="center"><?php echo $versement_b->ret_date; ?></td>
                                    <td align="center"><?php echo $versement_b->ret_num; ?></td>
                                    <?php endif; ?>
                                    <!-- <td align="center"><?php echo $versement_b->num_imp; ?></td> -->
                                    <td align="right" nowrap><?php echo number_format($versement_b->montant_r,0,","," "); ?></td>
                                    <td align="right" nowrap><?php echo number_format($versement_b->montant_c,0,","," "); ?></td>
                                    <td align="right" style="font-weight:bold;" class="text-primary" nowrap><?php echo number_format($versement_b->montant,0,","," "); ?></td>
                                    <td><?php echo $versement_b->banque_nom; ?></td>
                                    <td
                                        <?php echo (!$versement_b->CompteOK)?'class="bg-danger alert mark" style="color:red;text-weight:bold"':''; ?>>
                                        <?php echo $versement_b->compte; ?>

                                        <?php echo (!$versement_b->CompteOK)?' !!ANOMALIE!!':''; ?>

                                    </td>
                                    <td><?php echo $versement_b->obs_vers; ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
            <p>
                <div class='form-group form-horizontal'>
                    <?php if($type!=""): ?>
                        <div class="col-xs-3">
                                <a href="<?php echo url('versements_brouillon_print/'.$type); ?>"
                                    class="btn btn-info"  target="_blank">Imprimer le borderau</a>
                        </div>
                    <?php endif; ?>
                </div>
            </p>
        </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox.css')); ?>">
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox-buttons.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts0'); ?>
    <script src="<?php echo e(url('js/jquery.fancybox.js')); ?>"></script>
    <script src="<?php echo e(url('js/magicsuggest.js')); ?>"></script>

    <script>
      $(function () {
        $("#_table").DataTable({
          "paging": true,
          "lengthChange": false,
          "searching": true,
          "ordering": true,
          "info": true,
          "responsive": false,
          "autoWidth": false,
          "fixedHeader": true,
           oLanguage: {
                "sZeroRecords": "Aucune ligne",
                "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                "sInfoEmpty": "Showing 0 to 0 of 0 records",
                "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                    ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                    "sSearch":"Chercher",
                buttons: {
                    colvis: 'Colonnes à afficher',
                    copy: 'Copier',print: 'Imprimer',
                    copyTitle: 'Ajouté au presse-papiers',
                    copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                    copySuccess: {
                        _: '%d lignes copiées',
                        1: '1 ligne copiée'
                        }
                    }

            },
            dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",

            "buttons": ["copy", "excel", "colvis"] 
        })
        .buttons().container().appendTo('#_table_wrapper .col-md-6:eq(0)');

      });
    </script>


    <script>
        $("._box").fancybox({
            //fitToView   : true,
            width       : '85%',
            height      : '85%',
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/prestations/versements/index_brouillon.blade.php ENDPATH**/ ?>