<?php $__env->startSection('title'); ?> Banques <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card'); ?> Banques <?php $__env->stopSection(); ?>
<?php $__env->startSection('subtitle_card',""); ?>
<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header">
            <h1><i class="fa fa-employeurs"></i>Banques</h1>
        </div>
        <div class="card-body">
        <table id="_table" class="table table-condensed table-bordered">
            <thead>
                <tr>
                    <th>Nom</th>
                    <th>Agence</th>
                    <th>BIC</th>
                    <th>Ville</th>
                    <th>Tel1</th>
                    <th>Contact1</th>
                    <th>Tel2</th>
                    <th>Contact2</th>
                    <th>NbBenef</th>
                    <th>NbEmpl.</th>
                    <th>NbVers.</th>
                    <th width='1px'></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $banques; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banque): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>
                        <a href="<?php echo e(url('banques/'.$banque->id)); ?>" style="margin-right: 3px;">
                            <?php echo $banque->nom; ?>

                            <?php if(!$banque->active): ?>
                                <br/><span class="right badge badge-danger">Inactive</span>
                            <?php endif; ?>
                        </a>
                    </td>
                    <td nowrap><?php echo $banque->agence; ?></td>
                    <td nowrap><?php echo $banque->bic; ?></td>
                    <td nowrap><?php echo $banque->ville; ?></td>
                    <td nowrap><?php echo $banque->tel; ?></td>
                    <td nowrap><?php echo $banque->contact; ?></td>
                    <td nowrap><?php echo $banque->tel2; ?></td>
                    <td nowrap><?php echo $banque->contact2; ?></td>
                    <td nowrap align="center"><?php echo $banque->NbBeneficiaires; ?></td>
                    <td nowrap align="center"><?php echo $banque->NbEmployeurs; ?></td>
                    <td nowrap align="center"><?php echo $banque->NbVersements; ?></td>

                    <td nowrap>
                    <?php if($user->can("BQE_MAJ") || $user->HasRole("ADMINISTRATEUR")): ?>
                        <a href="<?php echo e(url('banques/'.$banque->id)); ?>" class="btn btn-warning pull-left" style="margin-right: 3px;"><span class=' fas fa-eye'></span></a>
                    <?php endif; ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php if($user->can("BQE_AJO") || $user->HasRole("ADMINISTRATEUR")): ?>
             <div>
                <h4><a href="<?php echo e(url('banques/create')); ?>" class="btn btn-success">Ajouter une banque</a></h4>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable_btn", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/tiers/banques/index.blade.php ENDPATH**/ ?>