

<?php $__env->startSection('title','Grand Livre'); ?>
<?php if(isset($view) && ($view=='transactions')): ?>
    <?php $__env->startSection('title_card',"Grand Livre - Vue par transaction"); ?>
<?php else: ?>
    <?php $__env->startSection('title_card',"Grand Livre - Vue par écritures"); ?>
<?php endif; ?>
<?php $__env->startSection('subtitle_card',"Liste complète"); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <?php if(Session::has('message')): ?>
            <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
        <?php endif; ?>

        <?php if($errors): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class='bg-danger alert'><?php echo $error; ?></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <?php if(Session::has('success')): ?>
            <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
        <?php endif; ?>  
        
        <div class="card-header">
            <div class="form-group row">
                <div class='col-md-4'>
                    <?php echo Form::label('jnx', 'Journal'); ?>

                    <?php echo Form::select('jnx',
                            $liste_journaux+["ALL"=>"Tous"],isset($jnx)?$jnx:"",
                                ['placeholder'=>'Tous','id'=>'jnx','class' => 'form-control']); ?> 
                </div>

                <div class='col-md-2'>
                    <?php echo Form::label('date_debut', 'Date de début'); ?>

                    <div class='input-group date' id='datepicker_date_debut'>
                    <?php echo Form::text('date_debut',isset($date_deb)?$date_deb:'01/01/'.date('Y'), 
                            ['id'=>'date_debut','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']); ?>

                        <span class='input-group-addon'>
                            <span class='glyphicon glyphicon-calendar'></span>
                        </span>
                    </div>
                </div>
                <div class='col-md-2'>
                    <?php echo Form::label('date_fin', 'Date de fin'); ?>

                    <div class='input-group date' id='datepicker_date_fin'>
                    <?php echo Form::text('date_fin',isset($date_fin)?$date_fin:'31/12/'.date('Y'), 
                            ['id'=>'date_fin','placeholder' => 'JJ/MM/AAAA', 'class' => 'form-control']); ?>

                        <span class='input-group-addon'>
                            <span class='glyphicon glyphicon-calendar'></span>
                        </span>
                    </div>
                </div>
                <div class='col-md-2 p-4' style="margin-top:5px" >
                    <a class="btn btn-<?php echo ($view=='transactions')?'info':'default'; ?>" href="#" onclick="valide('transactions')">
                        <i title="Transactions" class="fas fa-align-left"></i>
                    </a>
                    <a class="btn btn-<?php echo ($view=='ecritures')?'info':'default'; ?>" href="#" onclick="valide('ecritures')">
                        <i title="Ecritures" class="fas fa-align-justify"></i>
                    </a>
                </div>
                <div class='col-md-2 p-4' style="margin-top:5px" >
                    <a class="btn btn-primary"  href="#" onclick="valide()">Rechercher</a>
                </div>
            </div>

            <script>
                function valide(view="<?php echo $view; ?>") {
                    var select_jnx = [...document.getElementById('jnx').selectedOptions].map(option => option.value);
                    if(select_jnx=="") select_jnx=0;
                    var date_dep=document.getElementById('date_debut').value;
                    var date_fin=document.getElementById('date_fin').value;
                    var t_date_dep = date_dep.split('/');
                    date_dep= t_date_dep[2]+"-"+t_date_dep[1]+"-"+t_date_dep[0];
                    var t_date_fin = date_fin.split('/');
                    
                    date_fin= t_date_fin[2]+"-"+t_date_fin[1]+"-"+t_date_fin[0];
                    var url="<?php echo url('grand_livre_filtre/'); ?>/"+select_jnx+"/"+date_dep+"/"+date_fin+"/"+view ; 
                    location.href=url;
                }
            </script>
        </div>

        <div class="card-body">
            <?php if($user->hasRole("ADMINISTRATEUR") || $user->hasRole("COMPTABILITE") || $user->hasRole("CHEF_COMPTABILITE")): ?>
                <a title="Nouvelle transaction" href="<?php echo url('grand_livre/create'); ?>" class="btn  btn-sm btn-success">
                Nouvelle transaction</a> 
            <?php endif; ?> 

            <?php if(isset($view) && ($view=='transactions')): ?>
                <?php echo $__env->make("comptabilite.grandlivre.liste_transactions", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make("comptabilite.grandlivre.liste_ecritures", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable_btn", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script type="text/javascript">
    $(function () {
        $('#datepicker_date_debut').datepicker({
        format: "dd/mm/yyyy",language: "fr",autoclose: true
        });

        $('#datepicker_date_fin').datepicker({
        format: "dd/mm/yyyy",language: "fr",autoclose: true
        });
    });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp7422\htdocs\sysinfo\cpswf\sipre_new\resources\views/comptabilite/grandlivre/index.blade.php ENDPATH**/ ?>