<?php $__env->startSection('title'); ?> Versements <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',""); ?>
<?php $__env->startSection('subtitle_card',""); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>

    <div class="card">
        <div class="card-header bg-warning">
            <?php echo "Versement définitifs des ".$user->getTitreStatut($type); ?>

        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-2 mb-2">
                <?php echo html()->label("Numéro d'imprimé&nbsp;:&nbsp;",'brd'); ?>

                <?php echo html()->select('num_imp')->options($liste_num_imp)
                    ->value($num_imp)
                    ->placeholder('A définir')
                    ->attributes(['id' => 'num_imp','class' => 'form-control ','data-width' => "90%",'style' => 'font-weight:bold;']); ?>

                </div>
            </div>
            <?php if($type!=""): ?>
                <div class="row">
                    <div class="table-responsive">
                        <table id="_table" class="table table-condensed table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th width='1%'>N°</th>
                                    <th width='1%'>N°Emp</th>
                                    <th >Bénéficiaire</th>
                                    <th width='1%'>NbEnf<?php echo ($type!="RET")?" Considérés":""; ?></th>
                                    <th width='1%'>Naissance</th>
                                    <th width='1%'>Statut</th>
                                    <th width='1%'>Type</th>
                                    <?php if($type=="RET"): ?>
                                    <th width='1%'>RetType</th>
                                    <th width='1%'>RetDate</th>
                                    <th width='1%'>RetNum</th>
                                    <?php endif; ?>
                                    <!-- <th width='1%' nowrap>N°IMP</th> -->
                                    <th width='1%'>Rappel</th>
                                    <th width='1%'>Calcul</th>
                                    <th width='1%'>Montant</th>
                                    <th width='10%'>Banque</th>
                                    <th width='10%'>Compte</th>
                                    <th>Obs</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $versements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $versement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $beneficiaire=App\Models\Beneficiaire::find($versement->benum);
                                        $beneftype=substr($type,0,1);
                                    ?>
                                    <tr>
                                        <td style="color:grey"><?php echo $versement->benum; ?></td>
                                        <td style="color:grey"><?php echo $versement->sonum; ?></td>
                                        <td>
                                            <a href="<?php echo url('beneficiaires_filtre/'.$beneficiaire->id.'/'.$beneftype); ?>" target="_blank">
                                            <?php echo $versement->nom_beneficiaire." ".$versement->prenom_beneficiaire; ?>

                                            </a>
                                        </td>
                                        <td>
                                            <?php echo $versement->nb_enf.(($type=="RET")?"":"/".$beneficiaire->NbEnfants); ?>

                                        </td>
                                        <td><?php echo $versement->naissance_beneficiaire; ?></td>
                                        <td align="center"><?php echo $versement->statut_beneficiaire; ?></td>
                                        <td align="center"><?php echo $versement->type; ?></td>
                                        <?php if($type=="RET"): ?>
                                        <td align="center"><?php echo $versement->ret_type; ?></td>
                                        <td align="center"><?php echo $versement->ret_date; ?></td>
                                        <td align="center"><?php echo $versement->ret_num; ?></td>
                                        <?php endif; ?>
                                        <!-- <td align="center"><?php echo $versement->num_imp; ?></td> -->
                                        <td align="right" nowrap><?php echo number_format($versement->montant_r,0,","," "); ?></td>
                                        <td align="right" nowrap><?php echo number_format($versement->montant_c,0,","," "); ?></td>
                                        <td align="right" style="font-weight:bold;" class="bg-danger" nowrap><?php echo number_format($versement->montant,0,","," "); ?></td>
                                        <td><?php echo $versement->banque_nom; ?></td>
                                        <td><?php echo $versement->compte; ?></td>
                                        <td><?php echo $versement->obs_vers; ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <?php if($type!=""): ?>
            <div class="card-footer">
                 <div class="row">
                    <div class="col-md-2" >
                        <a href="<?php echo url('versements_print/'.$type.'/'.$num_imp); ?>" class="btn btn-primary"  target="_blank">Imprimer&nbsp;le&nbsp;borderau</a>
                    </div>
                    <?php if($user->can("RET_VER_EXP") || $user->can("ALL_VER_EXP") || $user->can("SOC_VER_EXP") || $user->HasRole("ADMINISTRATEUR")): ?>
                        <div class="col-md-2">
                            <a href="<?php echo url('versements_export_fichier_complet/'.$type.'/'.$num_imp); ?>" class="btn btn-warning"  target="_blank">Générer le fichier DFiP</a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox.css')); ?>">
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox-buttons.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts0'); ?>
    <script src="<?php echo e(url('js/jquery.fancybox.js')); ?>"></script>
    <script src="<?php echo e(url('js/magicsuggest.js')); ?>"></script>
    <?php echo $__env->make('forms.scripts_datatable_btn', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        $("._box").fancybox({
            //fitToView   : true,
            width       : '85%',
            height      : '85%',
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#num_imp').on('change', function() {
                location.href="<?php echo url('/versements/'.$type); ?>/"+$('#num_imp').val();
            });
        });
    </script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/prestations/versements/index_annee.blade.php ENDPATH**/ ?>