

<?php $__env->startSection('title','Transferts général'); ?>
<?php $__env->startSection('title_card',"Transferts en comptabilité"); ?>
<?php $__env->startSection('subtitle_card',""); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">

        <?php if(Session::has('message')): ?>
            <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
        <?php endif; ?>

        <?php if($errors): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class='bg-danger alert'><?php echo $error; ?></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        <?php if(Session::has('success')): ?>
            <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
        <?php endif; ?>  

        <?php echo Form::open(['class' => 'form-horizontal', 'url' => 'transfert_valide']); ?>

            <?php echo Form::hidden('type', $type); ?>

            <?php echo Form::hidden('list_check','',['id' => 'list_check'] ); ?>

            <div class="card-body">
                <div class="form-group row">
                    <div class='col-md-4'>
                        <?php echo Form::label('type_pieces', 'Type de pièces'); ?>

                        <?php echo Form::select('type_pieces',
                                array(""=>"Choisissez le type de pièce")+$liste_types,$type,
                                    ['class' => 'form-control','onchange' => 'select_filtre()']); ?> 
                    </div>
                </div>
                <script>
                    function select_filtre() {
                        var select_type = [...document.getElementById('type_pieces').selectedOptions].map(option => option.value);
                        if(select_type=="") select_type=0;
                        var url="<?php echo url('transferts_type/'); ?>/"+select_type ; 
                        location.href=url;
                    }
                </script>
            

                <div class="form-group row">
                    <div class='col-md-12'>
                        <?php if($type=="RG"): ?>
                            <?php echo $__env->make("comptabilite.transferts.liste_reglements", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                        <?php if($type=="FA"): ?>
                            <?php echo $__env->make("comptabilite.transferts.liste_factures", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                        <?php if($type=="SA"): ?>
                            <?php echo $__env->make("comptabilite.transferts.liste_salaires", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>
                        <?php if($type=="PM"): ?>
                            <?php echo $__env->make("comptabilite.transferts.liste_paiements", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        <?php echo Form::close(); ?>

    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
<script>
        $(function () {
            $("#_table").DataTable({
              "paging": false,
              "lengthChange": false,
              "searching": true,
              "ordering": true,
              "info": false,
              "responsive": false, 
              "autoWidth": false,
               oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                    "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                        ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                        "sSearch":"Chercher",
            buttons: {
                colvis: 'Colonnes à afficher',
                copy: 'Copier',print: 'Imprimer',
                copyTitle: 'Ajouté au presse-papiers',
                copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                copySuccess: {
                    _: '%d lignes copiées',
                    1: '1 ligne copiée'
                    }
                }

                },
                        dom: "<'row'<'col-sm-6'l><'col-sm-6'f>>" + "<'row'<'col-sm-12'tr>>" + "<'row'<'col-sm-4'i><'col-sm-4'B><'col-sm-4'p>>",
"buttons": ["copy", "excel", "colvis"], //"print", "pdf", "csv", 
                "aaSorting": [
                    [1,'asc']
                ],
                "columnDefs": [
                    { "targets": [ 0], "orderable": false,"searchable": false}, 
                ],
            })
        });    

        function select_all() {
            var lst="";
            var t_lignes=<?php echo json_encode($t_lignes); ?>;
            var check=$('#box_all').prop('checked');
            if(check) check="checked";
            for(var i=0;i<t_lignes.length;i++) {
                $('#box_'+t_lignes[i].id).prop("checked",check);
                var checkbox=$('#box_'+t_lignes[i].id).prop('checked');
                if(checkbox) {
                    lst+=((lst=="")?"":";")+t_lignes[i].id;
                }
            }
            set_list(lst);
        }

        function calcul_select() {
            var t_lignes=<?php echo json_encode($t_lignes); ?>;
            var lst="";
            for(var i=0;i<t_lignes.length;i++) {
                var check=$('#box_'+t_lignes[i].id).prop('checked');
                if(check) {
                    lst+=((lst=="")?"":";")+t_lignes[i].id;
                }
            }
            set_list(lst);
        }

        function set_list(lst="") {
            $('#list_check').val(lst);

            var nt_lst=lst.split(";");
            var nb = nt_lst.length;
        }

        function init_list() {
            var lst=$('#list_check').val();
            var nt_lst=lst.split(";");
            for(var i=0;i<nt_lst.length;i++) {
                $('#box_'+nt_lst[i]).prop('checked',true);
            }
            set_list(lst);
        }

        init_list();
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre_new\resources\views/comptabilite/transferts/index.blade.php ENDPATH**/ ?>