<?php $__env->startSection('title'); ?> Bénéficiaires <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',"Bénéficiaires"); ?>
<?php $__env->startSection('subtitle_card',"Liste"); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>


    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-md-5">
                    <?php echo html()->label( 'Avec le statut :',''); ?>

                    <?php echo html()->select('select_benef_type',$liste_beneftype,$select_benef_type)->attributes(['id' => 'select_benef_type','class' => 'form-control']); ?>

                </div>
                <?php if($user->can("BEN_AJO") || $user->HasRole("ADMINISTRATEUR")): ?>
                    <div class="col-md-5 ">
                        <?php echo html()->label( '&nbsp;',''); ?><br/>
                        <?php echo html()->a(url('beneficiaires_add/'.$benef_type),"Ajouter un bénéficiaire")->attributes(['class' => 'btn btn-success']); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="card-body">
            <table id="_table" style="background-color:white;width:100%" class="table table-striped table-bordered table-hover">
                <thead>
                    <tr>
                        <th width='1px'>Id</th>
                        <th >Nom</th>
                        <th width='1px'>Date de naissance</th>
                        <th width='1px'>NbEnf.</th>
                        <th >Conjoint</th>
                        <th >Employeur</th>
                        <th >Montant Ret.</th>
                        <th >Montant CSR</th>
                        <th width='1px'>Statut</th>
                        <th width='1px'>Création</th>
                        <?php if($benef_type=="A"): ?>
                            <th width='1px'>AyantDroit</th>
                            <?php endif; ?>
                        <?php if($benef_type=="RET"): ?>
                            <th width='1px'>TypeRet</th>
                        <?php endif; ?>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $beneficiaires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $beneficiaire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo str_pad($beneficiaire->id, 5, "0", STR_PAD_LEFT); ?></td>
                            <td>
                                <a href="<?php echo url('beneficiaires_filtre/'.$beneficiaire->id.'/'.$benef_type); ?>">
                                    <?php echo $beneficiaire->nom_complet; ?>

                                </a>
                            </td>
                            <td><?php echo $beneficiaire->datenaiss; ?></td>
                            <td align="center"><?php echo $beneficiaire->nb_enf."/".$beneficiaire->nb_enf_tot; ?></td>
                            <td><?php echo $beneficiaire->nom_conjoint; ?></td>
                            <td><?php echo $beneficiaire->employeur_court; ?></td>
                            <td align="center"><?php echo $beneficiaire->ret_montant; ?></td>
                            <td align="center"><?php echo $beneficiaire->csr_montant; ?></td>
                            <td align="center"><?php echo $beneficiaire->statut; ?></td>
                            <td align="center" title="<?php echo $beneficiaire->created_at; ?>"><?php echo substr($beneficiaire->created_at,0,10); ?></td>
                            <?php if($benef_type=="A"): ?>
                            <td align="center"><?php echo ($beneficiaire->ayantdroit)?"OUI":"NON"; ?></td>
                            <?php endif; ?>
                            <?php if($benef_type=="RET"): ?>
                                <td align="center"><?php echo $beneficiaire->ret_type; ?></td>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {
            $('#select_benef_type').change(function() {select_filtre();});

            function select_filtre() {
                var opt=$('#select_benef_type').val();
                if(opt=="") opt=0;
                url="<?php echo url('beneficiaires_liste/'.$benef_type); ?>/"+opt;
                location.href=url;
            }
        });
    </script>

    <?php echo $__env->make("forms.scripts_datatable_btn", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/tiers/beneficiaires/index.blade.php ENDPATH**/ ?>