<?php $__env->startSection('title'); ?> Salaires <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',"Emplois/Salaires"); ?>
<?php $__env->startSection('subtitle_card',"Liste"); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>

    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>

    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>


    <div class="card">
        <div class="card-header">
            <h3 style="margin-top:0px;">Salaires<small><?php echo substr($employeur_nom,strpos($employeur_nom,' ')); ?></small><h3>
        </div>
        
            <div class="card-body">
                <div class='row form-group '>
                    <div class="col-md-4">
                        <?php echo html()->hidden('employeur_id2', $employeur_id)->attributes(['id'  => 'employeur_id2']); ?>

                        <?php echo html()->label('Employeur :','employeur_nom' ); ?>

                        <?php echo html()->text('employeur_nom', $employeur_nom)->placeholder('Employeur')->attributes(['class' => 'form-control', 'id' => 'employeur_nom']); ?>


                    </div>

                    <div class="col-md-2">
                        <?php echo html()->label('Année :','annes' ); ?>

                        <?php echo html()->select('exercice')->options($exercices)
                            ->value($exercice)
                            ->placeholder('Choisir une Année')
                            ->attributes(['id' => 'exercice_id','class' => 'form-control selectpicker','data-width' => "100%",'style' => 'font-weight:bold;']); ?>

                    </div>

                    <?php if($employeur_id!=""): ?>
                        <div class="col-md-6">
                            <?php echo html()->label('Employé :','employe_nom' ); ?>

                            <?php echo html()->select('beneficiaire_id')->options($liste_employes,$beneficiaire_id)
                                ->placeholder('Choisir un employé')
                                ->attributes(['id' => 'beneficiaire_id2','class' => 'form-control selectpicker','data-width' => "100%",'style' => 'font-weight:bold;']); ?>

                        </div>
                    <?php endif; ?>
                </div>

                <div class='row form-group '>
                    <a title="Historique des modifications"  href="<?php echo url('log_salaires/'.$exercice.'/'.$employeur_id); ?> "
                    class="btn btn-info box_log fancybox.iframe">Journal des modifications</a>
                    <?php if($beneficiaire_id>0): ?>
                        &nbsp;<a href="<?php echo url('/attestation_edition/'.$beneficiaire_id.'/E/att_revenu'); ?>"
                            class="btn btn-warning" target="_blank">Attestation de déclaration</a>

                        <?php if($user->can("SAL_EDIT") || $user->HasRole("ADMINISTRATEUR")): ?>
                            &nbsp;<a href="<?php echo url('salaire_liquidation/'.$beneficiaire_id); ?>"
                                class="btn btn-warning" target="_blank">Edition des liquidations</a>
                            <!--
                            <a href="<?php echo url('/salaire/liquidation_simulation/'.$beneficiaire_id); ?>"
                                class="btn btn-warning" target="_blank">Edition d'une Simulation de liquidation</a>
                            -->
                        <?php endif; ?>

                        <?php if($user->can("SAL_AJO") || $user->HasRole("ADMINISTRATEUR")): ?>
                            &nbsp;<a href="<?php echo url('salaires/create/'.$beneficiaire_id.'/'.$employeur_id); ?>"
                                title="Ajouter un salaire" class="btn btn-success">
                                    Ajouter un Salaire pour <?php echo e($beneficiaire->NomComplet); ?>

                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
                <?php if($employeur_id): ?>
                <div class="table-responsive">
                    <table id="_table" style="" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1px'>N°</th>
                                <th >Employé</th>
                                <th width='1px'>DateNais.</th>
                                <th width='1px'>Année</th>
                                <th width='1px'>DateEnt.</th>
                                <th width='1px'>DateSor</th>
                                <?php if($employeur_nom=="TOUS"): ?>
                                    <th >N°Emp.</th>
                                    <th >Employeur</th>
                                <?php endif; ?>

                                <?php $__currentLoopData = $t_mois; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <th class="sum" width='1px'><?php echo $mois; ?></th>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <th width='1px'>Total</th>
                                <th width='1px'>Der.Modif.</th>
                            </tr>
                        </thead>

                        <tfoot>
                            <tr class='' style='background-color:#E6E6FA;font-weight:bold'>
                                <th colspan="<?php echo ($employeur_nom=='TOUS')?'8':'6'; ?>">TOTAL</th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                                <th class="sum"></th>
                            </tr>
                        </tfoot>
                        <tfoot>
                            <tr class='' style='background-color:#F0FFF0;font-weight:bold'>
                                <td colspan="<?php echo ($employeur_nom=='TOUS')?'8':'6'; ?>"></td>
                                <?php $__currentLoopData = $nb_salaire; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois=>$nb): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td align="center" style="<?php echo ($mois=='total')?'font-weight:bold':''; ?>"><?php echo $nb; ?></td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <td class=""></td>
                            </tr>
                        </tfoot>
                        <tbody>
                            <?php $__currentLoopData = $salaires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salaire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $color_histo="default";$lib_update="Modifié il y a plus de 3 mois";
                                    $diff=App\Models\MyApp::getNbjDate($salaire->updated_at,date('Y-m-d'));
                                    if($diff<90) {$color_histo="info";$lib_update='Modifié dans les 3 mois';}
                                    if($diff<60) {$color_histo="warning";$lib_update='Modifié dans les 2 mois';}
                                    if($diff<30) {$color_histo="danger";$lib_update='Modifié dans le mois';}
                                ?>
                                <tr>
                                    <td>
                                        <?php if($user->can("SAL_MAJ") || $user->HasRole("ADMINISTRATEUR")): ?>
                                            <a href="<?php echo url('salaires/'.$salaire->id ); ?>" class="btn btn-info">
                                                <?php echo $salaire->benum; ?>

                                            </a>
                                        <?php else: ?>
                                            <?php echo $salaire->benum; ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="<?php echo url('beneficiaires_filtre/'.$salaire->benum.'/V'); ?>" target='_blank'>
                                            <?php echo $salaire->beneficiaire_Nom; ?>

                                        </a>
                                    </td>
                                    <td nowrap><?php echo $salaire->BeneficiaireDateNaissance; ?></td>
                                    <td nowrap align='center'><?php echo $salaire->annee; ?></td>
                                    <td nowrap><?php echo $salaire->dat_ent; ?></td>
                                    <td nowrap><?php echo $salaire->date_sor; ?></td>
                                    <?php if($employeur_nom=="TOUS"): ?>
                                        <td nowrap><?php echo str_pad($salaire->sonum, 6, "0", STR_PAD_LEFT); ?></td>
                                        <td><?php echo $salaire->employeur_nom; ?></td>
                                    <?php endif; ?>

                                    <?php $__currentLoopData = $t_mois; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $horsplafond=$salaire->getIsHorsPlafond($mois);
                                            $montant_salaire=$salaire->{$mois};
                                            $style="";
                                            if($horsplafond) $style.="color:red;";
                                            if($salaire->getSuspendu($mois)) {
                                                $style.="background-color:darkgrey;font-size:.9em";
                                                $montant_salaire="SUSPENDU";
                                            }
                                        ?>
                                        <td nowrap align='right' style='<?php echo $style; ?>'>
                                            <?php echo $montant_salaire; ?>

                                        </td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <td nowrap align='right'><?php echo $salaire->TotalAnnee; ?></td>
                                    <td nowrap align='right'>
                                        <a title="<?php echo $lib_update; ?>" href="<?php echo url('log_salaires/'.$salaire->id); ?> "
                                            class="btn bt-sm btn-<?php echo $color_histo; ?> box_log fancybox.iframe">
                                        <?php echo $salaire->updated_at; ?></a>
                                    </td>

                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox.css')); ?>">
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox-buttons.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(url('js/jquery.fancybox.js')); ?>"></script>
    <!-- source: "../autocomplete_employeur", -->
    <script>
        $(document).ready(function() {
            $("#employeur_nom").autocomplete({
                source: "<?php echo route('autocomplete_employeur'); ?>",
                minLength: 1,
                select: function(event, ui) {
                    var uid_=ui.item.id;
                    var value_=ui.item.value
                    if(value_=='TOUS') uid_="999999";
                    $('#employeur_nom').val(uid_+" "+(value_.trim()));
                    $('#employeur_id2').val(uid_);
                    location.href="<?php echo url('/salaire_annee/'); ?>/"+$('#employeur_id2').val()+"/0"+"/0";
                },
                close: function(event, ui) {

                }
            });

            $('#exercice_id').on('change', function() {
                var id_benef=$('#beneficiaire_id2').val();
                if(id_benef=="") id_benef=0;
                location.href="<?php echo url('/salaire_annee/'); ?>/"
                    +$('#employeur_id2').val()+"/"+id_benef+"/"+$('#exercice_id').val();
            });

            $('#beneficiaire_id2').on('change', function() {
                var id_benef=$('#beneficiaire_id2').val();
                if(id_benef=="") id_benef=0;
                location.href="<?php echo url('/salaire_annee/'); ?>/"
                    +$('#employeur_id2').val()+"/"+id_benef+"/"+$('#exercice_id').val();;
            });
        });

        $(document).ready(function() {
            $(".box_log").fancybox({
                width:'80%',
                autoDimensions:false,
                fitToView   : false,
                autoSize    : false,
                closeClick  : true,
                openEffect  : 'fade',
                closeEffect : 'fade',
                afterLoad: function () {

                },
                afterClose: function () {
                    return;
                }
            })
            /*
            $(".box_liquidation").fancybox({
                //width:'80%',
                autoDimensions:true,
                fitToView   : false,
                autoSize    : true,
                closeClick  : true,
                openEffect  : 'fade',
                closeEffect : 'fade',
                afterLoad: function () {

                },
                afterClose: function () {
                    return;
                }
            })
            */
            $.fn.dataTable.moment('D/M/YYYY');

            var table =$('#_table').dataTable( {
                bAutoWidth: false,
                bPaginate: false,
                bInfo: true,
                bFilter: true,
                        scrollY:        400,
                        scrollX:        '100%',
                        scrollCollapse: true,
                        scroller:       true,

                oLanguage: {
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                    "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                        ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                        "sSearch":"Chercher ",
                    buttons: {
                        colvis: 'Colonnes à afficher',
                        copy: 'Copier',print: 'Imprimer',
                        copyTitle: 'Ajouté au presse-papiers',
                        copyKeys: 'Appuyez sur <i>ctrl</i> ou <i>\u2318</i> + <i>C</i> pour copier les données du tableau à votre presse-papiers. <br><br>Pour annuler, cliquez sur ce message ou appuyez sur Echap.',
                        copySuccess: {
                            _: '%d lignes copiées',
                            1: '1 ligne copiée'
                            }
                        }

                    },

                    //"dom": '<"top"fBl>rt<"bottom"ip><"clear">',
                    dom: "<'row'<'col-sm-3 text-left'><'col-sm-4'><'col-sm-5 text-center'f>>" +
                    "<'row'<'col-sm-12'tr>>" +"<'row'<'col-sm-5'i><'col-sm-7'B>>",

                    "aaSorting": [
                        [1,'asc']
                    ],

                    buttons: [
                        {extend: 'copy',exportOptions: {columns: ':visible'} },
                        {extend: 'excel',exportOptions: {columns: ':visible'} },
                        'colvis'
                    ],


                    "footerCallback": function(row, data, start, end, display) {
                    var api = this.api();
                        <?php if($employeur_nom=="TOUS"): ?>
                            api.columns([8,9,10,11,12,13,14,15,16,17,18,19,20], { //
                        <?php else: ?>
                            api.columns([6,7,8,9,10,11,12,13,14,15,16,17,18], { //
                        <?php endif; ?>
                        page: 'current'
                    }).every(function() {
                        var sum = this
                        .data()
                        .reduce(function(a, b) {
                            var x = parseFloat(a) || 0;
                            var y = parseFloat(b) || 0;
                            return x + y;
                        }, 0);
                        $(this.footer()).html(sum);
                    });
                    },



                } );

                $('#_table').DataTable().draw();

                $(window).resize(function () {
                            $('#_table').DataTable().draw();
                });
        } );
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre2\resources\views/recouvrement/salaires/index.blade.php ENDPATH**/ ?>