<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\BeneficiaireBanque;;
use App\Models\Controle;
use App\Models\Salaire;
use App\Models\User;
use App\Models\Role2;
use App\Models\MyApp;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\ControleRequest;
use App\Http\Requests\AutoResponsableRequest;
use Request;
use Response;


class AnalysesController extends Controller {
 
 
    /**
     * Liste des controles
     */
    public function index_benef_doublons($employeur_id=0)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        //$beneficiaires=Beneficiaire::

        $dates_naissance = array();
        $sql="SELECT COUNT(datenaiss) AS nbr_doublon, datenaiss FROM beneficiaires 
            GROUP BY datenaiss 
            HAVING COUNT(datenaiss) > 1 
            ORDER BY datenaiss DESC ";

        $search = DB::select($sql);
        foreach ($search as $result) {
            $dates_naissance[] = $result->datenaiss;
        }

        $beneficiaires=Beneficiaire::wherein('datenaiss',$dates_naissance)->get();

        return View::make('analyses.index_benef_doublons', [ 
            'user' => $user,
            'beneficiaires' => $beneficiaires,
            
        ]);
    }


    public function index_histo_rib($employeur_id=0)
    {
        $user=User::where('id','=',Session::get('id'))->first();

        $beneficiairesbanques=BeneficiaireBanque::orderby('id','DESC')->get();

        return View::make('analyses.index_benef_banques', [ 
            'user' => $user,
            'beneficiairesbanques' => $beneficiairesbanques,
            
        ]);
    }



    public function index_salaires($annee="")
    {
        $user=User::where('id','=',Session::get('id'))->first();

        if($annee=="") $annee=Date('Y');

        $annees = MyApp::getListeExercices(); 
        $salaires=[];
        $t_mois=[0=>"jan",1=>"fev",2=>"mar",3=>"avr",4=>"mai",5=>"jun",6=>"jui",7=>"aou",8=>"sep",9=>"oct",10=>"nov",11=>"dec"];
        $all_salaires=Salaire::where('annee','=',$annee)->orderby('id','DESC')->get();
        foreach($all_salaires as $salaire) {
            foreach($t_mois as $mois) {
                $horsplafond=$salaire->getIsHorsPlafond($mois);
                if($horsplafond) $salaires[]=$salaire;
            }
        }

        return View::make('analyses.index_salaires', [ 
            'user' => $user,
            'annee' => $annee,
            't_mois' => $t_mois,
            'salaires' => $salaires,'annees' => $annees,
            
        ]);
    }
 

}