<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Banque;
use App\Models\Beneficiaire;
use App\Models\User;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\BanqueRequest;
use App\Http\Requests\AutoResponsableRequest;
use Request;
use Response;


class BanquesController extends Controller {
 
    /**
     * Display a listing of the user.
     *
     * @return Response
     */
    public function index($param="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $banques = Banque::all();
        return View::make('tiers.banques.index', ['banques' => $banques, 'user'=>$user]);
    }
 
    /**
     * Show the form for creating a new user.
     *
     * @return Response
     */
    public function create()
    {
        return View::make('tiers.banques.create', []);
    }
 
    /**
     * Store a newly created user in storage.
     *
     * @return Response
     */
    public function store(BanqueRequest $request)
    {
        $banque = new Banque;
        $banque->nom = $request->nom;
        $banque->adresse = $request->adresse;
        $banque->cp = $request->cp;
        $banque->ville = $request->ville;
        $banque->tel = $request->tel;
        $banque->fax = $request->fax;
        $banque->email = $request->email;
        $banque->contact = $request->contact;
        $banque->bic = $request->bic;
        $banque->contact2 = $request->contact2;
        $banque->tel2 = $request->tel2;
        $banque->agence = $request->agence;
        $banque->save();
        return Redirect::to('/tiers/banques');
    }
 
    /**
     * Show the form for editing the specified user.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $ile="";
        $banque = Banque::find($id);
        return View::make('tiers.banques.edit', [ 'banque'=> $banque]);
    }
 
    /*
     * Update the specified user in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id,BanqueRequest $request)
    {
        $banque = Banque::find($id);
        $banque->nom = $request->nom;
        $banque->adresse = $request->adresse;
        $banque->cp = $request->cp;
        $banque->ville = $request->ville;
        $banque->tel = $request->tel;
        $banque->fax = $request->fax;
        $banque->email = $request->email;
        $banque->contact = $request->contact;
        $banque->agence = $request->agence;
        $banque->bic = $request->bic;
        $banque->contact2 = $request->contact2;
        $banque->tel2 = $request->tel2;        
        $banque->active = ($request->active=='on');
        $banque->save();

        return Redirect::to('/tiers/banques');
    }
 
    /**
     * Remove the specified user from storage.
     */
    public function destroy($id)
    {
        $bq=Banque::find($id);
        if($bq->actif) Banque::destroy($id);
        return Redirect::to('/tiers/banques');
    }


    public function autocomplete_banque(Request $request)
    {       
        $param = trim($request->input('term'));
        $associate = array();
        $sql="select id as id,CONCAT(id,' ',TRIM(nom)) as value from banques
            where nom like ('%{$param}%') or id like ('%{$param}%') ";
        $search = DB::select($sql);
        foreach ($search as $result) {
            $associate[] = $result;
        }

        return json_encode($associate);
        
    }

}