<?php namespace App\Http\Controllers;


use App\Models\Beneficiaire;
use App\Models\BeneficiaireBanque;
use App\Models\User;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\BeneficiaireRequest;
use App\Http\Requests\BeneficiaireAutoRequest;
use App\Http\Requests\BeneficiaireListeRequest;
use App\Http\Requests\AutoResponsableRequest;
use Request;
use Response;
use App\Models\Beneftype;
use App\Models\Benefstatut;
use App\Models\Employeur;
use App\Models\Enfant;
use App\Models\Salaire;
use App\Models\Versement;
use App\Models\Parametre;
use App\Http\Controllers\Logs;


class BeneficiairesController extends Controller {
 

    public function __construct()
    {
        if(!Session::get('id')) return Redirect::route( 'login' );
        //$this->middleware('auth');
    }

    /**
     * Display a listing of the user.
     *
     * @return Response
     */
    public function index($benef_type="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $csr=false;
        

        if(!$user) return;
        $statut_def=DB::table('model_has_roles')->join('roles','roles.id','=','role_id')
            ->where('model_has_roles.model_id','=',$user->id)->value('roles.benef_statut');
            
        if(($statut_def=="-")||($statut_def=="")) $statut_def="A";

        $liste_beneftype=Beneftype::orderby('libelle')->select("libelle", "ref")->get()->pluck("libelle", "ref")->toArray();

        $liste_beneftype["*"]="Tous";
        if($benef_type=="") $benef_type=$statut_def;
        if(!isset($liste_beneftype[$benef_type])) $benef_type=$statut_def; 

        $titre2=substr($liste_beneftype[$benef_type],0,strpos($liste_beneftype[$benef_type],' (')); 

        $filtre=Beneftype::where('ref','=',$benef_type)->value('statuts');  

        $t_filtre=explode(';',$filtre); 
        if($benef_type=="*") {
                $beneficiaires = Beneficiaire::orderBy('nom')->orderBy('prenom')->get();
        } else {
            if(count($t_filtre)>0) {
                $beneficiaires = Beneficiaire::whereIn('statut', $t_filtre)
                    ->orderBy('nom','ASC')->orderBy('prenom','ASC')->get();
                
            } else {
                $titre2.=" Tous";
                $beneficiaires = Beneficiaire::where('id', '<>', 'null')
                    ->orderBy('nom')->orderBy('prenom')->get();
            }
        }


        return View::make('tiers.beneficiaires.index', ['beneficiaires' => $beneficiaires
            , "liste_beneftype" =>  $liste_beneftype
            , 'user'=>$user, 'titre2' => $titre2, 'benef_type' => $benef_type]);
    }
 

      /**
     * Ouvre la liste filtrée
     */
   public function show($id,$type_liste="")
    {
        
        $user=User::where('id','=',Session::get('id'))->first();
        $enfants=array();
        $salaires=array();
        $versements=array();
        $liste_benefstatut=array();
        $liste_employeur=array(""=>"");
        $nom_conjoint="";
        $beneficiaire = Beneficiaire::find($id);

        $liste_benefstatut=Benefstatut::orderby('libelle')->get()->pluck("libelle", "ref")->toArray();
        $employeurs=Employeur::orderby('nom')->get()->pluck("nom", "id")->toArray();
        foreach($employeurs as $employeur_id=>$nom) $liste_employeur[$employeur_id]=$nom;

        $enfants = Enfant::Where('parents1','=',$beneficiaire->id)
            ->orWhere('parents2','=',$beneficiaire->id)
            ->orderby('datenais','DESC')->get();

        if(!isset($enfants)) $enfants=array();
        $salaires = Salaire::where('benum','=',$id)->orderBy('annee','DESC')->get();

        $versements = Versement::where('benum','=',$id)->orderBy('date','DESC')->get();

        //pour surgligner les meilleurs salaires
        $nb_meilleurs=Parametre::where('ref','=','CAL_PRET_NBMOIS')->first()->value;

        $t_salaires_ref=$beneficiaire->getRefMeilleursSalaires($nb_meilleurs);
        //Banque
        $beneficiaire_banque=$beneficiaire->getLastCompte();

        return View::make('tiers.beneficiaires.show', [ 'user'=>$user,
            'enfants'=>$enfants,
            'liste_employeur'=>$liste_employeur,
            'liste_benefstatut'=>$liste_benefstatut, 
            'beneficiaire' => $beneficiaire , 
            'nom_conjoint' => $nom_conjoint, 
            'salaires' => $salaires,
            't_salaires_ref' => $t_salaires_ref,
            'versements' => $versements,
            'type_liste' => $type_liste,
            'beneficiaire_banque' => $beneficiaire_banque
            ]);
    }

   public function show_s($id,$type_liste="")
    {
        return $this->show($id,$type_liste);
    }


    public function create(BeneficiaireListeRequest $request)
    {
        $type_liste=$request->lst;
        $nom_conjoint="";
        $liste_benefstatut=Benefstatut::orderby('libelle')->get()->pluck("libelle", "ref")->toArray();
        $liste_employeur=array(""=>"");

        return View::make('tiers.beneficiaires.create', [ 
            'liste_employeur'=>$liste_employeur,
            'liste_benefstatut'=>$liste_benefstatut,
            'type_liste' => $type_liste]);
    }
 

    public function store(BeneficiaireRequest $request)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $nom  = strtoupper($request->nom);
        $prenom  = ($request->prenom);
        $date=$request->datenaiss;
        $date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;

        $benef_exist=Beneficiaire::where('nom','=',$nom)->where('datenaiss','=',$date)->first();
        $t_error=array();
        if( ($benef_exist) && (!$user->can("BEN_DBL")) ) {
            $t_error['doublon']="Ce bénéficiaire existe déjà sous le numéro :".$benef_exist->id;
        }
        if (count($t_error)>0) {
            //Session::flash('nom_compte2', $plan2->nomcpt);
            return redirect()->back()
                ->withInput()
                ->withErrors($t_error);
        }
        $beneficiaire = new Beneficiaire;
        $beneficiaire->nom  = strtoupper($request->nom);
        $beneficiaire->prenom  = ($request->prenom);
        $beneficiaire->sonum = $request->sonum;
        $beneficiaire->n_all = $request->n_all;
        $date=$request->datenaiss;
        $beneficiaire->datenaiss = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $date=$request->date_deces;
        $beneficiaire->date_deces = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        
        $beneficiaire->lieunaiss = $request->lieunaiss;
        $beneficiaire->adresse = $request->adresse;
        $beneficiaire->district = $request->district;
        $beneficiaire->ile = $request->ile;
        $beneficiaire->tel = $request->tel;
        $beneficiaire->fax = $request->fax;
        $beneficiaire->email = $request->email;
        $beneficiaire->nb_enf = $request->nb_enf;
        $beneficiaire->nb_enf_tot = $request->nb_enf_tot;
        $beneficiaire->obs = $request->obs;
        //$beneficiaire->compte = $request->compte;

        $beneficiaire->mt_allloc = $request->mt_allloc;
        $beneficiaire->mt_calc = $request->mt_calc;
        $beneficiaire->statut = $request->statut;
        $beneficiaire->verrou = ($request->verrou=='')?0:1;
        $date=$request->ret_dateed;
        $beneficiaire->ret_dateed = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $beneficiaire->rappel = $request->rappel;
        $beneficiaire->ret_numdec = $request->ret_numdec;
        $beneficiaire->ret_montant = $request->ret_montant;
        $beneficiaire->ret_type = $request->ret_type; 
        $beneficiaire->ret_rappel = $request->ret_rappel;
        //$beneficiaire->csr_montant=$request->csr_montant;
        $beneficiaire->csr_rappel=$request->csr_rappel;
        $beneficiaire->conjoint = $request->conjoint; 
        $date=$request->date_pi;
        $beneficiaire->date_pi = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $beneficiaire->civilite = $request->civilite;               
        $beneficiaire->code_postal = $request->code_postal;                                                                                                        
        $beneficiaire->obs_vers = $request->obs_vers;
        //Champ à virer
        //$beneficiaire->nom_conj = $request->nom_conj; 
        //$beneficiaire->prenom_conj = $request->prenom_conj;
        //$beneficiaire->cle_nompre_dat = $request->nom.",".$request->prenom.",".(($request->datenaiss!="")?date('Ymd', strtotime(str_replace('/', '-', $request->datenaiss))):"") ; 
        $beneficiaire->save();

        //LOG de la transaction
        $beneficiaire->log_transaction('','I');


        /* *** Gestion du RIB *** */
        $t_compte_champs=["banque_id","IBAN_pays","IBAN_cle","IBAN_banque","IBAN_guichet","IBAN_compte","IBAN_clerib"];
        //Si il a changé
        $beneficiaire_banque=$beneficiaire->getLastCompte();
        $addcompte=false;
        foreach($t_compte_champs as $champ) {
            if($request->{$champ}!="") {$addcompte=true;break;}
        }

        if($request->banque_id!="") $addcompte=true;
        if( $addcompte) { //SI changement ou pas de banque
            //création du nouveau compte
            $beneficiaire_banque = new BeneficiaireBanque;
            foreach($t_compte_champs as $champ) $beneficiaire_banque->{$champ} = $request->{$champ};
            $beneficiaire_banque->id_benef=$beneficiaire->id;
            $beneficiaire_banque->infomodif="00";
            $beneficiaire_banque->actif='1';
            $beneficiaire_banque->id_user=$user->id;
            $beneficiaire_banque->date=date('Y-m-j h:i:s');
            $beneficiaire_banque->save();
            $beneficiaire_banque->log_transaction($request->url(),'I');
        }
        /* *** Fin de Gestion du RIB *** */
        

        if($request->type_liste!="")  return Redirect::to('/tiers/beneficiaires/limit/'.$request->type_liste);
        return Redirect::to('/tiers/beneficiaires');
    }
 

    public function edit($id,$type_liste="",$onglet_actif="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $enfants=array();
        $salaires=array();
        $versements=array();
        $liste_benefstatut=array();
        $liste_employeur=array(""=>"");       
        $nom_conjoint="";
        $beneficiaire = Beneficiaire::find($id);

        $liste_benefstatut=Benefstatut::orderby('libelle')->get()->pluck("libelle", "ref")->toArray();
        $employeurs=Employeur::orderby('nom')->get()->pluck("nom", "id")->toArray();

        foreach($employeurs as $employeur_id=>$nom) $liste_employeur[$employeur_id]=$nom;

        $enfants = Enfant::Where('parents1','=',$beneficiaire->id)
            ->orWhere('parents2','=',$beneficiaire->id)
            ->orderby('datenais','DESC')->get();

        if(!isset($enfants)) $enfants=array();
        $salaires = Salaire::where('benum','=',$id)->orderBy('annee','DESC')->get();

        $versements = Versement::where('benum','=',$id)->orderBy('date','DESC')->get();
        //Banque
        $beneficiaire_banque=$beneficiaire->getLastCompte();

        return View::make('tiers.beneficiaires.edit', [ 'user'=>$user,
            'enfants'=>$enfants,
            'liste_employeur'=>$liste_employeur,
            'liste_benefstatut'=>$liste_benefstatut, 
            'beneficiaire' => $beneficiaire , 
            'nom_conjoint' => $nom_conjoint, 
            'type_liste' => $type_liste,
            'onglet_actif' => $onglet_actif,
            'salaires' => $salaires,
            'versements' => $versements,
            'beneficiaire_banque' => $beneficiaire_banque
            ]);
    }
 
    public function edit_s($id,$statut,$onglet_actif="")
    {
        return $this->edit($id,$statut,$onglet_actif);
    }


    public function update($id,BeneficiaireRequest $request)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $refresh=$request->refresh;
        $onglet_actif=$request->onglet_actif;
        $beneficiaire = Beneficiaire::find($id);
        $beneficiaire->nom  = strtoupper($request->nom);
        $beneficiaire->prenom  = ($request->prenom);
        if($request->employeur_nom=="") $beneficiaire->sonum=0;
        else $beneficiaire->sonum = $request->sonum;
        $beneficiaire->n_all = $request->n_all;
        $date=$request->datenaiss;
        $beneficiaire->datenaiss = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $date=$request->date_deces;
        $beneficiaire->date_deces = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;

        $beneficiaire->lieunaiss = $request->lieunaiss;
        $beneficiaire->adresse = $request->adresse;
        $beneficiaire->district = $request->district;
        $beneficiaire->ile = $request->ile;
        $beneficiaire->tel = $request->tel;
        $beneficiaire->fax = $request->fax;
        $beneficiaire->email = $request->email;
        $beneficiaire->nb_enf = $request->nb_enf;
        $beneficiaire->nb_enf_tot = $request->nb_enf_tot;
        $beneficiaire->obs = $request->obs;

        $beneficiaire->mt_allloc = $request->mt_allloc;
        $beneficiaire->mt_calc = $request->mt_calc;
        $beneficiaire->statut = $request->statut;
        $beneficiaire->verrou = ($request->verrou=='')?0:1;
        $date=$request->ret_dateed;
        $beneficiaire->ret_dateed = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $beneficiaire->rappel = $request->rappel;
        $beneficiaire->ret_numdec = $request->ret_numdec;
        $beneficiaire->ret_montant = $request->ret_montant;
        $beneficiaire->ret_type = $request->ret_type; 
        $beneficiaire->ret_rappel = $request->ret_rappel;
        //$beneficiaire->csr_montant=$request->csr_montant;
        $beneficiaire->csr_rappel=$request->csr_rappel;
        $beneficiaire->conjoint = $request->conjoint; 
        $date=$request->date_pi;
        $beneficiaire->date_pi = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;  
        $beneficiaire->civilite = $request->civilite;     
        $beneficiaire->code_postal = $request->code_postal;
        $beneficiaire->obs_vers = $request->obs_vers;

        //Si décédé alors on enlève les rappels
        if($beneficiaire->statut=="D") {
            $beneficiaire->rappel = 0;
            $beneficiaire->ret_rappel = 0;
            $beneficiaire->csr_rappel=0;
        }
        $beneficiaire->save();
        //LOG de la transaction
        $beneficiaire->log_transaction($request->url(),'U');

        /* *** Gestion du RIB *** */
        $t_compte_champs=["banque_id","IBAN_pays","IBAN_cle","IBAN_banque","IBAN_guichet","IBAN_compte","IBAN_clerib"];
        //Si il a changé
        $beneficiaire_banque=$beneficiaire->getLastCompte();
        $change="";

        if($beneficiaire_banque!="") {
            foreach($t_compte_champs as $champ) {
                $val_org="'".$beneficiaire_banque->{$champ}."'";
                $val_new="'".$request->{$champ}."'";
                if($val_org!=$val_new) $change.="1";
                else $change.="0";
            }
            $change="0".$change;
            $change = dechex(bindec($change));
        }

        if( intVal($change)!=0) { //Si il y a eu un changement
            //On desactive le compte en cours
            $beneficiaire_banque->actif='0';
            $beneficiaire_banque->save();
            $beneficiaire_banque->log_transaction($request->url(),'U',"desactive");
        }
        
        if( (intVal($change)!=0) || ($change=="")) { //SI changement ou pas de banque
            //création du nouveau compte

            if($change=="") $change="00";
            $beneficiaire_banque = new BeneficiaireBanque;
            foreach($t_compte_champs as $champ) $beneficiaire_banque->{$champ} = $request->{$champ};
            $beneficiaire_banque->id_benef=$id;
            $beneficiaire_banque->infomodif=$change;
            $beneficiaire_banque->actif='1';
            $beneficiaire_banque->id_user=$user->id;
            $beneficiaire_banque->date=date('Y-m-j h:i:s');
            //dd($beneficiaire_banque);
            $beneficiaire_banque->save();

            $beneficiaire_banque->log_transaction($request->url(),'I');
        }
        /* *** Fin de Gestion du RIB *** */
        


        if($refresh==true) {
            return Redirect::to('/tiers/beneficiaires_statut/'.$id.'/'.$request->type_liste.'/'.$onglet_actif.'/edit/');
        }
        if($request->type_liste!="")  
            return Redirect::to('/tiers/beneficiaires/limit/'.$request->type_liste);
        
        return Redirect::to('/tiers/beneficiaires');
    }
 


    /**
     * Remove the specified user from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
         //LOG de la transaction
        $beneficiaire=Beneficiaire::find($id);
        $beneficiaire->log_transaction('','D');
        Beneficiaire::destroy($id);

        return Redirect::to('/tiers/beneficiaires');
    }
 
    public function autocomplete_conjoint(BeneficiaireAutoRequest $request)
    {       
        //return json_encode(array('aa','bb'));
        $param = $request->term;
        //if( ($param=='  ')||($param=='aucun')||($param=='***')) return ""; //NEW 2023
        $associate = array();
        $search    = DB::select(
            "select id ,CONCAT(TRIM(nom) ,
                    '  ',
                    TRIM(prenom),
                    '  (',
                    DATE_FORMAT(datenaiss, '%d/%m/%Y')
                    ,')'
                ) as value
                from beneficiaires
                where nom like ('{$param}%') or id='{$param}%'
            "
        );
        foreach ($search as $result) {
            $associate[] = $result;
        }
        $associate[]=["id"=>'',"value"=>'Aucun'];

        return json_encode($associate);
    }



}