<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\User;
use App\Models\Parametre;
use App\Models\Benefstatut;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use App\Http\Requests\BenefStatutRequest;


class BenefStatutsController extends Controller {


    /**
     * Display a listing of the parametre.
     *
     * @return Response
     */
    public function index()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $benef_statuts = Benefstatut::where('id', '<>', 'null')->orderBy('ref')->get();

        return View::make('param.benef_statuts.index', ['benef_statuts' => $benef_statuts, 'user'=>$user]);
    }


      /**
     * Display a listing of the parametre.
     *
     * @return Response
     */
    public function show($id=0)
    {

        echo  "show";
        exit();
    }


    /**
     * Show the form for creating a new parametre.
     *
     * @return Response
     */
    public function create()
    {
        return View::make('param.benef_statuts.create');
    }
 
    /**
     * Store a newly created parametre in storage.
     *
     * @return Response
     */
    public function store(BenefstatutRequest $request)
    {
        $benef_statut = new Benefstatut;
        $benef_statut->ref  = $request->ref;
        $benef_statut->libelle  = $request->libelle;
        $benef_statut->save();

        return Redirect::to('/param/benef_statuts');
    }
 
    /**
     * Show the form for editing the specified parametre.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $benef_statut = Benefstatut::find($id);
        return View::make('param.benef_statuts.edit', [ 'benef_statut' => $benef_statut ]);

    }
 
    /**
     * Update the specified parametre in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id,BenefstatutRequest $request)
    {
        $benef_statut = Benefstatut::find($id);
        $benef_statut->ref  = $request->ref;
        $benef_statut->libelle  = $request->libelle;
        $benef_statut->save();

        return Redirect::to('/param/benef_statuts');
    }
 
    /**
     * Remove the specified parametre from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        Benefstatut::destroy($id);
        return Redirect::to('/param/benef_statuts');
    }
 


}