<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\User;
use App\Models\Parametre;
use App\Models\Beneftype;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use App\Http\Requests\BeneftypeRequest;


class BeneftypesController extends Controller {

    /**
     * Display a listing of the parametre.
     *
     * @return Response
     */
    public function index()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $benef_types = Beneftype::where('id', '<>', 'null')->orderBy('ref')->get();

        return View::make('param.benef_types.index', ['benef_types' => $benef_types, 'user'=>$user]);
    }


      /**
     * Display a listing of the parametre.
     *
     * @return Response
     */
    public function show($id=0)
    {

        echo  "show";
        exit();
    }


    /**
     * Show the form for creating a new parametre.
     *
     * @return Response
     */
    public function create()
    {
        return View::make('param.benef_types.create');
    }
 
    /**
     * Store a newly created parametre in storage.
     *
     * @return Response
     */
    public function store(BeneftypeRequest $request)
    {
        $benef_type = new Beneftype;
        $benef_type->ref  = $request->ref;
        $benef_type->libelle  = $request->libelle;
        $benef_type->statuts  = $request->statuts;
        $benef_type->save();

        return Redirect::to('/param/benef_types');
    }
 
    /**
     * Show the form for editing the specified parametre.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $benef_type = Beneftype::find($id);
        return View::make('param.benef_types.edit', [ 'benef_type' => $benef_type ]);

    }
 
    /**
     * Update the specified parametre in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id,BeneftypeRequest $request)
    {
        $benef_type = Beneftype::find($id);
        $benef_type->ref  = $request->ref;
        $benef_type->libelle  = $request->libelle;
        $benef_type->statuts  = $request->statuts;
        $benef_type->save();

        return Redirect::to('/param/benef_types');
    }
 
    /**
     * Remove the specified parametre from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        Beneftype::destroy($id);
        return Redirect::to('/param/benef_types');
    }
 


}