<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\User;
use App\Models\Plan;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;


class CompteResultatController extends Controller {

    public function index($categ="R")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $exercice=date('Y')-1;

        $plans=Plan::all();
        $plans_categ=Plan::where("categ","=",$categ)->
            get();
        $t_CR_produits=array();
        $t_CR_charges=array();

        foreach($plans_categ as $plan_categ) {
            $categ_CR=$plan_categ->categ_cr;
            
            if($categ_CR!="") {
                $charge=(substr($categ_CR,0,1)=="C");
                $produit=(substr($categ_CR,0,1)=="P");
                $compte=substr($categ_CR,1,1);
                $brut=$plan_categ->getSoldeCalc($exercice);

                //PRODUITS
                if($produit) {

                    $amort_prec=0;$amort=0;
                    $amortissement=$plan_categ->amort;
                    $plan_amortissement=Plan::where("numcpt","=",$amortissement)->first();

                    // Precedante
                    if($plan_amortissement) $amort_prec=$plan_amortissement->getSoldeCalc($exercice-1);
                    $netprec=(-$plan_categ->getSoldeCalc($exercice-1))-$amort_prec;

                    // En cours
                    if($plan_amortissement) $amort=$plan_amortissement->getSoldeCalc($exercice);
                    $net=$brut-$amort;
                
                    $value=$plan_categ->numcpt.";";
                    $value.=$plan_categ->nomcpt.";";
                    $value.=$netprec.";";
                    $value.=$brut.";";
                    $value.=$amort.";";
                    $value.=$brut-$amort.";";
                    $t_CR_produits[$plan_categ->numcpt]=$value;
                }  
                //CHARGES
                if($charge) {
                    // Precedante
                    $netprec=($plan_categ->getSoldeCalc($exercice-1));
                    // En cours
                    $net=$brut;
                    $value=$plan_categ->numcpt.";";
                    $value.=$plan_categ->nomcpt.";";
                    $value.=$netprec.";";
                    $value.=$net.";";
                    $t_CR_charges[$plan_categ->numcpt]=$value;
                }
       

            }


            
        }


        return View::make('compta.bilan.index_cr', [ 
            'user'=>$user,
            'exercice'=>$exercice,
            'plans'=>$plans,
            't_CR_produits'=>$t_CR_produits,
            't_CR_charges'=>$t_CR_charges,
            'categ'=>$categ
        ]);
    }


 
}