<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Controle;
use App\Models\User;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\ControleRequest;
use App\Http\Requests\AutoResponsableRequest;
use Request;
use Response;


class ControlesController extends Controller {
 
 
    /**
     * Liste des controles
     */
    public function index($employeur_id=0)
    {
        $user=User::where('id','=',Session::get('id'))->first();

        $liste_employeur=Employeur::distinct()->select('nom','id')->orderBy('nom')->pluck("nom", "id")->toArray();

        $liste_employes="";
        $controles = array();
        if($employeur_id) {
            $controles = Controle::where('sonum','=',$employeur_id)->orderBy('id','DESC')->get();
        }

        $liste_employeur2=array();
        foreach($liste_employeur as $id=>$nom) {
             $liste_employeur2[$id]=htmlentities(str_replace('"','',$nom));
        }
        return View::make('recouvrement.controles.index', [ 
            'controles' => $controles,
            'user'=>$user,
            'employeur_id'=>$employeur_id,
            'liste_employeur' => $liste_employeur2
        ]);
    }


    /**
     * Liste des controles depuis la fiche Employeur
     */
    public function index_employeur($employeur_id="")
    {
        $user=User::where('id','=',Session::get('id'))->first();

        $liste_employeur=Employeur::distinct()->select('nom','id')->orderBy('nom')->pluck("nom", "id")->toArray();

        $liste_employes="";
        $controles = array();
        if($employeur_id) {
            $employeur=Employeur::find($employeur_id);
            $controles = Controle::where('sonum','=',$employeur_id)->orderBy('id','DESC')->get();
        }
        return View::make('recouvrement.controles.index_employeur', [
            'employeur' => $employeur, 
            'controles' => $controles,
            'user'=>$user])
            ;
    }
 
    /**
     * Show the form for creating a new user.
     *
     * @return Response
     */
    public function create($employeur_id="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $liste_employeur = Employeur::orderBy('nom','ASC')->pluck("nom", "id")->toArray();

        $via_employeur=($employeur_id!="");

        return View::make('recouvrement.controles.create', 
            ['employeur_id' => $employeur_id,
            'liste_employeur' => $liste_employeur,
            'user'=>$user
            ]);
    }
 

 
    /**
     * Store a newly created user in storage.
     *
     * @return Response
     */
    public function store(ControleRequest $request)
    {
        $controle = new Controle;
        $controle->sonum = $request->sonum;
        $date = $request->date_cont;
        $controle->date_cont = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $controle->agent1 = $request->agent1;
        $controle->agent2 = $request->agent2;
        $date = $request->date_valid;
        $controle->date_valid = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $controle->observations = $request->observations;
        $controle->save();

        return Redirect::to('recouvrement/controle_annee/'.$controle->sonum);
    }
 
    /**
     * Show the form for editing the specified user.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        $controle=Controle::find($id);
        $user=User::where('id','=',Session::get('id'))->first();
        $liste_employeur = Employeur::orderBy('nom','ASC')->pluck("nom", "id")->toArray();

        return View::make('recouvrement.controles.edit', 
            [
            'liste_employeur' => $liste_employeur,
            'controle' => $controle,
            'user'=>$user
            ]);
    }


    /**
     * Show the form for editing the specified user.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
        $controle = Controle::find($id);
        return View::make('recouvrement.controles.show', [ 'controle'=> $controle]);
    }

     /**
     * Show the form for editing the specified user.
     *
     * @param  int  $id
     * @return Response
     */
    public function show_box($id)
    {
        $controle = Controle::find($id);
        return View::make('recouvrement.controles.show_box', [ 'controle'=> $controle]);
    }
 
    /*
     * Update the specified user in storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function update($id,ControleRequest $request)
    {
        $controle = Controle::find($id);
        $controle->sonum = $request->sonum;
        $date = $request->date_cont;
        $controle->date_cont = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $controle->agent1 = $request->agent1;
        $controle->agent2 = $request->agent2;
        $date = $request->date_valid;
        $controle->date_valid = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $controle->observations = $request->observations;
        $controle->save();
        return Redirect::to('recouvrement/controle_annee/'.$controle->sonum);
    }
 


     public function add_piece($id)
    {
        $controle = Controle::find($id);
        return View::make('recouvrement.controles.add_piece', 
            [ 'controle'=> $controle]);
    }


    /**
     * Remove the specified user from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        $employeur_id=Controle::find($id)->value('sonum');   
        Controle::destroy($id);
        return Redirect::to('recouvrement/controle_annee/'.$employeur_id);
    }



}