<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\Employeur;
use App\Models\Beneficiaire;
use App\Models\Cotisation;
use App\Models\Cotispmt;
use App\Models\User;
use App\Models\Role2;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;
use Illuminate\Support\Facades\Auth;
use App\Http\Requests\CotisationRequest;
use App\Http\Requests\CotisationEncaissRequest;
use App\Http\Requests\ReglementRequest;
use App\Http\Requests\AutoResponsableRequest;

use Illuminate\Http\Request;
use Validator;
use Response;
use App\Models\Parametre;


class CotisationsController extends Controller {


    /**
     * Liste des cotisations
     */
    public function index_filtre(Request $request)
    {
        $employeur_id=$request->employeur_id2;
        $exercice=$request->exercice;
        $mois_debut=$request->mois_debut;
        $mois_fin=$request->mois_fin;
        $lettrage=$request->lettrage;

        return $this->index($employeur_id,$exercice,$lettrage,$mois_debut,$mois_fin);
    }


    public function index($employeur_id=0,$exercice="",$lettrage="T",$mois_debut="",$mois_fin ="")
    {
        $user=User::where('id','=',Session::get('id'))->first();

        $liste_employes="";
        $t_total=["soldejour"=>0,"an"=>0,"debit"=>0,"credit"=>0,"solde"=>0];

        $exercices = ['*'=>'Toutes']+$this->getListeExercices();
        $liste_employeur=$this->getListeEmployeur(false);

        if(($mois_debut=='')||($mois_fin=='')) {
            $mois_debut="";$mois_fin="";
        } else {
            $mois_debut_us = ($mois_debut!="")?date('Y-m-d', strtotime(str_replace('/', '-', $mois_debut))):"" ;
            $mois_fin_us = ($mois_fin!="")?date('Y-m-d', strtotime(str_replace('/', '-', $mois_fin))):"" ;
            $exercice="";
        }
        if(($exercice=="")&&($mois_debut=="")&&($mois_fin=="")) $exercice=intval(date('Y'));

        $date_limite="";
        if($exercice) $annee_solde=$exercice;
        else {
            $annee_solde=substr($mois_fin_us,0,4);
            $date_limite=$mois_fin_us;
        }


        if($exercice=="*") $annee_solde=intval(date('Y'));


        $cotisations = array();
        $list_exercice="";
        $employeur_nom="";
        if($employeur_id) {
            if($employeur_id=="TOUS") {
                $employeur=array();;
                $employeur_nom="";
                $obj_cotisations = Cotisation::orderBy('date','ASC');
            } else {
                $employeur=employeur::find($employeur_id);
                $employeur_nom=$employeur_id." ".trim($employeur->nom);
                $t_total["solde"]=$employeur->getSolde($annee_solde,$date_limite);
                $t_total["an"]=$employeur->getSolde2Year($annee_solde-1);
                $t_total["soldejour"]=-$employeur->ResteAPayer;
                $obj_cotisations = Cotisation::where('sonum','=',$employeur_id)
                    ->orderBy('date','DESC');
            }

            //PERIODE
            if(($exercice!='')&&($exercice!='*')) {
                $obj_cotisations = $obj_cotisations->where('exercice','=',$exercice);
            } else {
                if($exercice!='*') $obj_cotisations = $obj_cotisations->whereBetween('date', array($mois_debut_us, $mois_fin_us));
            }

            //LETTRAGE
            if($lettrage=="N")
                $obj_cotisations = $obj_cotisations->where('lettrage2','=',"");

            if($lettrage=="L")
                $obj_cotisations = $obj_cotisations->where('lettrage2','<>',"");

            $cotisations = $obj_cotisations->get();
        }


        if(($exercice!='')&&($exercice!='*'))  $fin_an=($exercice-1)."-12-31";
        else $fin_an=(date('Y')-1)."-12-31";

        //Pour les id de checkbox
        $checkboxes="";
        foreach ($cotisations as $cotisation) {
            if($cotisation->credit==0) $checkboxes.=(($checkboxes=="")?"":",").$cotisation->id;

            //$t_total["debit"]+=$cotisation->debit;
            //$t_total["credit"]+=$cotisation->credit;
            //if($cotisation->date<=$fin_an) $t_total["an"]+=$cotisation->credit-$cotisation->debit;
        }


        return View::make('recouvrement.cotisations.index', [
            'cotisations' => $cotisations,
            'user'=>$user,
            'employeur_id'=>$employeur_id,
            'employeur_nom'=>$employeur_nom,
            'liste_employeur' => $liste_employeur,
            'exercices' => $exercices,
            'exercice' => $exercice,'annee_solde' => $annee_solde,
            'checkboxes' => $checkboxes,
            't_total' => $t_total,"fin_an"=>$fin_an,
            'lettrage' => $lettrage,
            'mois_debut'=>$mois_debut,'mois_fin' =>$mois_fin
        ]);
    }


    /**
     * Liste des cotisations
     */
    public function index_encours()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $cotisations = Cotisation::where('encais_compte','=','')->orderBy('date','ASC')->get();

        return View::make('recouvrement.cotisations.index_encours', [
            'cotisations' => $cotisations,
            'user'=>$user
        ]);
    }


    /**
     * Liste des cotisations
     */
    public function index_encaissees($exercice="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $exercices = $this->getListeExercices();

        if($exercice=="") $exercice=intval(date('Y'));
        $cotisations = Cotisation::where('encais_compte','<>','')
            ->where('exercice','=',$exercice)
            ->orderBy('date','DESC')
            ->get();

        $libelle_filtrage="Liste filtrée sur l'Exercice ".$exercice;

        return View::make('recouvrement.cotisations.index_encaissees', [
            'cotisations' => $cotisations,
            'user'=>$user,
            'exercices'=>$exercices,
            'exercice'=>$exercice,
            'libelle_filtrage'=>$libelle_filtrage
        ]);
    }

    public function index_encaissees_post(Request $request)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $exercices = $this->getListeExercices();
        $erreur="Les mois doivent être de la forme MM/AAAA (ex.03/2017 pour Mars 2017)";
        $exercice=$request->exercice;
        $encais_compte=$request->encais_compte;
        $mois_debut=$request->mois_debut;
        $mois_fin=$request->mois_fin;
        if(($mois_debut=='')||($mois_fin=='')) {
            return redirect()->back()->withInput()->withErrors(['message1'=>'Vous devez choisir une période']);
            return $this->index_encaissees($exercice);
        }


        $mois_debut_us = ($mois_debut!="")?date('Y-m-d', strtotime(str_replace('/', '-', $mois_debut))):"" ;
        $mois_fin_us = ($mois_fin!="")?date('Y-m-d', strtotime(str_replace('/', '-', $mois_fin))):"" ;


        if($encais_compte!='') $obj_cotisations = Cotisation::where('encais_compte','=',$encais_compte);
        else $obj_cotisations = Cotisation::where('encais_compte','<>','');
        $cotisations = $obj_cotisations->whereBetween('encais_date', array($mois_debut_us, $mois_fin_us))
            ->orderBy('date','DESC')
            ->get();

        $exercice='';
        $libelle_filtrage="Liste filtrée sur la date d'encaissement comprise entre le ".$mois_debut." et ".$mois_fin;
        if($encais_compte!='') $libelle_filtrage.=" ET sur le compte ".$encais_compte;
        return View::make('recouvrement.cotisations.index_encaissees', [
            'cotisations' => $cotisations,
            'user'=>$user,
            'exercices'=>$exercices,
            'exercice'=>$exercice,
            'mois_debut'=>$mois_debut,
            'mois_fin'=>$mois_fin,
            'encais_compte' => $encais_compte,
            'libelle_filtrage'=>$libelle_filtrage
        ]);
    }

    /**
     * Liste des cotisations depuis la fiche Employeur
     */
    public function index_employeur($employeur_id="")
    {
        $user=User::where('id','=',Session::get('id'))->first();

        $liste_employeur=$this->getListeEmployeur(true);
        $liste_employes="";
        $cotisations = array();
        if($employeur_id) {
            $employeur=Employeur::find($employeur_id);
            $cotisations = Cotisation::where('sonum','=',$employeur_id)
                ->orderBy('date','DESC')->get();
        }
        return View::make('recouvrement.cotisations.index_employeur', [
            'employeur' => $employeur,
            'cotisations' => $cotisations,
            'user'=>$user])
            ;
    }



    /* Liste des cotisations pour un employeur
    pour 'Reste à payer par année de rattachement '*/
    public function index_cotis_emp($employeur_id,$type,$exercice="",$date_limite="")
    {
        $user=User::where('id','=',Session::get('id'))->first();

        $employeur=Employeur::find($employeur_id);

        if($type=="C")
            $cotisations = $employeur->getCotisations($type,$exercice,$date_limite);

        if($type=="E")
            $cotisations = $employeur->getCotisations($type,$exercice,$date_limite);

        return View::make('recouvrement.suivi.detail_cotisations', [
            'cotisations' => $cotisations,
            'user'=>$user,
            'employeur'=>$employeur,
        ]);
    }

    public function index_cotis_emp_exercice($employeur_id,$exercice="",$date_limite="")
    {
        return $this->index_cotis_emp($employeur_id,"E",$exercice,$date_limite);
    }

    public function index_cotis_emp_cumule($employeur_id,$exercice="",$date_limite="")
    {
        return $this->index_cotis_emp($employeur_id,"C",$exercice,$date_limite);
    }

    /**
     * Liste des cotisations pour pointage
     */
    public function pointage($employeur_id=0,$exercice="",$affiche_tout=0)
    {
        $user=User::where('id','=',Session::get('id'))->first();

        $liste_employes="";
        $t_total=["soldejour"=>0,"an"=>0,"debit"=>0,"credit"=>0,"solde"=>0];

        $exercices = ['*'=>'Toutes']+$this->getListeExercices();
        $liste_employeur=$this->getListeEmployeur(false);
        if($exercice=="") $exercice=intval(date('Y'));

        $annee_solde=$exercice;
        if($exercice=="*") $annee_solde=intval(date('Y'));


        $cotisations = array();
        $list_exercice="";
        $employeur_nom="";
        if($employeur_id) {
            if($employeur_id=="TOUS") {
                $employeur=array();;
                $employeur_nom="";
                $obj_cotisations = Cotisation::orderBy('date','ASC');
            } else {
                $employeur=employeur::find($employeur_id);
                $employeur_nom=$employeur_id." ".trim($employeur->nom);
                $t_total["solde"]=$employeur->getSolde($annee_solde);
                $t_total["an"]=$employeur->getSolde2Year($annee_solde-1);
                $t_total["soldejour"]=-$employeur->ResteAPayer;
                $obj_cotisations = Cotisation::where('sonum','=',$employeur_id)
                    ->orderBy('date','DESC');

            }

            if(($exercice!='')&&($exercice!='*')) $obj_cotisations = $obj_cotisations->where('exercice','=',$exercice);

            if(!$affiche_tout)
                $obj_cotisations = $obj_cotisations->where('lettrage2','=',"");

            $cotisations = $obj_cotisations->get();
        }


        if(($exercice!='')&&($exercice!='*'))  $fin_an=($exercice-1)."-12-31";
        else $fin_an=(date('Y')-1)."-12-31";

        //Pour les id de checkbox
        $checkboxes="";
        foreach ($cotisations as $cotisation) {
            if($cotisation->credit==0) $checkboxes.=(($checkboxes=="")?"":",").$cotisation->id;
        }
        $liste_id='';

        return View::make('recouvrement.cotisations.pointage', [
            'cotisations' => $cotisations,
            'user'=>$user,
            'employeur_id'=>$employeur_id,
            'employeur_nom'=>$employeur_nom,
            'liste_employeur' => $liste_employeur,
            'exercices' => $exercices,
            'exercice' => $exercice,
            'checkboxes' => $checkboxes,
            'liste_id' => $liste_id,
            't_total' => $t_total,"fin_an"=>$fin_an,
            "affiche_tout"=>$affiche_tout
        ]);
    }


    public function lettrer(Request $request,$employeur_id,$exercice)
    {
        $erreur=false;
        $employeur_id=$request->employeur_id2;
        $liste_cotisations=$request->checklist;
        $t_cotisation=explode(",",$liste_cotisations);
        $lettre=$this->getLettre();
        foreach($t_cotisation as $id_cotisation) {
            $cotisation=Cotisation::find($id_cotisation);
            $cotisation->lettrage2=$lettre;
            $cotisation->save();
        }
        //Vérification
        $montant=DB::table('cotis')
            ->select(db::raw("SUM(debit-credit) as total"))
            ->where('lettrage2','=',$lettre)
            ->where('sonum','=',$employeur_id)
            ->value('total');

        //Si pas zéro on detricotte
        if($montant!=0) {
            foreach($t_cotisation as $id_cotisation) {
                $cotisation=Cotisation::find($id_cotisation);
                $cotisation->lettrage2="";
                $cotisation->save();
            }
        }
        return $this->pointage($employeur_id,$exercice);
    }

    //Get Lettre pour lettrage
    private function getLettre() {
        $max=5;
        $lastlettre=Cotisation::select("lettrage2")
            ->orderby('lettrage2','DESC')
            ->limit(1)
            ->value('lettrage2');
        $newlettre="";
        $t_Alpha=array();
        $l=array();
        $l_ascii=array();

        if($lastlettre=="") {
            for($j=0;$j<$max;$j++) $newlettre.="A";
        } else {
            for($j=0;$j<$max;$j++) {
                $l[$j]=substr($lastlettre,$j,1);
                $l_ascii[$j]=ord($l[$j]);
            }

            for($j=($max-1);$j>=0;$j--) {
                if($l[$j]=="Z") $l[$j]="A";
                else {
                    $l[$j]=chr(ord($l[$j])+1);break;
                }
            }
            for($j=0;$j<$max;$j++) $newlettre.=$l[$j];

        }
        return $newlettre;
    }


    public function encaissement_compta($id)
    {
        return $this->encaissement($id,"compta");
    }

    // FIN Pointage Compta

    public function create($employeur_id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("COT_AJO")) return Redirect::route('home');

        $employeur=Employeur::find($employeur_id);
        $user=User::where('id','=',Session::get('id'))->first();
        $liste_employeur=$this->getListeEmployeur(true);
        $exercices = $this->getListeExercices();
        $types_cotisation=$this->getTypesCotisation();
        $types_operations=$this->getTypesOperations();
        $taux_CLR=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCLRAttribute();
        $taux_CPF=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCCPFAttribute();

        return View::make('recouvrement.cotisations.create',
            ['employeur' => $employeur,
            'user'=>$user,
            'exercices' => $exercices,
            'taux_CLR'=> $taux_CLR,
            'taux_CPF'=> $taux_CPF,
            'types_cotisation' => $types_cotisation,
            'types_operations' => $types_operations
            ]);
    }

    /*
    public function create_reglement($employeur_id="")
    {
        dd('r');
        $employeur=Employeur::find($employeur_id);
        $user=User::where('id','=',Session::get('id'))->first();
        $liste_employeur=$this->getListeEmployeur(true);
        $exercices = $this->getListeExercices();
        $types_cotisation=$this->getTypesCotisation();
        $types_operations=$this->getTypesOperations();
        $taux_CLR=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCLRAttribute();
        $taux_CPF=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCCPFAttribute();

        return View::make('recouvrement.reglement_create',
            ['employeur' => $employeur,
            'user'=>$user,
            'exercices' => $exercices,
            'taux_CLR'=> $taux_CLR,
            'taux_CPF'=> $taux_CPF,
            'types_cotisation' => $types_cotisation,
            'types_operations' => $types_operations
            ]);
    }
    */

    /**
     * Store a newly created user in storage.
     *
     * @return Response
     */
    public function store(CotisationRequest $request)
    {
        $cotisation = new Cotisation;
        $cotisation->sonum = $request->sonum;
        $date = $request->date;
        $cotisation->date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $cotisation->exercice = $request->exercice;
        $date = $request->mois;
        $cotisation->mois = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $cotisation->nbmois = $request->nbmois;
        $cotisation->nbsal = $request->nbsal;
        $cotisation->type_ope = $request->type_ope; //AJOUT 09/2020
        $cotisation->type_cotis = $request->type_cotis;
        $cotisation->bdx = $request->bdx;
        $cotisation->bdx_prive = $request->bdx_prive;
        //assiette & cotisation
        $cotisation->assiette = $request->assiette;
        $cotisation->debit = isset($request->total)?$request->total:0;
        $cotisation->credit = 0; //Valeur par défaut lors de la création

        if($cotisation->assiette>0) { // MODIF 07/2020 ticket PBH-JJJ-LBYJ (ID du Ticket: 82)
            if($cotisation->debit>0) {
                $cotisation->clr = $request->clr;
                $cotisation->ccpf = $request->ccpf;
            } else { //Si crédit alors pas de clr ccpf
                $cotisation->clr = 0;
                $cotisation->ccpf = 0;
            }
        } else {
            $cotisation->clr = $request->clr;
            $cotisation->ccpf = $request->ccpf;
        }
        $cotisation->observation = $request->observation;

        //Info paiement
        $cotisation->compte = '';
        $cotisation->typepmt = '';
        $cotisation->encais_date = null;
        $cotisation->encais_compte = '';
        $cotisation->save();

        //LOG de la transaction
        $cotisation->log_transaction('','I');
        return Redirect::to('recouvrement/cotisations/'.$cotisation->id);
        //return Redirect::to('recouvrement/cotisation_annee/'.$request->sonum.'/'.$request->exercice);
    }

    /**
     * Show the form for editing the specified user.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("COT_MAJ")) return Redirect::route('home');

        $cotisation=Cotisation::find($id);
        $employeur=Employeur::find($cotisation->sonum);
        $user=User::where('id','=',Session::get('id'))->first();
        $exercices = $this->getListeExercices();
        $types_cotisation=$this->getTypesCotisation();
        $types_operations=$this->getTypesOperations();
        $taux_CLR=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCLRAttribute();
        $taux_CPF=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCCPFAttribute();
        return View::make('recouvrement.cotisations.edit',
            [
            'cotisation' => $cotisation,
            'user'=>$user,
            'employeur' => $employeur,
            'exercices' => $exercices,
            'taux_CLR'=> $taux_CLR,
            'taux_CPF'=> $taux_CPF,
            'types_cotisation' => $types_cotisation,
            'types_operations' => $types_operations
            ]);
    }

    public function encaissement($id,$origine="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("COT_VISU")) return Redirect::route('home');

        $cotisation=Cotisation::find($id);
        $user=User::where('id','=',Session::get('id'))->first();
        $types_cotisation=$this->getTypesCotisation();
        $types_operations=$this->getTypesOperations();
        $taux_CLR=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCLRAttribute();
        $taux_CPF=Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->getTauxCCPFAttribute();

        return View::make('recouvrement.cotisations.encaissement',
            [
            'cotisation' => $cotisation,
            'user'=>$user,
            'taux_CLR'=> $taux_CLR,
            'taux_CPF'=> $taux_CPF,
            'types_cotisation' => $types_cotisation,
            'types_operations' => $types_operations,
            'origine' => $origine
            ]);
    }


    public function show($id)
    {
        $cotisation = Cotisation::find($id);
        $types_paiement=$this->getTypesPaiement();
        $types_cotisation=$this->getTypesCotisation();
        $types_operations=$this->getTypesOperations();
        return View::make('recouvrement.cotisations.show', [
            'types_paiement'=>$types_paiement,
            'cotisation'=> $cotisation,
            'types_cotisation' => $types_cotisation,
            'types_operations' => $types_operations
        ]);
    }


    public function show_box($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("COT_VISU")) return Redirect::route('home');

        $cotisation = Cotisation::find($id);
        $types_paiement=$this->getTypesPaiement();
        $types_operations=$this->getTypesOperations();
        return View::make('recouvrement.cotisations.show_box', [
            'types_paiement'=>$types_paiement,
            'cotisation'=> $cotisation,
            'types_operations' => $types_operations
        ]);
    }


    public function update($id,CotisationRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("COT_MAJ")) return Redirect::route('home');

        $cotisation = Cotisation::find($id);
        $type_reglement=(($request->credit<>0)&&($request->total==0));
       //$cotisation->sonum = $request->sonum;
        $date = $request->date;
        $cotisation->date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $cotisation->assiette = $request->assiette;
        if(!$type_reglement) {
            $cotisation->clr = $request->clr;
            $cotisation->ccpf = $request->ccpf;
            $cotisation->debit = $request->total;
            $cotisation->credit = $request->credit;
        } else {
            $cotisation->clr = 0;
            $cotisation->ccpf = 0;
            $cotisation->debit = 0;
            $cotisation->credit = $request->credit;
        }

        $cotisation->compte = $request->compte;
        $date = $request->mois;
        $cotisation->mois = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
        $cotisation->nbmois = $request->nbmois;
        $cotisation->bdx = $request->bdx;
        $cotisation->type_ope = $request->type_ope; //AJOUT 09/2020
        $cotisation->typepmt = $request->typepmt;
        $date = $request->encais_date;
        $cotisation->encais_date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $cotisation->encais_compte = $request->encais_compte;
        $cotisation->type_cotis = $request->type_cotis;
        $cotisation->observation = $request->observation;
        $cotisation->exercice = $request->exercice;
        $cotisation->nbsal = $request->nbsal;
        $cotisation->bdx_prive = $request->bdx_prive;
        $date = $request->date_depot;
        $cotisation->date_depot    =  ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;

        $cotisation->save();

        //LOG de la transaction
        $cotisation->log_transaction($request->url(),'U');

        //if($cotisation->credit==0) return Redirect::to('recouvrement/cotisation_annee/'.$request->sonum);
        //
        return Redirect::to('recouvrement/cotisations/'.$id);
    }


    public function update_encaiss($id,CotisationEncaissRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("COT_MAJ")) return Redirect::route('home');

        $cotisation = Cotisation::find($id);
        $date = $request->encais_date;
        $cotisation->encais_date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        $cotisation->encais_compte = $request->encais_compte;
        $cotisation->save();

        //LOG de la transaction
        $cotisation->log_transaction($request->url(),'U');

        if($request->origine=="compta") {
            $employeur_id=$cotisation->sonum;
            $exercice=$cotisation->exercice;
            return $this->pointage($employeur_id,$exercice);
        }
        return Redirect::to('recouvrement/cotisations_encours');
    }


    public function destroy($id,$exercice)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("COT_SUP")) return Redirect::route('home');

        if($exercice=="") $exercice=date('Y');
        $cotisation=Cotisation::find($id);
        $employeur_id=$cotisation->sonum;
        //Suppression des lettrages associés si règlement
        if(($cotisation->lettrage!='')&&($cotisation->credit!=0)) {
            //Lettre les cotisations associées
            $lettres=$cotisation->lettrage;
            $fields = explode(',', $lettres);
            $cotisations=Cotisation::wherein('id',$fields)->get();
            foreach($cotisations as $cotisation) {
                $cotisation->lettrage='';
                $cotisation->save();
            }
        }
        $cotisation=Cotisation::find($id);
        //LOG de la transaction
        $cotisation->log_transaction('','D');

        Cotisation::destroy($id);
        return Redirect::to('recouvrement/cotisation_annee/'.$employeur_id.'/'.$exercice);
    }




    /**
     * saisie du règlement des cotisations sélectionnées
     */
    public function lettrage_bef($id,$exercice,Request $request)
    {
        $list_cotis="";
        $fields = explode(',', $request->input('checkboxes'));
        foreach($fields as $field) {
            if($request['box_'.$field]=='1') {
                $list_cotis.=(($list_cotis=="")?"":",").$field;
            }
        }
        return $this->lettrage($id,$exercice,$list_cotis);
    }

    /**
     * saisie du règlement des cotisations sélectionnées
     */
    public function lettrage($id,$exercice,$list_cotis="")
    {
        if($list_cotis=="") $list_cotis=Session::get('liste_cotisations');

        if($list_cotis=="") Redirect::to('recouvrement/cotisation_annee/'.$id.'/'.$exercice);

        if(strlen($exercice)==9) $exercice=substr($exercice,-4);
        $fields = explode(',', $list_cotis);
        $cotisations=Cotisation::wherein('id',$fields)->orderby('date','DESC')->get();
        $user=User::where('id','=',Session::get('id'))->first();
        $exercices = $this->getListeExercices();
        $employeur=Employeur::find($id);
        $types_paiement=$this->getTypesPaiement();
        $types_cotisation=$this->getTypesCotisation();
        $types_operations=$this->getTypesOperations();

        $nbmois=Cotisation::wherein('id',$fields)->sum('nbmois');
        $last_cotisations=$cotisations->last();

        $nbsal=$last_cotisations->nbsal;

        $cotisation_model=$cotisations->first();
        $exercice=$cotisation_model->exercice;
        $bdx_default=0;
        $bdx_prive_default=0;
        if($cotisation_model->bdx>0) $bdx_default=$user->getParametre('REC_NUM_BORD');
        if($cotisation_model->bdx_prive>0) $bdx_prive_default=$user->getParametre('REC_NUM_BORD_PRIV');

        return View::make('recouvrement.reglements.saisie',
            [
            'employeur' => $employeur,
            'cotisations' => $cotisations,
            'user'=>$user,
            'exercices' => $exercices,
            'exercice' => $exercice,
            'types_paiement' => $types_paiement,
            'types_cotisation' => $types_cotisation,
            'types_operations' => $types_operations,
            'nbsal' => $nbsal,
            'nbmois' => $nbmois,
            'bdx_default' => $bdx_default,
            'bdx_prive_default' => $bdx_prive_default,
            'cotisation_model' => $cotisation_model
            ]);
    }


    /**
     * saisie d'un règlement en comptabilité'
     */
    public function reglement_create($id,$exercice)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("COT_ENC")) return Redirect::route('home');

        if(strlen($exercice)==9) $exercice=substr($exercice,-4);
        $cotisations=Cotisation::orderby('date','DESC')->limit(1)->get();
        $user=User::where('id','=',Session::get('id'))->first();
        $exercices = $this->getListeExercices();
        $employeur=Employeur::find($id);
        $types_paiement=$this->getTypesPaiement();
        $types_cotisation=$this->getTypesCotisation();
        $types_operations=$this->getTypesOperations();

        $nbmois=$cotisations->sum('nbmois');
        $last_cotisations=$cotisations->last();
        $nbsal=$last_cotisations->nbsal;

        $cotisation_model=$cotisations->first();
        $exercice=$cotisation_model->exercice;
        $bdx_default=0;
        $bdx_prive_default=0;
        if($cotisation_model->bdx>0) $bdx_default=$user->getParametre('REC_NUM_BORD');
        if($cotisation_model->bdx_prive>0) $bdx_prive_default=$user->getParametre('REC_NUM_BORD_PRIV');

        return View::make('recouvrement.reglements.saisie_compta',
            [
            'employeur' => $employeur,
            'cotisations' => $cotisations,
            'user'=>$user,
            'exercices' => $exercices,
            'exercice' => $exercice,
            'types_paiement' => $types_paiement,
            'types_cotisation' => $types_cotisation,
            'types_operations' => $types_operations,
            'nbsal' => $nbsal,
            'nbmois' => $nbmois,
            'bdx_default' => $bdx_default,
            'bdx_prive_default' => $bdx_prive_default,
            'cotisation_model' => $cotisation_model
            ]);
    }

    public function store_reglement(Request $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("COT_ENC")) return Redirect::route('home');

        $nb_reglement=1;
        //Vérif saisie
        $total_reglement=intval($request->credit1);
        $t_rules=[
            'sonum' => 'required',
            'date' => 'required',
            'type_ope' => 'required',
            'exercice' => 'required|max:4',
            'type_cotis' => 'required',
            'nbmois' => 'numeric|required|min:1',
            'mois' => 'required',
            'bdx' => '',
            'bdx_prive' => '',
            'nbsal' => 'required|numeric',
            'encais_date' => '',
            'encais_compte' => '',
            'credit1' => 'numeric|required',
            'compte1' => '',
            'typepmt1' => 'required',
            'date_depot1' => '',
            'obs' => '',
            //'assiette' => 'required|numeric|min:1',
            //'clr' => 'numeric',
            //'ccpf' => 'numeric|required',
            //'credit' => 'numeric|required',
        ];

        $t_attributes=[
            'sonum' => 'Employeur',
            'type_ope' => "Type d'opérationn",
            'type_cotis' => 'Type de cotisation',
            'date' => 'Date d\'entrée',
            //'assiette' => 'Assiette',
            //'clr' => 'CLR',
            //'ccpf' => 'CCPF',
            'mois' => 'Mois',
            'nbmois' => 'Nombre de mois',
            'encais_date' => 'Date d\'encaissement',
            'encais_compte' => 'Compte',
            'type_cotis' => 'Type de cotisation',
            'date_depot1' => 'Date de dépôt',
            'exercice' => 'Exercice',
            'nbsal' => 'Nombre de salariés',
            'bdx' => 'Bordereau',
            'bdx_prive' => '',
            'credit1' => 'Crédit du 1er règlement',
            'compte1' => 'Compte du 1er règlement',
            'typepmt1' => 'Type de paiement du 1er règlement',
        ];

        //Si 2e paiement : credit2 compte2 typepmt2 obs2
        if(($request->credit2!="")||($request->typepmt2!="")||($request->obs2!="")) {
            $t_rules['credit2']='required';$t_attributes['credit2']='Crédit du 2ème règlement';
            //$t_rules['compte2']='required';$t_attributes['compte2']='Compte du 2ème règlement';
            $t_rules['date_depot2']='required';$t_attributes['date_depot2']='Date de dépôt du 2ème règlement';
            $t_rules['typepmt2']='required';$t_attributes['typepmt2']='Type de paiement du 2ème règlement';
            $nb_reglement++;
            $total_reglement+=intval($request->credit2);
        }

        //Si 3e paiement : credit3 compte3 typepmt3 obs3
        if(($request->credit3!="")||($request->typepmt3!="")||($request->obs3!="")) {
            $t_rules['credit3']='required';$t_attributes['credit3']='Crédit du 3ème règlement';
            //$t_rules['compte3']='required';$t_attributes['compte3']='Compte du 3ème règlement';
            $t_rules['date_depot2']='required';$t_attributes['date_depot2']='Date de dépôt du 3ème règlement';
            $t_rules['typepmt3']='required';$t_attributes['typepmt3']='Type de paiement du 3ème règlement';
            $nb_reglement++;
            $total_reglement+=intval($request->credit3);
        }

        //Si 4e paiement : credit4 compte4 typepmt4 obs4
        if(($request->credit4!="")||($request->typepmt4!="")||($request->obs4!="")) {
            $t_rules['credit4']='required';$t_attributes['credit3']='Crédit du 4ème règlement';
            //$t_rules['compte4']='required';$t_attributes['compte4']='Compte du 4ème règlement';
            $t_rules['date_depot4']='required';$t_attributes['date_depot2']='Date de dépôt du 4ème règlement';
            $t_rules['typepmt4']='required';$t_attributes['typepmt4']='Type de paiement du 4ème règlement';
            $nb_reglement++;
            $total_reglement+=intval($request->credit3);
        }

        //Si 3e paiement : credit5 compte5 typepmt5 obs5
        if(($request->credit5!="")||($request->typepmt5!="")||($request->obs5!="")) {
            $t_rules['credit5']='required';$t_attributes['credit5']='Crédit du 5ème règlement';
            //$t_rules['compte5']='required';$t_attributes['compte5']='Compte du 5ème règlement';
            $t_rules['date_depot5']='required';$t_attributes['date_depot5']='Date de dépôt du 5ème règlement';
            $t_rules['typepmt5']='required';$t_attributes['typepmt5']='Type de paiement du 5ème règlement';
            $nb_reglement++;
            $total_reglement+=intval($request->credit3);
        }

        $validator = Validator::make($request->all(),$t_rules);
        $validator->setAttributeNames($t_attributes);
        $liste_cotisations=$request->liste_cotisations;
        if ($validator->fails()) {
            Session::put('liste_cotisations', $liste_cotisations);
            return redirect()->back()
                ->withInput()
                ->withErrors($validator->errors())
                ->with("cotisations",$liste_cotisations);
        }

        $liste_cotisations=$request->liste_cotisations;
        $liste_new_cotisation_id="";
        $k=0;
        //Création des n règlements
        for($i=0;$i<$nb_reglement;$i++) {
            $cotisation = new Cotisation;
            $cotisation->sonum      =   $request->sonum;
            $cotisation->exercice   =   $request->exercice;
            $date = $request->date;
            $cotisation->date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;

            $cotisation->type_cotis =   $request->type_cotis;
            $cotisation->type_ope =   'REG'; //Règlement
            $cotisation->nbmois     =   $request->nbmois;
            $mois = $request->mois;
            $cotisation->mois       =   ($mois!="")?date('Y-m-d', strtotime(str_replace('/', '-', $mois))):"" ;
            $cotisation->bdx        =   $request->bdx;
            $cotisation->bdx_prive  =   $request->bdx_prive;
            $cotisation->nbsal      =   $request->nbsal;
            $cotisation->assiette   =   0;//$request->assiette;
            $cotisation->clr        =   0;//$request->clr;
            $cotisation->ccpf       =   0;//$request->ccpf;
            //$date = $request->date;
            //$cotisation->encais_date=  ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
            $cotisation->encais_date= null; // 08/06/2022 demande ticket VV2-UB4-BPS1
            $cotisation->encais_compte= $request->encais_compte;
            $cotisation->lettrage = "";
            $cotisation->debit = 0; //Valeur par défaut lors de la création


            if($i==0) {
                $cotisation->credit     =   $request->credit1;
                $cotisation->compte     =   $request->compte1;
                $cotisation->typepmt    =   $request->typepmt1;
                $date = $request->date_depot1;
                $cotisation->date_depot    =  ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
                $cotisation->observation=   $request->obs1;
            }
            if($i==1) {
                $cotisation->credit     =   $request->credit2;
                $cotisation->compte     =   $request->compte2;
                $cotisation->typepmt    =   $request->typepmt2;
                $date = $request->date_depot2;
                $cotisation->date_depot    =  ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
                $cotisation->observation=   $request->obs2;
            }
            if($i==2) {
                $cotisation->credit     =   $request->credit3;
                $cotisation->compte     =   $request->compte3;
                $cotisation->typepmt    =   $request->typepmt3;
                $date = $request->date_depot3;
                $cotisation->date_depot    =  ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
                $cotisation->observation=   $request->obs3;
            }
            if($i==3) {
                $cotisation->credit     =   $request->credit4;
                $cotisation->compte     =   $request->compte4;
                $cotisation->typepmt    =   $request->typepmt4;
                $date = $request->date_depot4;
                $cotisation->date_depot =  ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
                $cotisation->observation=   $request->obs4;
            }
            if($i==4) {
                $cotisation->credit     =   $request->credit5;
                $cotisation->compte     =   $request->compte5;
                $cotisation->typepmt    =   $request->typepmt5;
                $date = $request->date_depot5;
                $cotisation->date_depot =  ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
                $cotisation->observation=   $request->obs5;
            }
            $cotisation->save();

            //LOG de la transaction
            $cotisation->log_transaction('','I');

            $liste_new_cotisation_id.=(($liste_new_cotisation_id=="")?"":",").$cotisation->id;
        }

        return Redirect::to('recouvrement/cotisation_annee/'.$request->sonum.'/'.$request->exercice);
    }

    public function store_reglement_lettrage(Request $request)
    {

        $nb_reglement=1;
        //Vérif saisie
        $total_reglement=intval($request->credit1);
        $t_rules=[
            'sonum' => 'required',
            'date' => 'required',
            'exercice' => 'required|max:4',
            'type_cotis' => 'required',
            'nbmois' => 'numeric|required|min:1',
            'mois' => 'required',
            'bdx' => '',
            'bdx_prive' => '',
            'nbsal' => 'required|numeric',
            'encais_date' => '',
            'encais_compte' => '',
            'credit1' => 'numeric|required',
            'compte1' => '',
            'typepmt1' => 'required',
            'date_depot1' => '',
            'obs' => '',
            'assiette' => 'required|numeric|min:1',
            'clr' => 'numeric',
            'ccpf' => 'numeric|required',
            'credit' => 'numeric|required',
        ];

        $t_attributes=[
            'sonum' => 'Employeur',
            'type_cotis' => 'Type de cotisation',
            'date' => 'Date d\'entrée',
            'assiette' => 'Assiette',
            'clr' => 'CLR',
            'ccpf' => 'CCPF',
            'mois' => 'Mois',
            'nbmois' => 'Nombre de mois',
            'encais_date' => 'Date d\'encaissement',
            'encais_compte' => 'Compte',
            'type_cotis' => 'Type de cotisation',
            'date_depot1' => 'Date de dépôt',
            'exercice' => 'Exercice',
            'nbsal' => 'Nombre de salariés',
            'bdx' => 'Bordereau',
            'bdx_prive' => '',
            'credit1' => 'Crédit du 1er règlement',
            'compte1' => 'Compte du 1er règlement',
            'typepmt1' => 'Type de paiement du 1er règlement',
        ];
        //Si 2e paiement : credit2 compte2 typepmt2 obs2
        if(($request->credit2!="")||($request->typepmt2!="")||($request->obs2!="")) {
            $t_rules['credit2']='required';$t_attributes['credit2']='Crédit du 2ème règlement';
            //$t_rules['compte2']='required';$t_attributes['compte2']='Compte du 2ème règlement';
            $t_rules['date_depot2']='required';$t_attributes['date_depot2']='Date de dépôt du 2ème règlement';
            $t_rules['typepmt2']='required';$t_attributes['typepmt2']='Type de paiement du 2ème règlement';
            $nb_reglement++;
            $total_reglement+=intval($request->credit2);
        }
        //Si 3e paiement : credit3 compte3 typepmt3 obs3
        if(($request->credit3!="")||($request->typepmt3!="")||($request->obs3!="")) {
            $t_rules['credit3']='required';$t_attributes['credit3']='Crédit du 3ème règlement';
            //$t_rules['compte3']='required';$t_attributes['compte3']='Compte du 3ème règlement';
            $t_rules['date_depot2']='required';$t_attributes['date_depot2']='Date de dépôt du 3ème règlement';
            $t_rules['typepmt3']='required';$t_attributes['typepmt3']='Type de paiement du 3ème règlement';
            $nb_reglement++;
            $total_reglement+=intval($request->credit3);
        }
        //Si 4e paiement : credit4 compte4 typepmt4 obs4
        if(($request->credit4!="")||($request->typepmt4!="")||($request->obs4!="")) {
            $t_rules['credit4']='required';$t_attributes['credit3']='Crédit du 4ème règlement';
            //$t_rules['compte4']='required';$t_attributes['compte4']='Compte du 4ème règlement';
            $t_rules['date_depot4']='required';$t_attributes['date_depot2']='Date de dépôt du 4ème règlement';
            $t_rules['typepmt4']='required';$t_attributes['typepmt4']='Type de paiement du 4ème règlement';
            $nb_reglement++;
            $total_reglement+=intval($request->credit3);
        }
        //Si 3e paiement : credit5 compte5 typepmt5 obs5
        if(($request->credit5!="")||($request->typepmt5!="")||($request->obs5!="")) {
            $t_rules['credit5']='required';$t_attributes['credit5']='Crédit du 5ème règlement';
            //$t_rules['compte5']='required';$t_attributes['compte5']='Compte du 5ème règlement';
            $t_rules['date_depot5']='required';$t_attributes['date_depot5']='Date de dépôt du 5ème règlement';
            $t_rules['typepmt5']='required';$t_attributes['typepmt5']='Type de paiement du 5ème règlement';
            $nb_reglement++;
            $total_reglement+=intval($request->credit3);
        }
        if($total_reglement!=$request->credit) {
            /*
            $diff=intval($total_reglement)-intval($request->credit);

            if($diff>0) $msg='trop perçu de '.$diff.' CFP';
            else $msg='manque '.$diff.' CFP';
            $t_rules['egalite']='required';$t_attributes['egalite']='Cumul des règlements ne correspond pas aux cotisations ('.$msg.")";
            */
        }
        $validator = Validator::make($request->all(),$t_rules);
        $validator->setAttributeNames($t_attributes);
        $liste_cotisations=$request->liste_cotisations;
        if ($validator->fails()) {
            Session::put('liste_cotisations', $liste_cotisations);
            return redirect()->back()
                ->withInput()
                ->withErrors($validator->errors())
                ->with("cotisations",$liste_cotisations);
        }
        //

        $liste_cotisations=$request->liste_cotisations;
        $liste_new_cotisation_id="";
        $k=0;
        //Création des n règlements
        for($i=0;$i<$nb_reglement;$i++) {
            $cotisation = new Cotisation;
            $cotisation->sonum      =   $request->sonum;
            $cotisation->exercice   =   $request->exercice;
            $date = $request->date;
            $cotisation->date = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;

            $cotisation->type_cotis =   $request->type_cotis;
            $cotisation->type_ope =   'REG'; //Règlement
            $cotisation->nbmois     =   $request->nbmois;
            $mois = $request->mois;
            $cotisation->mois       =   ($mois!="")?date('Y-m-d', strtotime(str_replace('/', '-', $mois))):"" ;
            $cotisation->bdx        =   $request->bdx;
            $cotisation->bdx_prive  =   $request->bdx_prive;
            $cotisation->nbsal      =   $request->nbsal;
            $cotisation->assiette   =   $request->assiette;
            $cotisation->clr        =   0;//$request->clr;
            $cotisation->ccpf       =   0;//$request->ccpf;
            $date = $request->date;
            $cotisation->encais_date=  ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null;

            $cotisation->encais_compte= $request->encais_compte;
            $cotisation->lettrage = $liste_cotisations;
            $cotisation->debit = 0; //Valeur par défaut lors de la création


            if($i==0) {
                $cotisation->credit     =   $request->credit1;
                $cotisation->compte     =   $request->compte1;
                $cotisation->typepmt    =   $request->typepmt1;
                $date = $request->date_depot1;
                $cotisation->date_depot    =  ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
                $cotisation->observation=   $request->obs1;
            }
            if($i==1) {
                $cotisation->credit     =   $request->credit2;
                $cotisation->compte     =   $request->compte2;
                $cotisation->typepmt    =   $request->typepmt2;
                $date = $request->date_depot2;
                $cotisation->date_depot    =  ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
                $cotisation->observation=   $request->obs2;
            }
            if($i==2) {
                $cotisation->credit     =   $request->credit3;
                $cotisation->compte     =   $request->compte3;
                $cotisation->typepmt    =   $request->typepmt3;
                $date = $request->date_depot3;
                $cotisation->date_depot    =  ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
                $cotisation->observation=   $request->obs3;
            }
            if($i==3) {
                $cotisation->credit     =   $request->credit4;
                $cotisation->compte     =   $request->compte4;
                $cotisation->typepmt    =   $request->typepmt4;
                $date = $request->date_depot4;
                $cotisation->date_depot =  ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
                $cotisation->observation=   $request->obs4;
            }
            if($i==4) {
                $cotisation->credit     =   $request->credit5;
                $cotisation->compte     =   $request->compte5;
                $cotisation->typepmt    =   $request->typepmt5;
                $date = $request->date_depot5;
                $cotisation->date_depot =  ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):"" ;
                $cotisation->observation=   $request->obs5;
            }
            $cotisation->save();

            //LOG de la transaction
            $cotisation->log_transaction('','I');

            $liste_new_cotisation_id.=(($liste_new_cotisation_id=="")?"":",").$cotisation->id;
        }

        //Lettre les cotisations associées
        $fields = explode(',', $liste_cotisations);
        $cotisations=Cotisation::wherein('id',$fields)->get();
        foreach($cotisations as $cotisation) {
            $cotisation->lettrage=$liste_new_cotisation_id;
            $cotisation->save();
            //LOG de la transaction
            $cotisation->log_transaction('','I');
        }
        return Redirect::to('recouvrement/cotisation_annee/'.$request->sonum.'/'.$request->exercice);
    }




    /**
     * Listes des employeurs
     */
    public function getListeEmployeur($avec_id=false)
    {
        $liste_employeur=Employeur::distinct()->select('nom','id')
            ->whereIn('statut',array('ACT','ASV'))
            ->orderBy(($avec_id)?'id':'nom')->pluck("nom", "id")->toArray();
        $liste_employeur2=array();
        foreach($liste_employeur as $id=>$nom) {
            $id_pad=str_pad($id,4,"0", STR_PAD_LEFT);
            $nom=trim($nom);
            $liste_employeur2[$id]=htmlentities(str_replace('"','',$nom));
            if($avec_id) $liste_employeur2[$id]=$id_pad." ".$liste_employeur2[$id];
            else $liste_employeur2[$id]=$liste_employeur2[$id]." (".$id_pad.")";
        }
        asort($liste_employeur2);
        return $liste_employeur2;
    }


    /**
     * Listes des exercices
     */
    public function getListeExercices()
    {
        $exercices = Parametre::where('ref','=','TAUX_CLR_CCPF')->first()->Exercices;

        return $exercices;
    }


    /**
     * Listes des exercices sur 2 ans
     */
    public function getListeExercicesBi()
    {
        $exercices = $this->getListeExercices();
        $nb_exercices=count($exercices );
        $k=0;$t=array();
        foreach($exercices as $exercice) {
            $k++;
            $exercice_min=intval($exercice)-1;
            $exercice_max=intval($exercice)+1;
            if($k%2==0) {
                $t[$exercice_min."-".$exercice]=$exercice_min." - ".$exercice;
                if($k<$nb_exercices) $t[$exercice."-".$exercice_max]=$exercice." - ".$exercice_max;
            }
        }
        arsort($t);
        $t['*']='Tous';
        return $t;
    }

    /**
     * Listes des Types de paiement
     */
    public function getTypesPaiement()
    {
       $types=[''=>'','A'=>'Autre','B' => 'Banque','E' => 'Espèce',
            'T' => 'Trésor','V' => 'Virement','P' => 'Prélèvement automatique',
            '€' => 'Euro','N' => 'Nul'];
        return $types;
    }


    /**
     * Listes des Opérations
     */
    public function getTypesOperations()
    {
       $operations=[''=>' ',
            'DNT'=>'DNT - Cotisation ou déclaration nominative trimestrielle',
            'DNM' => 'DNM - Cotisation ou déclaration nominative mensuelle',
            'TAF' => 'TAF - Taxation forfaitaire',
            'TAO' => 'TAO - Taxation d’office',
            'AST' => 'AST - Astreinte',
            'MAJ' => 'MAJ - Majorations',
            'ANN' => 'ANN - Annulation',
            'REG' => 'REG - Règlement (crédit)'
            ];
        return $operations;
    }




    /**
     * Listes des Types de cotisation
     */
    public function getTypesCotisation()
    {
        /*
       $types=[''=>'','ENC'=>'Encaissement','RAN' => 'Report à nouveau',
            'RAP' => 'Rappel','CAT' => 'Cession activité temporaire',
            'CAD' => 'Cession activité définitive','PEC' => 'Paiement echelonné'
            ];
            */

       $types=['ENC'=>'Encaissement',
            'RAP' => 'Rappel',
            'PEC' => 'Paiement échelonné',
            'CST' => 'Constats',
            'CAD' => "Cessation d'activité définitive",
            'CAT' => "Cessation d'activité temporaire"
            ];
        return $types;
    }
}
