<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\Models\User;
use App\Models\Role2;
use App\Models\Creancier;
use App\Models\Imputation;
use App\Models\Mandat;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use App\Http\Requests\CreancierRequest;
use Response;
use App\Models\Parametre;
use Illuminate\Http\Request;
use App\Http\Requests\BeneficiaireAutoRequest;
class CreanciersController extends Controller {
 
    /**
     * Liste
     */
    public function index($exercice="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $exercices = $this->getListeExercicesBi();  

        if($exercice!="*") {
            if($exercice=="") $exercice=intval(date('Y'))."-".(intval(date('Y'))-1);
            $list_exercice="";
            if(strlen($exercice)==9)  $list_exercice=explode('-',$exercice);

            if($list_exercice!='') {
                $creanciers=Creancier::join('mandats','mandats.id','=','creanciers.idmandat')
                    ->wherein('mandats.exercice',$list_exercice)
                    ->orderby('nom')
                    ->orderby('prenom')->get();
            } else {
                $creanciers=Creancier::join('mandats','mandats.id','=','creanciers.idmandat')
                    ->orderby('nom')
                    ->orderby('prenom')->whereIn('idmandat',$mandats)->get(); 
            }
            //if($list_exercice!='') 
            //        $obj_mandats = Mandat::wherein('exercice',$list_exercice);
            //else  $obj_mandats = Mandat::where('id','<>','');
            //$mandats=$obj_mandats->orderby('id','DESC')->pluck('id')->toArray(); 

            //$creanciers=:Creancier:orderby('nom')->orderby('prenom')->whereIn('idmandat',$mandats)->get();


        } else {
            $creanciers=Creancier::orderby('nom')->orderby('prenom')->get();     
        }

        return View::make('tiers.creanciers.index', [ 
            'user'=>$user,
            'creanciers' => $creanciers,
           'exercice' => $exercice,
            'exercices' => $exercices,
        ]);
    }


     public function create()
    {
        $user=User::where('id','=',Session::get('id'))->first();
        return View::make('tiers.creanciers.create', 
            [
            'user'=>$user,
            ]);
    }
 
     public function create_avec_mandat($mandat_id="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $mandat=Mandat::find($mandat_id);
        $imputations=Imputation::where('idmandat','=',$mandat_id)
            ->select('id',db::raw("CONCAT(id,' ',designation) as libelle"))
            ->pluck("libelle", "id")->toArray();

        $imputation="";
        foreach($imputations as $id=>$libelle) {$imputation=$id;break;}

        return View::make('tiers.creanciers.create', ['user'=>$user,'mandat' => $mandat
            , "imputations" => $imputations, "imputation" => $imputation]);
    }


    public function store(CreancierRequest $request)
    {
        $mode_frame=$request->mode_frame;
        $origine=$request->origine;

        $creancier = new Creancier;
        $creancier->num_creancier = $request->num_creancier;
        $creancier->nom = $request->nom;
        
        if($origine<>'EMP') { 
            $creancier->prenom = $request->prenom;
            if($request->datenaiss=="00/00/0000") $request->datenaiss=null;
            $date = $request->datenaiss;

            $creancier->datenaiss = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;
        } else {
            $creancier->prenom="";
            $creancier->datenaiss=null;
        }

        $creancier->bqcle_creancier = $request->bqcle_creancier;
        $creancier->compte = strtoupper($request->compte);
        $creancier->montant = $request->montant;
        $creancier->idmandat = $request->idmandat;
        $creancier->obs = $request->obs;
        $creancier->typepmt = $request->typepmt;
        $creancier->idimp_mdt = $request->idimp_mdt;
        $creancier->save();
        if($mode_frame==true) {
            $title="Création effectuée";
            $msg="<blockquote><h2>Le Créancier a été créée.</h2></blockquote>".
            "<br><br>".
            "Vous pouvez fermer cette fenêtre la fiche Mandat sera enregistrée et réactualisée.";
            return View::make('/tiers/creanciers/close', ['msg' => $msg
                ,'title' => $title]);
        }
        return Redirect::to('tiers/creanciers/');
     }
 

    public function edit($id)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $creancier=Creancier::find($id);
        if(!$creancier) return;

        $imputations=Imputation::where('idmandat','=',$creancier->idmandat)
            ->select('id',db::raw("CONCAT(id,' ',designation) as libelle"))
            ->pluck("libelle", "id")->toArray();

        return View::make('tiers.creanciers.edit', 
            [
            'creancier' => $creancier,
            'user'=>$user,
            "imputations" => $imputations
            ]);

    }


     public function edit_avec_mandat($id,$mandat_id="")
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $mandat=Mandat::find($mandat_id);
        $creancier=Creancier::find($id);
        if(!$creancier) return;

        $imputations=Imputation::where('idmandat','=',$mandat_id)
            ->select('id',db::raw("CONCAT(id,' ',designation) as libelle"))
            ->pluck("libelle", "id")->toArray();

        return View::make('tiers.creanciers.edit', [
            'creancier' => $creancier,
            'user'=>$user,
            'mandat' => $mandat, "imputations" => $imputations]);
    }


    public function show_frame($id)
    {
        return $this->show($id,true);
    }

    public function show($id,$frame=false)
    {
        $user=User::where('id','=',Session::get('id'))->first();
        $creancier=Creancier::find($id);
        $mandat=Mandat::find($creancier->idmandat);
        if(!$creancier) return;

        $imputations=Imputation::where('idmandat','=',$mandat->id)
            ->select('id',db::raw("CONCAT(id,' ',designation) as libelle"))
            ->pluck("libelle", "id")->toArray();

        return View::make('tiers.creanciers.show', 
            [
            'creancier' => $creancier,
            'mandat' => $mandat,
            'user'=>$user,
            'frame'=>$frame,
            "imputations" => $imputations
            ]);
     }
 


    public function update($id,CreancierRequest $request)
    {
        $mode_frame=$request->mode_frame;
        $creancier = Creancier::find($id);
        $creancier->num_creancier = $request->num_creancier;
        $creancier->nom = $request->nom;
        $creancier->prenom = $request->prenom;

        if($request->datenaiss=="00/00/0000") $request->datenaiss=null;
        $date = $request->datenaiss;
        $creancier->datenaiss = ($date!="")?date('Y-m-d', strtotime(str_replace('/', '-', $date))):null ;

        $creancier->bqcle_creancier = $request->bqcle_creancier;
        $creancier->compte = strtoupper($request->compte);
        $creancier->montant = $request->montant;
        $creancier->idmandat = $request->idmandat;
        $creancier->obs = $request->obs;
        $creancier->typepmt = $request->typepmt;
        $creancier->idimp_mdt = $request->idimp_mdt;
        $creancier->save();
        
        if($mode_frame==true) {
            $title="Modification effectuée";
            $msg="<blockquote><h2>Le créancier a été modifié.</h2></blockquote>".
            "<br><br>".
            "Vous pouvez fermer cette fenêtre la fiche Mandat sera enregistrée et réactualisée.";
            return View::make('/tiers/creanciers/close', ['msg' => $msg
                ,'title' => $title]);
        }
        

        return Redirect::to('tiers/creanciers/');
    }
 

    public function destroy($id)
    {
        Creancier::destroy($id);
 
        return Redirect::to('/tiers/creanciers/');
    }



 /**
     * Listes des exercices
     */
    public function getListeExercices()
    {
        $exercices = DB::table('mandats')->select('exercice')->distinct('exercice')->pluck('exercice')->toArray(); 

        return $exercices;
    }

    /**
     * Listes des exercices sur 2 ans
     */
    public function getListeExercicesBi()
    {
        $exercices = $this->getListeExercices();
        $nb_exercices=count($exercices );
        $k=0;$t=array();
        foreach($exercices as $exercice) {
            $k++;
            $exercice_min=intval($exercice)-1;
            $exercice_max=intval($exercice)+1;
            if($k%2==0) {
                $t[$exercice_min."-".$exercice]=$exercice_min." - ".$exercice;
                if($k<$nb_exercices) $t[$exercice."-".$exercice_max]=$exercice." - ".$exercice_max;
            }
        }
        arsort($t);
        $t['*']='Tous';
        return $t;
    }


    public function autocomplete_creancier_beneficiaire(Request $request)
    {        
        $param = $request->term;
        //$param = "JA";
        $associate = array();

        $search    = DB::select("select beneficiaires.id as id,
                CONCAT( beneficiaires.id,' ',TRIM(beneficiaires.nom),' ',TRIM(beneficiaires.prenom) ) as value,
                beneficiaires.id as beneficiaire_id,
                TRIM(beneficiaires.nom) as beneficiaire_nom,
                TRIM(prenom) as prenom,
                datenaiss as datenaiss,
                CONCAT(IBAN_banque,IBAN_guichet,IBAN_compte,IBAN_clerib) as compte,
                banque_id as banque_id,
                CONCAT(banque_id,' ',TRIM(banques.nom)) as banque_nom
                from beneficiaires
                left outer join beneficiaires_banques on beneficiaires_banques.id_benef=beneficiaires.id 
                AND beneficiaires_banques.actif=1
                left outer join banques on banques.id=beneficiaires_banques.id
                where beneficiaires.nom like ('{$param}%')
                or beneficiaires.id like ('{$param}%')
                order by beneficiaires.nom
            "
        );
    /*
        $search    = DB::select(
            "select beneficiaires.id as id,
            CONCAT( beneficiaires.id,' ',TRIM(beneficiaires.nom),' ',TRIM(beneficiaires.prenom) ) as value,
            beneficiaires.id as beneficiaire_id,
            TRIM(beneficiaires.nom) as beneficiaire_nom,
            TRIM(prenom) as prenom,
            datenaiss as datenaiss,
            compte as compte,
            banque_id as banque_id,
            CONCAT(banque_id,' ',TRIM(banques.nom)) as banque_nom

            from beneficiaires
            left outer join banques on banques.id=banque_id
            where beneficiaires.nom like ('{$param}%')
            or beneficiaires.id like ('{$param}%')
            order by beneficiaires.nom
            "
        );
    */
        foreach ($search as $result) {
            $associate[] = $result;
        }
        return json_encode($associate);
    }


public function autocomplete_creancier_employeur(Request $request)
    {        
        $param = $request->term;
        $associate = array();
        $search    = DB::select(
            "select employeurs.id as id,
            CONCAT( employeurs.id,' ',TRIM(employeurs.nom)) as value,
            employeurs.id as employeur_id,
            TRIM(employeurs.nom) as employeur_nom,
            compte as compte,
            banque_id as banque_id,
            CONCAT(banque_id,' ',TRIM(banques.nom)) as banque_nom

            from employeurs
            left outer join banques on banques.id=banque_id
            where employeurs.nom like ('{$param}%')
            or employeurs.id like ('{$param}%')
            order by employeurs.nom
            "
        );
        foreach ($search as $result) {
            $associate[] = $result;
        }
        return json_encode($associate);
    }


    public function autocomplete_creancier_creancier(Request $request)
    {        
        $param = $request->term;
        $associate = array();
        $search    = DB::select(
            "select distinct creanciers.num_creancier as id,
            CONCAT( creanciers.num_creancier,' ',TRIM(creanciers.nom),' ',TRIM(creanciers.prenom),' ',compte ) as value,
            creanciers.num_creancier as creancier_id,
            TRIM(creanciers.nom) as creancier_nom,
            TRIM(prenom) as prenom,
            datenaiss as datenaiss,
            compte as compte,
            bqcle_creancier as banque_id,
            CONCAT(bqcle_creancier,' ',TRIM(banques.nom)) as banque_nom

            from creanciers
            left outer join banques on banques.id=bqcle_creancier
            where creanciers.nom like ('{$param}%')
            or creanciers.id like ('{$param}%')
            order by creanciers.nom
            "
        );
        foreach ($search as $result) {
            $associate[] = $result;
        }
        return json_encode($associate);
    }
 
}