<?php namespace App\Http\Controllers\Editions;

use App\Http\Controllers\Controller;
use Auth\AuthController;
use App\Models\Plan;
use App\Models\Journal;
use App\Models\User;
use App\Models\Parametre;
use App\library\Numbers_Words_fr;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;
use Illuminate\Http\Request;

class PDF_grandlivre extends FPDF
{
    var $Titre="";
    var $param_EDI_CLR="";
    var $plan="";
    var $user="";

    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function set_titre($titre) { $this->titre=$titre;}
    function set_plan($plan) { $this->plan=$plan;}
    function set_user($user) { $this->user=$user;}

    public function setParametres()
    {
        
    }


    function Footer()
    {
        //Titre
        $this->SetFont("Arial",'',7);
        $this->SetY(285);
        $this->SetX(2);
        //$fpdf->Line(1,100,1,180);
        $this->Cell(60,7,utf8_decode("Edité par ".$this->user->nom),"T",0,'L');
        $this->Cell(100,7,"CPSWF - BP 125 MATA UTU - 98600 WALLIS - TEL : 72.01.20","T",0,'C');
        $this->Cell(40,7,$this->PageNo(),"T",0,'R');      
    }



    function Header()
    {

        $depX=10;
        $this->SetX($depX);
        $img_x=10;
        $img_y=10;


        $this->Image(url('img/logo_cpswf_imp.png'),$img_x,$img_y,40);
        $this->SetFont('Arial','',10);

        $depX=10;$depY=25;$l=60;$h=4;
        $this->SetXY(170,$depY);
        $this->SetFont('Arial','',10);
        $this->Cell(30,$h,date('d/m/Y'),0,0,'R');
        $this->SetFont('Arial','',9);
        
        $this->SetXY($depX,$depY);
        $this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),"",'L');  


        $depX=20;$depY=$this->GetY()+10;
        $this->SetXY($depX,$depY);
        $img_x=105-25;
        $img_y=$depY-3;
        $this->Image(url('img/bloc_adresse2.png'),$img_x,$img_y,55,13);
        $this->SetFont('Arial','B',14);
        $this->SetFillColor(153 , 204, 255);
        $this->Cell(175,$h+3,utf8_decode($this->titre),0,0,'C',0);

        $this->ln(20);
        $this->SetFont('Arial','BU',12);
        $this->Cell(65,$h+3,utf8_decode("Compte : ".$this->plan->numcpt." ".$this->plan->nomcpt),0,1,'L');
    }  
}


/* ************* Editions *************** */
class EditionGrandLivre extends Controller {

    public function Edition_grandlivre($compte,$exercice="") //Request $request,
    {
        $user=User::where('id','=',Session::get('id'))->first(); 

        $plan=Plan::where('numcpt','=',$compte)->first();
        $journaux=Journal::where('numcpt','=',$compte)->where('date','like',$exercice.'%')->orderby('date')->get();

        $Param_EDI_CLR=Parametre::where('ref','=','EDI_CLR_ATT_RET')->first()->value;
        $titre="GRAND LIVRE";
        $total=0;
        $total_debit=0;
        $total_credit=0;
        $budget=$plan->budget;
        $nb=0;
        foreach($journaux as $journal) { 
            $montant=$journal->credit-$journal->debit;
            $total+=$montant;
            $total_debit+=$journal->debit;
            $total_credit+=$journal->credit;
            $nb++;
        }

        $fpdf = new PDF_grandlivre();
        $fpdf->SetParametres();
        $fpdf->setParam_EDI_CLR($Param_EDI_CLR);
        $fpdf->set_titre($titre);
        $fpdf->set_plan($plan);
        $fpdf->set_user($user);
        $fpdf->AddPage();


        $depX=$fpdf->GetX();
        $depY=$fpdf->GetY();
        $h=7;
        $fpdf->SetXY($depX,$depY);
        

        $fpdf->SetFont('Arial','',10);
        $fpdf->SetX($depX);
        $fpdf->Cell(150,$h,utf8_decode("Budget alloué : ").number_format($budget,0,","," ")." CFP","",1,'R');
        $fpdf->Cell(50,$h,utf8_decode("DEBIT : ").number_format($total_debit,0,","," ")." CFP","",1,'L');
        $fpdf->Cell(50,$h,utf8_decode("CREDIT : ").number_format($total_credit,0,","," ")." CFP","",0,'L');
        $fpdf->Cell(100,$h,utf8_decode("SOLDE : ").number_format($total,0,","," ")." CFP","",1,'R');
        $fpdf->ln();

        $h=5;
        $fpdf->SetFont('Arial','B',9);
        $t_cols=['DATE','N°COMPTE','REFERENCE','LIBELLE','DEBIT CFP','CREDIT CFP','TOTAL CFP'];
        $w=[20,20,23,67,20,20,20];
        $fpdf->SetFillColor(153 , 204, 255);
        $k=0;
        for($k=0;$k<7;$k++) {
            $fpdf->Cell($w[$k],$h,utf8_decode($t_cols[$k]),1,0,'C',1);
        }
        $fpdf->ln();
        $fpdf->SetFont('Arial','',9);
        $total=0;
        $total_debit=0;
        $total_credit=0;
        $k=0;
        $lgmax=40;
        foreach($journaux as $journal) { 
            $k++;
            $montant=$journal->credit-$journal->debit;
            $libelle=$journal->libelle;
            if(strlen($libelle)>$lgmax) $libelle=substr($journal->libelle,0,$lgmax);
            $fpdf->Cell($w[0],$h,$journal->date,1,0,'C');
            $fpdf->Cell($w[1],$h,$journal->numcpt,1,0,'C');
            $fpdf->Cell($w[2],$h,$journal->ref,1,0,'L');
            $fpdf->Cell($w[3],$h,utf8_decode($libelle),1,0,'L');
            $fpdf->Cell($w[4],$h,number_format($journal->debit,0,","," "),1,0,'R');
            $fpdf->Cell($w[5],$h,number_format($journal->credit,0,","," "),1,0,'R');
            $fpdf->Cell($w[6],$h,number_format($montant,0,","," "),1,0,'R');
            $fpdf->ln();
            $total+=$montant;
            $total_debit+=$journal->debit;
            $total_credit+=$journal->credit;
            if( ($fpdf->GetY()>=250) && (($nb-$k)>2) ) {
                $fpdf->AddPage();
                $fpdf->SetY(80);
                //$fpdf->SetY($fpdf->GetY()-10);
                $fpdf->Cell(65,$h,utf8_decode("(suite)"),0,1,'L');
                $fpdf->ln();
            }
        }
        $fpdf->SetFont('Arial','BU',10);
        $fpdf->Cell($w[0]+$w[1]+$w[2]+$w[3],$h,"Total :",0,0,'R');
        $fpdf->SetFont('Arial','',8);
        $fpdf->Cell($w[4],$h,number_format($total_debit,0,","," "),1,0,'R');
        $fpdf->Cell($w[5],$h,number_format($total_credit,0,","," "),1,0,'R');
        $fpdf->Cell($w[6],$h,number_format($total,0,","," "),1,0,'R');
        $fpdf->ln();




        $fpdf->ln(10);
        $fpdf->SetFont('Arial','',9);
        $fpdf->SetX($depX);
        $fpdf->Cell(180,$h,utf8_decode("Fait à Mata-Utu, le ").date('d/m/Y'),"",0,'R');

                
        $nom_fichier="grand_livre_".$compte.".pdf";
        $fpdf->Output($nom_fichier.".pdf","I");
        exit();
    }



}



