<?php namespace App\Http\Controllers\Editions;

use Auth\AuthController;
use App\Http\Controllers\Controller;
use App\Models\Mandat;
use App\Models\Creancier;
use App\Models\Imputation;
use App\Models\Banque;
use App\Models\User;
use App\Models\Role2;
use App\Models\Parametre;
use App\library\Numbers_Words_fr;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use DB;

use Codedge\Fpdf\Fpdf\Fpdf;



class PDF3 extends FPDF
{
    var $Titre="";
    var $user_nom="";
    var $banque_nom="";
    var $num_bordereau="";
    var $suite="";
    var $param_EDI_CLR="";
    var $param_EDI_LIEU="";
    var $param_EDI_SIGNATAIRE="";
    var $nom_directeur="";
    var $civilite_directeur=""; 
    var $modele="";
    var $exercice="";
     var $compte_CLR="";

    function setModele($modele) { $this->modele=$modele;}
    function setCompte_CLR($compte_CLR) { $this->compte_CLR=$compte_CLR;}
    function setExercice($exercice) { $this->exercice=$exercice;}
    function setTitre($titre) { $this->Titre=$titre;}
    function setIdentifiant($identifiant) { $this->identifiant=$identifiant;}
    function setUserNom($user_nom) { $this->user_nom=$user_nom;}
    function setBanqueNom($banque_nom) { $this->banque_nom=$banque_nom;}
    function setNumBordereau($num_bordereau) { $this->num_bordereau=$num_bordereau;}
    function setSuite($suite) { $this->suite=$suite;}
    function setParam_EDI_CLR($param_EDI_CLR) { $this->param_EDI_CLR=$param_EDI_CLR;}
    function setParam_EDI_LIEU($param_EDI_LIEU) { $this->param_EDI_LIEU=$param_EDI_LIEU;}
    function setParam_EDI_SIGNATAIRE($param_EDI_SIGNATAIRE) { $this->param_EDI_SIGNATAIRE=$param_EDI_SIGNATAIRE;}
    function setNom_directeur($nom_directeur) { $this->nom_directeur=$nom_directeur;}
    function setCivilite_directeur($civilite_directeur) { $this->civilite_directeur=$civilite_directeur;}


    public function setParametres()
    {
        //Paramètres
        $user=User::where('id','=',Session::get('id'))->first();
        $this->setUserNom($user->FullName);
        $this->setNom_directeur(Parametre::where('ref','=','EDI_NOM_DIRECTEUR')->value('value'));
        $this->setCivilite_directeur(Parametre::where('ref','=','EDI_CIVILITE_DIRECTEUR')->value('value'));
        $this->setParam_EDI_LIEU(Parametre::where('ref','=','EDI_LIEU')->value('value'));
        $this->setParam_EDI_SIGNATAIRE(Parametre::where('ref','=','EDI_SIGNATAIRE')->value('value'));
        $this->setParam_EDI_CLR(Parametre::where('ref','=','EDI_CLR')->value('value'));
    }


    function Footer()
    {
        $this->SetFont('Arial','BU',12);
        $depX=7;$depY=143;$l=93;$h=7;$h2=23;
        $this->SetXY($depX,$depY);
        $this->SetFont('Arial','',8);
        $this->Cell($l,$h,utf8_decode("Désignation du créancier"),"TLR",2,'L');
        $this->SetFont('Arial','BI',12);
        $this->Cell($l,$h,utf8_decode(" M.le Directeur des Finances Publiques ./."),"BLR",2,'L');
        $this->SetFont('Arial','',8);
        $this->Cell($l,$h,utf8_decode("Pièces justificatives de la dépense :"),"TLR",2,'L');
        $this->Cell($l,$h2,"","BLR",2,'L');

        $this->Cell($l,$h,utf8_decode("Compte à créditer :"),"TLR",2,'L');
        $this->Cell($l,$h/2,utf8_decode("(Virement dans un établissement de crédit ou chez un comptable du"),"LR",2,'L');
        $this->Cell($l,$h/2,utf8_decode("Trésor)"),"LR",2,'L');
        $this->Cell($l,$h+$h+2,"","BLR",2,'L');
        $this->Cell($l,$h-2,"","TLR",2,'L');
        $this->Cell($l,$h/2,utf8_decode("A servir seulement en cas de virement postal."),"LR",2,'L');
        $this->Cell($l,$h/2,utf8_decode("Objet du virement :)"),"LR",2,'L');
        $this->Cell($l,$h,"","LR",2,'L');
        $this->Cell($l,$h,utf8_decode("COMPTE A CREDITER - Bénéficiaire :)"),"LR",2,'L');
        $this->Cell($l,$h,"","LR",2,'L');
        $this->Cell($l,$h/2,utf8_decode("C/c postal:)"),"LR",2,'L');
        $this->Cell($l,$h/2,utf8_decode("Centre de chèques postaux :"),"LR",2,'L');
        $this->Cell($l,$h2+$h-2,"","BLR",2,'L');
        $this->SetFont('Times','',7);
        $this->Cell($l,$h/2,utf8_decode("1 ) Nom , prénoms, adresse omplète.Pour les sociétés :"),"",2,'L');
        $this->Cell($l,$h/2,utf8_decode("raison sociale exacte."),"",2,'L');

        $this->SetFont('Arial','BU',12);
        $depX=100;$l=100;$h=10;$h2=39;
        $this->SetXY($depX,$depY);
        $this->SetFont('Arial','',8);
        $this->Cell($l/2,$h,utf8_decode("Montant brut de l'ordonnancement :"),"TLR",0,'L');
        $this->Cell($l/2,$h,"","BTLR",1,'L');
        $this->SetX($depX);
        $this->Cell($l,$h,utf8_decode(" Somme nette à payer ou à virer(2)"),"LR",2,'L');
        $this->SetFont('Arial','',9);
        $this->Cell($l,$h,utf8_decode("Arrêter par nous le présent mandat de paiement à la somme de :"),"LR",2,'L');
        $this->Cell($l,$h2,"","LR",2,'L');
        $this->Cell($l,$h/2,"","LR",2,'L');
        $this->Cell($l,$h/2,"","TLR",2,'L');
        $this->SetFont('Arial','',8);
        $this->Cell($l,$h/2,utf8_decode("A servir dans tous les cas de paiement par virement."),"LR",2,'L');
        $this->Cell($l,$h-3,"","LR",2,'L');

        $this->Cell($l,$h,utf8_decode("COMPTE A CREDITER - Bénéficiaire :)"),"LR",2,'L');
        $this->Cell($l,$h/2+1,"","LR",2,'L');
        $this->Cell($l,$h/2,utf8_decode("Compte courant postal:)"),"LR",2,'L');
        $this->Cell($l,$h/2,utf8_decode("Centre de chèques postaux ou"),"LR",2,'L');
        $this->Cell($l,$h/2,utf8_decode("Etablissement mandataire"),"LR",2,'L');
        $this->Cell($l,$h/2,"","LR",2,'L');
        $this->Cell($l,$h/2,utf8_decode("Agence de "),"LR",2,'L');
        $this->Cell($l,$h/2,utf8_decode("Compte"),"LR",2,'L');
        $this->Cell($l,$h/2,"","BLR",2,'L');

        $this->SetXY(65,$depY+74.5);
        $this->SetFont('Arial','IB',12);
        $this->SetFillColor(255,255,255);
        $this->Cell(70,$h-5,"PAIEMENT PAR VIREMENT","",2,'C',1);
    }



    function Header()
    {
        $this->SetFont('Arial','BU',12);
        $depX=7;$depY=7;$l=43;$h=7;
        $this->SetXY($depX,$depY);
        $this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),"",'C');
        $this->SetX($depX);
        $this->Cell($l,$h,"","",2,'C');
        $this->Cell($l,$h,utf8_decode("C.".$this->compte_CLR),"LR",2,'C');
        //$this->Cell($l,$h,"","LR",2,'C');
        //Cadre
        $this->SetXY($depX,$depY);
        $this->Cell($l,42,"","TBLR",2,'C');

        $depX=50;$depY=7;$l=100;
        $this->SetXY($depX,$depY);
        $this->SetFont('Arial','',10);
        $this->Cell($l,10,utf8_decode("TERRITOIRE DES ILES WALLIS ET FUTUNA"),"TLR",2,'C');
        $this->SetFont('Arial','B',14);
        $this->Cell($l,10,utf8_decode($this->Titre),"LR",2,'C');
        $this->SetFont('Arial','B',10);
        $this->Cell($l,10,utf8_decode("EXERCICE ".$this->exercice),"LR",2,'C');
        $this->SetFont('Arial','',8);
        $this->Cell($l,4,utf8_decode("En vertu des crédits ouverts au titre du chapitre désigné ci-contre,"),"LR",2,'L');
        $this->Cell($l,4,utf8_decode("l'ordonnateur soussigné mandate sur la caisse du Préposé du"),"LR",2,'L');
        $this->Cell($l,4,utf8_decode("Trésor des Iles Wallis et Futuna.u"),"LBR",2,'L');
        
        $this->SetFont('Arial','BU',12);
        $depX=150;$depY=7;$l=50;$h=8;$h2=4.5;
        $this->SetXY($depX,$depY);
        //$this->MultiCell($l,$h,utf8_decode($this->param_EDI_CLR),'','2','C');
        $this->SetFont('Arial','',8);
        $this->Cell($l/2,$h,utf8_decode("Ministere du C.S."),"LRT",0,'C');
        $this->Cell($l/2,$h,"","BTR",1,'C');
        $this->SetX($depX);
        $this->Cell($l/2,$h,utf8_decode("Ordonnateur"),"LR",0,'C');
        $this->Cell($l/2,$h,"","BTR",1,'C');
        $this->SetX($depX);
        $this->Cell($l/2,$h2,utf8_decode("Mois et exercice"),"LR",0,'C');
        $this->Cell($l/2,$h2,"","TR",1,'C');
        $this->SetX($depX);
        $this->Cell($l/2,$h2,utf8_decode("et d'émission ..."),"LR",0,'C');
        $this->Cell($l/2,$h2,"","BR",1,'C');
        $this->SetX($depX);
        $this->Cell($l/2,$h2,utf8_decode("N° du bordereau"),"LR",0,'C');
        $this->Cell($l/2,$h2,"","TR",1,'C');
        $this->SetX($depX);
        $this->Cell($l/2,$h2,utf8_decode("d'émission"),"LR",0,'C');
        $this->Cell($l/2,$h2,"","BR",1,'C');
        $this->SetX($depX);
        $this->Cell($l/2,$h,utf8_decode("N° du Mandat"),"LBR",0,'C');
        $this->Cell($l/2,$h,"","BTR",1,'C');
    }  


}


/* ************* Editions *************** */
class EditionMandatPaiement extends Controller {


    public function mandat_mandat_pmt($mandat_id,$imputation_id="",$creancier_id="")
    {
        $user=User::where('id','=',Session::get('id'))->first(); 
        $date=date('d/m/Y');      

        //$creanciers=Creancier::where('idimp_mdt','=',$imputation_id)->get();
        $mandat=Mandat::find($mandat_id);
        if( (($imputation_id=="") ||($imputation_id=="0")) && ($creancier_id!="")) {
            $creancier=Creancier::find($creancier_id);
            $imputation_id=$creancier->idimp_mdt;
        }
        
        /*
        $mandat=Mandat::find($mandat_id);
        if($creancier_id=="") $imputations=Imputation::where('idmandat','=',$mandat_id)->get();
        else {
            $creancier=Creancier::find($creancier_id);
            $imputations=Imputation::where('id','=',$creancier->idimp_mdt)->get();
        }
        */
        $imputation=array();
        $creanciers=array();
        $montant_total=0;
        $type_imp="";
        if($imputation_id!="") {
            $imputations=Imputation::where('id','=',$imputation_id)->get();
            if($creancier_id!="" ) $creanciers=Creancier::where('id','=',$creancier_id)->get();
            else $creanciers=Creancier::where('idimp_mdt','=',$imputation_id)->get();
        } else {
            $imputations=Imputation::where('idmandat','=',$mandat_id)->get();
        }


        foreach($imputations as $imputation) {
            $type_imp=trim($imputation->type_imp);
            $montant_total+=$imputation->montant;
        }
        $font="Arial";
        //Document
        $titre="MANDAT DE PAIEMENT";
        $identifiant="MANDAT N°".$mandat_id;
        $nom_fichier="imputation_ccpf_".$mandat_id;
        
        if($type_imp=="CLS") $type_imp="CLR";
        $Param_EDI_CLR=Parametre::where('ref','=','DIV_TITRE_'.$type_imp)->first()->value;
        $compte_CLR=Parametre::where('ref','=','DIV_COMPTE_'.$type_imp)->first()->value;

        $mode='';
        if( (count($creanciers)>0) && (count($imputations)==1) ) {
            $mode='C';//Mode aavec cranciers
        }

        //Création de la page
        $fpdf = new PDF3();
        
        //Zone Entete adresse
        $fpdf->SetParametres();
        $fpdf->setModele("mandat_mandat_pmt");
        $fpdf->setExercice($mandat->exercice);
        $fpdf->setIdentifiant($identifiant);
        $fpdf->setParam_EDI_CLR($Param_EDI_CLR);
        $fpdf->setCompte_CLR($compte_CLR);
        $fpdf->setTitre($titre);
        $fpdf->AddPage();

        //Ordonateur
        $h=9;
        $depX=175;$depY=15;$l=35;
        $fpdf->SetXY($depX,$depY);
        $fpdf->SetFont('Arial','',10);
        $ordonnateur="9300";
        $mois_exercice=$mandat->exercice."/".substr($mandat->date_sai,3,2);
        $fpdf->Cell($l,$h,utf8_decode($ordonnateur),"L",2,'L');
        $fpdf->Cell($l,$h,$mois_exercice,"L",2,'L');
        $fpdf->Cell($l,$h,$mandat->id,"L",2,'L');
        $fpdf->Cell($l,$h,$mandat->id,"L",0,'L');
               
        //Objet
        $fpdf->ln(20);$h=10;
        $depX=7;$depY=49;$l=143;$l2=25;$l3=25;
        $fpdf->SetXY($depX,$depY);
        $fpdf->SetFont('Arial','BU',12);
        $fpdf->Cell($l,$h,utf8_decode("Objet de la dépense :"),"L",0,'L');
        $fpdf->SetFont('Arial','B',10);
        $fpdf->Cell($l2,$h,"Chap. et art.","BLR",0,'L');
        $fpdf->Cell($l3,$h,"Sommes","BLR",2,'L');
        $fpdf->SetFont('Arial','',10);

        $h=7;$k=0;
        $Ypos=$fpdf->GetY();
        if( $mode=='C' ) {
            $fpdf->SetFont('Arial','BI',12);
            $fpdf->SetY($Ypos-$h-1.5);
        }
        if(count($imputations)>0) {
            foreach($imputations as $imputation) {
                if( $mode!='C' ) {
                    $k++;
                    $fpdf->SetX($depX);
                    $fpdf->Cell($l,$h,utf8_decode($imputation->designation),"L",0,'L');
                } else {
                    $fpdf->SetX($depX+44);  
                    $fpdf->Cell($l,$h,utf8_decode($imputation->designation),"",0,'L');         
                }
                 
                if( $mode!='C' ) {
                    $fpdf->Cell($l2,$h,$imputation->cpt_imp,"LTBR",0,'L');
                    $fpdf->Cell($l3,$h,number_format($imputation->montant,0,","," "),"LTBR",2,'L');
                }
            }
        } 



        //Si des créanciers
        //$montant_total=0;
        if( $mode=='C' )  {
            $fpdf->SetFont('Arial','',12);
            $fpdf->SetX($depX);
            $fpdf->Cell($l,$h,"","LR",0,'L');
            $fpdf->Cell($l2,$h,"","LR",0,'L');
            $fpdf->Cell($l3,$h+1.5,"","LR",1,'L');
            $montant_total=0;$k=0;
            foreach($creanciers as $creancier) {
                $k++;
                $fpdf->SetX($depX);
                $fpdf->Cell($l,$h+4,utf8_decode($creancier->nom_complet),"LR",0,'L');
                $fpdf->Cell($l2,$h+4,$imputation->cpt_imp,"TBLR",0,'L');
                $fpdf->Cell($l3,$h+4,number_format($creancier->montant,0,","," "),"TBLR",2,'L');
                $montant_total+=$creancier->montant;
            }
        }

        for($j=$k;$k<12;$k++) 
        {
            $fpdf->SetX($depX);
            $fpdf->Cell($l,$h,"","LR",0,'L');
            $fpdf->Cell($l2,$h,"","LR",0,'L');
            $fpdf->Cell($l3,$h,"","LR",2,'L');
        }

        $fpdf->SetX($fpdf->GetX()-$l2);
        $fpdf->Cell($l2,$h+3," ","LR",0,'L');
        $fpdf->Cell($l3,$h+3,number_format($montant_total,0,","," "),"LR",2,'L');
        

        //Total en lettre
        $fpdf->ln(8);$posX=$depX+95;$l1=95;
        $fpdf->SetX($posX);
        $nw = new Numbers_Words_fr();
        $montant_lettre=ucfirst($nw->toWordsDec($montant_total,"CFP"));
        $fpdf->SetFont('Arial','',10);
        if( $mode=='C' ) {$fpdf->ln(8);$fpdf->SetX($posX);}
        $libelle=number_format($montant_total,0,","," ")." CFP soit : ".$montant_lettre;
        $fpdf->MultiCell($l1,$h,utf8_decode($libelle),"",'L');
        $fpdf->ln(3);
        $fpdf->SetX($posX);
        $fpdf->Cell($l1,$h,utf8_decode("Emis à Mata-Utu, le ").$date,"",2,'L');
        $fpdf->SetX($posX);
        $fpdf->Cell($l1,$h,"L'ordonnateur ","",2,'C');
        $fpdf->ln(7);$fpdf->SetX($posX);
        $fpdf->SetFont('Arial','B',12);
        $fpdf->Cell($l1,$h,utf8_decode("M. ".$fpdf->nom_directeur),"",2,'C');

        //Lieu
        /*
        $fpdf->ln(20);$h=7;
        $depX=20;$fpdf->SetX($depX);
        $fpdf->Cell(70,$h,$fpdf->param_EDI_LIEU.", le ".date('d/m/Y'),"",0,'L');
        $fpdf->Cell(60,$h,"Le Comptable","",0,'L');
        $fpdf->Cell(60,$h,"Le Directeur","",0,'L');
        */
        $fpdf->Output("mandat_paiement_".$mandat_id.".pdf","I");
        exit();
    }





}



